/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.client.gui;

import com.google.common.collect.ImmutableList;
import com.jdolphin.portalgun.client.gui.CreateWaypointScreen;
import com.jdolphin.portalgun.client.gui.WaypointInfoScreen;
import com.jdolphin.portalgun.init.PGPackets;
import com.jdolphin.portalgun.init.PGTags;
import com.jdolphin.portalgun.item.PortalGunItem;
import com.jdolphin.portalgun.packets.SBSetDestinationPacket;
import com.jdolphin.portalgun.util.Waypoint;
import com.jdolphin.portalgun.util.helpers.GuiHelper;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class WaypointScreen
extends Screen {
    public WaypointList waypointList;
    public Button addWaypoint;
    protected List<String> waypointCache;

    public WaypointScreen() {
        super((Component)Component.m_237115_((String)"menu.ricksportalgun.waypoints"));
    }

    protected void m_7856_() {
        super.m_7856_();
        assert (this.f_96541_ != null && this.f_96541_.f_91080_ != null && this.f_96541_.f_91074_ != null);
        LocalPlayer player = this.f_96541_.f_91074_;
        this.addWaypoint = (Button)this.m_142416_((GuiEventListener)new ImageButton(this.f_96543_ / 2 + 68, 26, 20, 20, 0, 37, 20, GuiHelper.BUTTONS_LOCATION, 256, 256, button -> this.f_96541_.m_91152_((Screen)new CreateWaypointScreen()), (Component)Component.m_237115_((String)"ricksportalgun.button.waypoint.new")));
        ItemStack stack = player.m_21205_();
        if (stack.m_204117_(PGTags.Items.PORTAL_GUNS)) {
            this.waypointList = (WaypointList)this.m_7787_((GuiEventListener)new WaypointList(this, this.f_96541_, stack));
        }
    }

    public void m_86600_() {
        super.m_86600_();
        ItemStack heldItem = this.f_96541_.f_91074_.m_21205_();
        if (heldItem.m_204117_(PGTags.Items.PORTAL_GUNS)) {
            if (!(this.waypointCache != null && this.waypointCache.equals(PortalGunItem.getWaypoints(heldItem)) || this.waypointList == null)) {
                this.waypointList.refreshEntries(heldItem);
            }
        } else {
            this.m_7379_();
        }
    }

    public void m_88315_(@NotNull GuiGraphics stack, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(stack);
        this.addWaypoint.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"ricksportalgun.button.waypoint.new")));
        if (this.waypointList != null) {
            this.waypointList.m_88315_(stack, pMouseX, pMouseY, pPartialTick);
        }
        GuiHelper.drawWhiteCenteredString(stack, (Component)Component.m_237115_((String)"ricksportalgun.button.waypoint.saved"), this.f_96543_ / 2, 30);
        assert (this.f_96541_ != null);
        Style style = GuiHelper.getStyle(this, pMouseX, pMouseY);
        if (style != null && style.m_131186_() != null) {
            this.m_280264_(stack, pMouseX, pMouseY, pPartialTick);
        }
        super.m_88315_(stack, pMouseX, pMouseY, pPartialTick);
    }

    public boolean m_7043_() {
        return false;
    }

    public static class WaypointList
    extends ContainerObjectSelectionList<WaypointEntry> {
        public final ItemStack stack;
        public final PortalGunItem item;
        public final WaypointScreen screen;

        public WaypointList(WaypointScreen waypointScreen, Minecraft minecraft, ItemStack stack) {
            super(minecraft, waypointScreen.f_96543_, waypointScreen.f_96544_, 58, waypointScreen.f_96544_ - 32, 24);
            this.m_93488_(false);
            this.m_93496_(false);
            this.stack = stack;
            this.screen = waypointScreen;
            this.item = (PortalGunItem)stack.m_41720_();
            this.refreshEntries(stack);
        }

        public void refreshEntries(ItemStack stack) {
            this.m_6702_().clear();
            List<String> waypoints = PortalGunItem.getWaypoints(stack);
            this.screen.waypointCache = waypoints;
            for (String str : waypoints) {
                Waypoint waypoint = Waypoint.getWaypoint(str);
                if (waypoint == null) {
                    LogManager.getLogger().warn("Failed to get Waypoint: {}", (Object)str);
                    continue;
                }
                this.m_7085_((AbstractSelectionList.Entry)new WaypointEntry(waypoint, this));
            }
        }

        protected int m_5756_() {
            return super.m_5756_() - 32;
        }

        public int m_5759_() {
            return super.m_5759_() - 32;
        }

        public static class WaypointEntry
        extends ContainerObjectSelectionList.Entry<WaypointEntry> {
            private final Waypoint waypoint;
            private final Button button;
            private final Button infoButton;
            protected WaypointList f_93521_;

            WaypointEntry(Waypoint waypoint, WaypointList list) {
                this.waypoint = waypoint;
                this.f_93521_ = list;
                this.button = Button.m_253074_((Component)Component.m_237113_((String)waypoint.getName()), pButton -> {
                    SBSetDestinationPacket packet = new SBSetDestinationPacket(waypoint);
                    PGPackets.INSTANCE.sendToServer((Object)packet);
                    list.f_93386_.m_91152_(null);
                }).m_252794_(16, 0).m_253046_(128, 20).m_253136_();
                this.infoButton = new ImageButton(0, 0, 20, 20, 20, 37, 20, GuiHelper.BUTTONS_LOCATION, 256, 256, button -> list.f_93386_.m_91152_((Screen)new WaypointInfoScreen((Component)Component.m_237115_((String)"ricksportalgun.button.waypoint.info"), waypoint)), (Component)Component.m_237115_((String)"ricksportalgun.button.waypoint.info"));
            }

            public void m_6311_(@NotNull GuiGraphics pPoseStack, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pIsMouseOver, float pPartialTick) {
                WaypointList wpList = this.f_93521_;
                if (pTop > wpList.f_93390_ && pTop + wpList.f_93387_ < wpList.f_93389_ - wpList.f_93387_) {
                    this.infoButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"ricksportalgun.button.waypoint.info")));
                    this.button.m_252865_(wpList.getWidth() / 2 - 64);
                    this.button.m_253211_(pTop);
                    this.button.m_93666_((Component)Component.m_237113_((String)this.waypoint.getName()));
                    this.button.m_88315_(pPoseStack, pMouseX, pMouseY, pPartialTick);
                    this.infoButton.m_252865_(wpList.getWidth() / 2 + 68);
                    this.infoButton.m_253211_(pTop);
                    this.infoButton.m_88315_(pPoseStack, pMouseX, pMouseY, pPartialTick);
                }
            }

            @NotNull
            public List<? extends NarratableEntry> m_142437_() {
                return ImmutableList.of((Object)this.button, (Object)this.infoButton);
            }

            @NotNull
            public List<? extends GuiEventListener> m_6702_() {
                return ImmutableList.of((Object)this.button, (Object)this.infoButton);
            }

            public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
                return this.button.m_6375_(pMouseX, pMouseY, pButton) || this.infoButton.m_6375_(pMouseX, pMouseY, pButton);
            }

            public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
                return this.button.m_6348_(pMouseX, pMouseY, pButton) || this.infoButton.m_6348_(pMouseX, pMouseY, pButton);
            }
        }
    }
}

