/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.client.gui.widget;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.jdolphin.portalgun.client.gui.AbstractBaseScreen;
import com.jdolphin.portalgun.client.gui.widget.ScrollableList;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.PlainTextButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

public class SuggestionTextFieldWidget
extends EditBox {
    private final List<String> suggestions;
    private final SuggestionList suggestionListWidget;

    public SuggestionTextFieldWidget(AbstractBaseScreen screen, int x, int y, int width, int height, MutableComponent text, List<String> suggestions) {
        super(Minecraft.m_91087_().f_91062_, x, y, width, height, (Component)text);
        this.suggestions = suggestions;
        this.suggestionListWidget = new SuggestionList(Minecraft.m_91087_(), width, height * 3, x, y + height, 14, this);
    }

    public SuggestionList getSuggestionList() {
        return this.suggestionListWidget;
    }

    public List<String> getSuggestions() {
        return this.suggestions;
    }

    public void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (!this.m_93696_()) {
            this.suggestionListWidget.visible = false;
        } else {
            this.suggestionListWidget.visible = true;
            this.suggestionListWidget.m_88315_(context, mouseX, mouseY, delta);
        }
        super.m_87963_(context, mouseX, mouseY, delta);
    }

    public void update() {
        List<String> suggestions = this.sortSuggestions(this.suggestions);
        this.suggestionListWidget.setSuggestions(suggestions);
        this.suggestionListWidget.setScrollAmount(0.0);
    }

    private List<String> sortSuggestions(List<String> suggestions) {
        String string = this.m_94155_().substring(0, this.m_94207_());
        int i = SuggestionTextFieldWidget.getStartOfCurrentWord(string);
        String string2 = string.substring(i).toLowerCase(Locale.ROOT);
        ArrayList list = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        for (String suggestion : suggestions) {
            String s = suggestion.substring(suggestion.indexOf(":") + 1);
            if (s.startsWith(string2)) {
                list.add(suggestion);
            }
            if (!suggestion.startsWith(string2)) {
                list2.add(suggestion);
                continue;
            }
            if (list.contains(suggestion)) continue;
            list.add(suggestion);
        }
        list.addAll(list2);
        return list;
    }

    private static int getStartOfCurrentWord(String input) {
        if (Strings.isNullOrEmpty((String)input)) {
            return 0;
        }
        int i = 0;
        Matcher matcher = Pattern.compile("(\\s+)").matcher(input);
        while (matcher.find()) {
            i = matcher.end();
        }
        return i;
    }

    public static class SuggestionList
    extends ScrollableList<SuggestionEntry> {
        private final SuggestionTextFieldWidget widget;

        public SuggestionList(Minecraft minecraft, int width, int height, int x, int y, int itemHeight, SuggestionTextFieldWidget widget) {
            super(minecraft, width, height, x, y, itemHeight);
            this.widget = widget;
            List<String> suggestions = widget.suggestions;
            this.setSuggestions(suggestions);
        }

        public void setSuggestions(List<String> suggestions) {
            this.clearEntries();
            for (String s : suggestions) {
                if (s != null && !s.isEmpty()) {
                    SuggestionEntry entry = new SuggestionEntry(s, this);
                    if (this.m_6702_().contains(entry)) continue;
                    this.addEntry(entry);
                    continue;
                }
                LogManager.getLogger().warn("Failed to get suggestion: {}", (Object)s);
            }
        }

        @Override
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            SuggestionEntry hoveredEntry = (SuggestionEntry)this.getEntryAtPosition(mouseX, mouseY);
            if (hoveredEntry == null) {
                this.widget.m_93692_(false);
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        @Override
        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (this.widget.m_93696_()) {
                int x1 = this.getLeft();
                int y1 = this.getTop();
                int x2 = this.getRight();
                int y2 = this.getBottom();
                graphics.m_280588_(x1, y1, x2, y2);
                graphics.m_280509_(x1, y1, x2, y2, -805306368);
                graphics.m_280618_();
                graphics.m_280637_(x1, y1, this.getWidth(), this.getHeight(), Color.WHITE.getRGB());
                super.m_88315_(graphics, mouseX, mouseY, delta);
            }
        }

        @Override
        public int getRowWidth() {
            return this.width - 6;
        }

        public void m_142291_(NarrationElementOutput output) {
            output.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.selection.usage"));
        }

        public static class SuggestionEntry
        extends ScrollableList.Entry<SuggestionEntry> {
            private final String string;
            private final Button button;
            protected SuggestionList list;
            private final SuggestionTextFieldWidget widget;

            SuggestionEntry(String suggestion, SuggestionList list) {
                this.string = suggestion;
                this.list = list;
                this.widget = list.widget;
                this.button = new PlainTextButton(0, 0, this.list.width - 6, list.itemHeight, (Component)Component.m_237113_((String)suggestion), pButton -> {
                    list.widget.m_94144_(suggestion);
                    list.widget.m_93692_(false);
                }, Minecraft.m_91087_().f_91062_);
            }

            @Override
            public void render(@NotNull GuiGraphics context, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float tickDelta) {
                if (this.widget.f_93624_) {
                    SuggestionList wpList = this.list;
                    if (top > wpList.headerHeight) {
                        this.button.m_252865_(wpList.getLeft() + 2);
                        this.button.m_253211_(top);
                        this.button.m_93666_((Component)Component.m_237113_((String)this.string));
                        this.button.m_88315_(context, mouseX, mouseY, tickDelta);
                    }
                }
            }

            @NotNull
            public List<? extends GuiEventListener> m_6702_() {
                return ImmutableList.of((Object)this.button);
            }

            public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
                return this.button.m_6375_(pMouseX, pMouseY, pButton);
            }

            public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
                return this.button.m_6348_(pMouseX, pMouseY, pButton);
            }

            @Override
            public boolean m_7282_() {
                return super.m_7282_();
            }
        }
    }
}

