/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.client.renderer;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.scores.Team;

public class LayeredEntityRenderer<P extends Entity, M extends EntityModel<P>>
extends EntityRenderer<P>
implements RenderLayerParent<P, M> {
    protected M model;
    protected final List<RenderLayer<P, M>> layers = Lists.newArrayList();

    protected LayeredEntityRenderer(EntityRendererProvider.Context pContext, M model) {
        super(pContext);
        this.model = model;
    }

    public final boolean addLayer(RenderLayer<P, M> pLayer) {
        return this.layers.add(pLayer);
    }

    public static boolean isEntityUpsideDown(Entity pEntity) {
        String s;
        if ((pEntity instanceof Player || pEntity.m_8077_()) && ("Dinnerbone".equals(s = ChatFormatting.m_126649_((String)pEntity.m_7755_().getString())) || "Grumm".equals(s))) {
            return !(pEntity instanceof Player) || ((Player)pEntity).m_36170_(PlayerModelPart.CAPE);
        }
        return false;
    }

    protected boolean isShaking(P pEntity) {
        return pEntity.m_146890_();
    }

    protected void setupRotations(P pEntityLiving, PoseStack pPoseStack, float pAgeInTicks, float pRotationYaw, float pPartialTicks) {
        if (this.isShaking(pEntityLiving)) {
            pRotationYaw += (float)(Math.cos((double)((Entity)pEntityLiving).f_19797_ * 3.25) * Math.PI * (double)0.4f);
        }
        if (!pEntityLiving.m_217003_(Pose.SLEEPING)) {
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - pRotationYaw));
        }
        if (LayeredEntityRenderer.isEntityUpsideDown(pEntityLiving)) {
            pPoseStack.m_252880_(0.0f, pEntityLiving.m_20206_() + 0.1f, 0.0f);
            pPoseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
    }

    protected float getFlipDegrees(P entity) {
        return 90.0f;
    }

    protected float getWhiteOverlayProgress(P entity, float pPartialTicks) {
        return 0.0f;
    }

    protected void scale(P entity, PoseStack pPoseStack, float pPartialTickTime) {
    }

    protected boolean m_6512_(P pEntity) {
        boolean flag;
        float f;
        double d0 = this.f_114476_.m_114471_(pEntity);
        float f2 = f = pEntity.m_20163_() ? 32.0f : 64.0f;
        if (d0 >= (double)(f * f)) {
            return false;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localplayer = minecraft.f_91074_;
        boolean bl = flag = !pEntity.m_20177_((Player)localplayer);
        if (pEntity != localplayer) {
            Team team = pEntity.m_5647_();
            Team team1 = localplayer.m_5647_();
            if (team != null) {
                Team.Visibility team$visibility = team.m_7470_();
                switch (team$visibility) {
                    case ALWAYS: {
                        return flag;
                    }
                    case NEVER: {
                        return false;
                    }
                    case HIDE_FOR_OTHER_TEAMS: {
                        return team1 == null ? flag : team.m_83536_(team1) && (team.m_6259_() || flag);
                    }
                    case HIDE_FOR_OWN_TEAM: {
                        return team1 == null ? flag : !team.m_83536_(team1) && flag;
                    }
                }
                return true;
            }
        }
        return Minecraft.m_91404_() && pEntity != minecraft.m_91288_() && flag && !pEntity.m_20160_();
    }

    public void m_7392_(P pEntity, float pEntityYaw, float pPartialTicks, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.m_85836_();
        float f = -Mth.m_14189_((float)pPartialTicks, (float)((Entity)pEntity).f_19859_, (float)pEntity.m_146908_());
        float f2 = pEntityYaw;
        float f6 = Mth.m_14179_((float)pPartialTicks, (float)((Entity)pEntity).f_19860_, (float)pEntity.m_146909_());
        if (LayeredEntityRenderer.isEntityUpsideDown(pEntity)) {
            f6 *= -1.0f;
            f2 *= -1.0f;
        }
        float f7 = this.getBob(pEntity, pPartialTicks);
        this.setupRotations(pEntity, pPoseStack, f7, f, pPartialTicks);
        pPoseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        this.scale(pEntity, pPoseStack, pPartialTicks);
        pPoseStack.m_252880_(0.0f, -1.501f, 0.0f);
        float f8 = 0.0f;
        float f5 = 0.0f;
        Minecraft minecraft = Minecraft.m_91087_();
        boolean flag = this.isBodyVisible(pEntity);
        boolean flag1 = !flag && !pEntity.m_20177_((Player)minecraft.f_91074_);
        boolean flag2 = minecraft.m_91314_(pEntity);
        RenderType rendertype = this.getRenderType(pEntity, flag, flag1, flag2);
        if (rendertype != null) {
            VertexConsumer vertexconsumer = pBuffer.m_6299_(rendertype);
            int i = LayeredEntityRenderer.getOverlayCoords(pEntity, this.getWhiteOverlayProgress(pEntity, pPartialTicks));
            this.model.m_7695_(pPoseStack, vertexconsumer, pPackedLight, i, 1.0f, 1.0f, 1.0f, flag1 ? 0.15f : 1.0f);
        }
        if (!pEntity.m_5833_()) {
            for (RenderLayer<P, M> renderlayer : this.layers) {
                renderlayer.m_6494_(pPoseStack, pBuffer, pPackedLight, pEntity, f5, f8, pPartialTicks, f7, f2, f6);
            }
        }
        pPoseStack.m_85849_();
        super.m_7392_(pEntity, pEntityYaw, pPartialTicks, pPoseStack, pBuffer, pPackedLight);
    }

    protected boolean isBodyVisible(P entity) {
        return !entity.m_20145_();
    }

    @Nullable
    protected RenderType getRenderType(P entity, boolean pBodyVisible, boolean pTranslucent, boolean pGlowing) {
        ResourceLocation resourcelocation = this.m_5478_(entity);
        if (pTranslucent) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (pBodyVisible) {
            return this.model.m_103119_(resourcelocation);
        }
        return pGlowing ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    public static int getOverlayCoords(Entity entity, float pU) {
        return OverlayTexture.f_118083_;
    }

    protected float getBob(P pLivingBase, float pPartialTick) {
        return (float)((Entity)pLivingBase).f_19797_ + pPartialTick;
    }

    public M m_7200_() {
        return this.model;
    }

    public ResourceLocation m_5478_(P pEntity) {
        return null;
    }
}

