/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.client.renderer;

import com.jdolphin.portalgun.client.model.PortalEntityModel;
import com.jdolphin.portalgun.entity.PortalEntity;
import com.jdolphin.portalgun.util.helpers.Helper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class PortalEntityRenderer
extends EntityRenderer<PortalEntity> {
    public static final ResourceLocation PORTAL_TEXTURE = Helper.createLocation("textures/entity/portal.png");
    public PortalEntityModel model;

    public PortalEntityRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.model = new PortalEntityModel(pContext.m_174023_(PortalEntityModel.LAYER_LOCATION));
    }

    protected boolean shouldShowName(@NotNull PortalEntity pEntity) {
        return false;
    }

    protected void openAnimation(PortalEntity state, PoseStack stack) {
        float f;
        if (state.f_19797_ < 20) {
            f = Mth.m_14179_((float)((float)state.f_19797_ / 20.0f), (float)0.0f, (float)1.0f);
            f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            stack.m_85841_(f, f, f);
        }
        if (state.f_19797_ > 180) {
            f = Mth.m_14179_((float)((float)state.f_19797_ / 20.0f), (float)1.0f, (float)0.0f);
            f = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            stack.m_85841_(f, f, f);
        }
    }

    public void render(PortalEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.m_85836_();
        this.openAnimation(pEntity, pMatrixStack);
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(pEntity.m_146908_() - 180.0f));
        VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110473_((ResourceLocation)PORTAL_TEXTURE));
        Color color = new Color(pEntity.getColor());
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        this.model.m_7695_(pMatrixStack, vertexconsumer, 0xF000F0, OverlayTexture.f_118083_, r, g, b, 1.0f);
        pMatrixStack.m_85849_();
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull PortalEntity pEntity) {
        return PORTAL_TEXTURE;
    }
}

