/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public final class PortalGunCommonConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Integer> randomizer_max;
    public static final ForgeConfigSpec.ConfigValue<Boolean> disable_locating;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> disabled_dimensions;

    public static List<? extends String> getBlacklistedDims() {
        return (List)disabled_dimensions.get();
    }

    public static boolean canLocate() {
        return (Boolean)disable_locating.get() == false;
    }

    public static int getMaxRandomizerDistance() {
        return (Integer)randomizer_max.get();
    }

    static {
        BUILDER.push("Rick's Portal Gun mod config");
        randomizer_max = BUILDER.comment("Maximum distance for randomizer. Default = 10000").define("randomizer_max", (Object)10000);
        disable_locating = BUILDER.comment("Disable locating biomes").define("disable_locating", false);
        disabled_dimensions = BUILDER.comment(new String[]{"List of Dimension IDs the portal gun can't travel to, everything else is allowed", "Separate every entry except the last one with commas"}).defineList("blacklisted_dimensions", (List)Lists.newArrayList(), String.class::isInstance);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

