/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.entity;

import com.jdolphin.portalgun.init.PGSounds;
import com.jdolphin.portalgun.util.PGTeleporter;
import com.jdolphin.portalgun.util.helpers.LevelHelper;
import java.awt.Color;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class PortalEntity
extends Projectile {
    private static final EntityDataAccessor<Integer> DATA_COLOR_ID = SynchedEntityData.m_135353_(PortalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final String TAG_DIMENSION = "PortalDimension";
    public static final String TAG_BPOS = "PortalPos";
    public static final String TAG_OPEN = "Open";
    public static final String TAG_NEW = "isSpawned";
    public static final String TAG_COOLDOWN = "Cooldown";
    private BlockPos bPos;
    private boolean acid;
    private int maxLifeTime;
    private boolean exists;
    private String dim;
    private int delay = 0;
    public int lifetime = 200;

    public PortalEntity(EntityType<? extends PortalEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_20157_() {
        if (this.m_9236_() instanceof ServerLevel && this.f_19817_) {
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, Level.ExplosionInteraction.BLOCK);
        }
    }

    public boolean exists() {
        return this.exists;
    }

    public void setMaxLifeTime(int lifetime) {
        this.maxLifeTime = lifetime;
    }

    public int getMaxLifeTime() {
        return this.maxLifeTime;
    }

    public void setColor(int color) {
        this.f_19804_.m_135381_(DATA_COLOR_ID, (Object)color);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(DATA_COLOR_ID);
    }

    public boolean isAcid() {
        return this.acid;
    }

    public void setPos(BlockPos pos) {
        this.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public void setAcid(boolean acid) {
        this.acid = acid;
    }

    public static boolean colliding(Entity entity1, Entity entity2) {
        return entity1.m_20191_().m_82381_(entity2.m_20191_());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_COLOR_ID, (Object)Color.GREEN.getRGB());
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.DISCARDED);
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_5825_() {
        return true;
    }

    public void setHopLocation(ResourceLocation dimension, BlockPos pos) {
        this.dim = dimension.toString();
        this.bPos = pos;
    }

    public BlockPos getHopLoc() {
        return this.bPos == null ? BlockPos.f_121853_ : this.bPos;
    }

    public String getHopDim() {
        return this.dim == null ? "minecraft:overworld" : this.dim;
    }

    protected void m_7378_(CompoundTag tag) {
        this.acid = tag.m_128471_("Bootleg");
        this.dim = tag.m_128461_(TAG_DIMENSION);
        this.bPos = NbtUtils.m_129239_((CompoundTag)((CompoundTag)tag.m_128423_(TAG_BPOS)));
        this.setColor(tag.m_128451_("Color"));
        this.lifetime = tag.m_128451_(TAG_OPEN);
        this.delay = tag.m_128451_(TAG_COOLDOWN);
        this.exists = tag.m_128471_(TAG_NEW);
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128379_("Bootleg", this.acid);
        tag.m_128379_(TAG_NEW, this.exists);
        tag.m_128359_(TAG_DIMENSION, this.getHopDim());
        tag.m_128365_(TAG_BPOS, (Tag)NbtUtils.m_129224_((BlockPos)this.getHopLoc()));
        tag.m_128405_("Color", this.getColor());
        tag.m_128405_(TAG_OPEN, this.lifetime);
        tag.m_128405_(TAG_COOLDOWN, this.delay);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    public static List<Entity> getEntitiesNearby(Entity entity, double range) {
        if (!entity.m_9236_().m_5776_()) {
            AABB boundingBox = entity.m_20191_().m_82400_(range);
            List entities = entity.m_9236_().m_45976_(Entity.class, boundingBox);
            entities.remove(entity);
            entities.removeIf(e -> e instanceof PortalEntity);
            entities.removeIf(e -> e instanceof EnderDragon);
            entities.removeIf(e -> e instanceof WitherBoss);
            entities.removeIf(e -> e instanceof Warden);
            entities.removeIf(e -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    return player.m_20092_() || player.m_8958_() || !player.m_6072_();
                }
                return false;
            });
            return entities;
        }
        return null;
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.exists) {
            LevelHelper.playSound(this.m_9236_(), this.m_20183_(), (SoundEvent)PGSounds.PORTAL_SHOOT.get(), SoundSource.PLAYERS);
        }
        this.exists = true;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().m_5776_()) {
            if (this.lifetime > 0) {
                --this.lifetime;
            }
            if (this.delay > 0) {
                --this.delay;
            }
            if (this.isAddedToWorld() && this.lifetime == 0) {
                this.m_6074_();
                return;
            }
            List<Entity> entityList = PortalEntity.getEntitiesNearby((Entity)this, 0.3);
            if (entityList != null) {
                for (Entity nearby : entityList) {
                    if (!this.acid) {
                        ResourceKey<Level> key = LevelHelper.getWorldKey(this.getHopDim());
                        ServerLevel serverlevel = LevelHelper.getServerWorld(this.m_9236_(), key);
                        BlockPos pos = this.getHopLoc();
                        if (!PortalEntity.colliding((Entity)this, nearby) || nearby.m_7306_((Entity)this) || nearby.m_20092_() || nearby.m_20159_() || serverlevel == null || serverlevel.m_5776_()) continue;
                        if (nearby.m_6072_() && this.delay == 0) {
                            Vec3 look = Vec3.m_82503_((Vec2)new Vec2(45.0f, this.m_146908_() + 180.0f));
                            double dx = (double)pos.m_123341_() + look.f_82479_ * 2.0;
                            double dz = (double)pos.m_123343_() + look.f_82481_ * 2.0;
                            PGTeleporter.TELEPORTS.put(nearby.m_20148_(), new PGTeleporter(nearby, serverlevel, new Vec3(dx, (double)pos.m_123342_(), dz), nearby.m_146908_() - this.m_146908_()));
                            nearby.m_20091_();
                            continue;
                        }
                        return;
                    }
                    nearby.m_6074_();
                }
            }
        }
    }
}

