/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.item;

import com.jdolphin.portalgun.entity.PortalEntity;
import com.jdolphin.portalgun.init.PGEntities;
import com.jdolphin.portalgun.init.PGItems;
import com.jdolphin.portalgun.init.PGTags;
import com.jdolphin.portalgun.util.Waypoint;
import com.jdolphin.portalgun.util.helpers.LevelHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PortalGunItem
extends Item {
    public static final String TAG_DIMENSION = "PortalDimension";
    public static final String TAG_BPOS = "PortalPos";
    public static final String TAG_FUEL = "Fuel";
    public static final String TAG_ACIDIC = "Bootleg";
    public static final String TAG_COLOR = "Color";
    public static final String TAG_WAYPOINTS = "Waypoints";
    private static final String WAYOINTS_FIX = "Wayoints";
    public static final String TAG_LOCK = "Lock";
    public static final String TAG_BIG = "Big";
    public static final String TAG_OWNER = "Owner";
    public static final String TAG_DEFAULT_COLOR = "DefaultColor";
    private int colour;
    private int defaultColor;

    public PortalGunItem(Item.Properties properties, int colour) {
        super(properties);
        this.defaultColor = colour;
    }

    public static int getMaxFuel(CompoundTag tag) {
        return 16;
    }

    public static int getFuel(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_(TAG_FUEL) ? tag.m_128451_(TAG_FUEL) : 16;
    }

    public static void lowerFuel(ItemStack stack, int amount) {
        CompoundTag tag = stack.m_41784_();
        int i = PortalGunItem.getFuel(stack);
        tag.m_128405_(TAG_FUEL, Math.max(0, i - amount));
    }

    public static void refillFuel(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(TAG_FUEL, PortalGunItem.getMaxFuel(tag));
    }

    public static void migrateDamage(CompoundTag tag) {
        if (tag.m_128441_("Damage")) {
            int fuel = PortalGunItem.getMaxFuel(tag) - tag.m_128451_("Damage");
            tag.m_128405_(TAG_FUEL, fuel);
            tag.m_128473_("Damage");
        }
    }

    public boolean refuel(ItemStack stack, Player player) {
        CompoundTag tag = stack.m_41784_();
        ItemStack offhand = player.m_21206_();
        ItemStack mainHand = player.m_21205_();
        if (PortalGunItem.getFuel(stack) < PortalGunItem.getMaxFuel(tag) && mainHand.m_204117_(PGTags.Items.PORTAL_GUNS)) {
            if (offhand.m_150930_((Item)PGItems.PORTAL_FLUID_BOTTLE.get())) {
                PortalGunItem.refillFuel(stack);
                offhand.m_41774_(1);
                tag.m_128379_(TAG_ACIDIC, false);
                return true;
            }
            if (offhand.m_150930_((Item)PGItems.BOOTLEG_PORTAL_FLUID_BOTTLE.get())) {
                PortalGunItem.refillFuel(stack);
                tag.m_128379_(TAG_ACIDIC, true);
                offhand.m_41774_(1);
                return true;
            }
        }
        return false;
    }

    private void setDefaultTags(CompoundTag tag, Player player) {
        if (!tag.m_128441_(TAG_OWNER)) {
            tag.m_128362_(TAG_OWNER, player.m_20148_());
        }
        if (!tag.m_128441_(TAG_FUEL)) {
            tag.m_128405_(TAG_FUEL, 16);
        }
        if (!tag.m_128441_(TAG_BPOS)) {
            tag.m_128365_(TAG_BPOS, (Tag)NbtUtils.m_129224_((BlockPos)player.m_20183_()));
        }
        if (!tag.m_128441_(TAG_DIMENSION)) {
            tag.m_128359_(TAG_DIMENSION, "overworld");
        }
        if (!tag.m_128441_(TAG_ACIDIC)) {
            tag.m_128379_(TAG_ACIDIC, false);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        CompoundTag tag = stack.m_41784_();
        BlockHitResult hitResult = PortalGunItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (!level.m_5776_() && player instanceof ServerPlayer) {
            this.setDefaultColor(tag, this.defaultColor);
            PortalGunItem.migrateDamage(tag);
            this.setDefaultTags(tag, player);
            if ((tag.m_128471_(TAG_LOCK) && tag.m_128342_(TAG_OWNER).equals(player.m_20148_()) || !tag.m_128471_(TAG_LOCK)) && !this.refuel(stack, player) && PortalGunItem.getFuel(stack) > 0) {
                PortalEntity portal = new PortalEntity((EntityType<? extends PortalEntity>)((EntityType)PGEntities.PORTAL.get()), level);
                PortalEntity exPortal = new PortalEntity((EntityType<? extends PortalEntity>)((EntityType)PGEntities.PORTAL.get()), level);
                portal.m_37251_((Entity)player, 0.0f, player.m_146908_(), 0.0f, 1.0f, 0.0f);
                exPortal.m_37251_((Entity)player, 0.0f, player.m_146908_(), 0.0f, 1.0f, 0.0f);
                exPortal.m_6034_(PortalGunItem.getHopCoords(stack).m_123341_(), PortalGunItem.getHopCoords(stack).m_123342_(), PortalGunItem.getHopCoords(stack).m_123343_());
                Vec3 loc = hitResult.m_82450_();
                if (hitResult.m_6662_().equals((Object)HitResult.Type.BLOCK)) {
                    Direction dir = hitResult.m_82434_();
                    BlockPos bPos = hitResult.m_82425_();
                    if (level.m_8055_(bPos.m_7494_()).m_60713_(Blocks.f_50016_) && dir == Direction.UP) {
                        portal.m_6034_(loc.m_7096_(), loc.m_7098_(), loc.m_7094_());
                    }
                    if (level.m_8055_(bPos.m_7495_()).m_60713_(Blocks.f_50016_) && dir == Direction.DOWN) {
                        portal.m_6034_(loc.m_7096_(), loc.m_7098_() - 2.0, loc.m_7094_());
                    }
                    switch (dir) {
                        case NORTH: {
                            if (level.m_8055_(bPos.m_122012_()).m_60713_(Blocks.f_50016_)) {
                                portal.m_6034_((double)bPos.m_123341_() + 0.5, bPos.m_123342_() - 1, (double)bPos.m_123343_() - 0.5);
                                break;
                            }
                            portal.m_6034_(loc.m_7096_(), bPos.m_123342_() - 1, loc.m_7094_());
                            break;
                        }
                        case SOUTH: {
                            if (level.m_8055_(bPos.m_122019_()).m_60713_(Blocks.f_50016_)) {
                                portal.m_6034_((double)bPos.m_123341_() + 0.5, bPos.m_123342_() - 1, (double)bPos.m_123343_() + 1.5);
                                break;
                            }
                            portal.m_6034_(loc.m_7096_(), bPos.m_123342_() - 1, loc.m_7094_());
                            break;
                        }
                        case WEST: {
                            if (level.m_8055_(bPos.m_122024_()).m_60713_(Blocks.f_50016_)) {
                                portal.m_6034_((double)bPos.m_123341_() - 0.5, bPos.m_123342_() - 1, (double)bPos.m_123343_() + 0.5);
                                break;
                            }
                            portal.m_6034_(loc.m_7096_(), bPos.m_123342_() - 1, loc.m_7094_());
                            break;
                        }
                        case EAST: {
                            if (level.m_8055_(bPos.m_122029_()).m_60713_(Blocks.f_50016_)) {
                                portal.m_6034_((double)bPos.m_123341_() + 1.5, bPos.m_123342_() - 1, (double)bPos.m_123343_() + 0.5);
                                break;
                            }
                            portal.m_6034_(loc.m_7096_(), bPos.m_123342_() - 1, loc.m_7094_());
                        }
                    }
                } else {
                    portal.m_6034_(loc.m_7096_(), loc.m_7098_() - 1.0, loc.m_7094_());
                }
                ResourceKey<Level> key = LevelHelper.getWorldKey(tag.m_128461_(TAG_DIMENSION));
                ServerLevel serverlevel = LevelHelper.getServerWorld(level, key);
                portal.setHopLocation(PortalGunItem.getHopDimension(stack), PortalGunItem.getHopCoords(stack));
                exPortal.setHopLocation(level.m_220362_().m_135782_(), new BlockPos((int)portal.m_20185_(), (int)portal.m_20186_(), (int)portal.m_20189_()));
                portal.m_20097_();
                exPortal.m_20097_();
                portal.setColor(this.getColor(stack));
                exPortal.setColor(this.getColor(stack));
                if (tag.m_128471_(TAG_ACIDIC)) {
                    portal.setAcid(true);
                    exPortal.setAcid(true);
                }
                if (!tag.m_128471_(TAG_ACIDIC)) {
                    portal.setAcid(false);
                    exPortal.setAcid(false);
                }
                if (serverlevel != null) {
                    portal.m_146926_(0.0f);
                    exPortal.m_146926_(0.0f);
                    serverlevel.m_7967_((Entity)exPortal);
                    level.m_7967_((Entity)portal);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    player.m_36335_().m_41524_((Item)this, 60);
                    if (!player.m_150110_().f_35937_) {
                        PortalGunItem.lowerFuel(stack, 1);
                    }
                } else {
                    player.m_213846_((Component)Component.m_237115_((String)"notice.ricksportalgun.destination_not_found").m_130940_(ChatFormatting.RED));
                }
            }
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237110_((String)"item.ricksportalgun.portal_gun.tooltip.destination", (Object[])new Object[]{PortalGunItem.getHopCoords(pStack).m_123341_(), PortalGunItem.getHopCoords(pStack).m_123342_(), PortalGunItem.getHopCoords(pStack).m_123343_()}).m_130940_(ChatFormatting.GRAY));
        pTooltipComponents.add((Component)Component.m_237110_((String)"item.ricksportalgun.portal_gun.tooltip.dimension", (Object[])new Object[]{PortalGunItem.getHopDimension(pStack).toString()}).m_130940_(ChatFormatting.GRAY));
    }

    public boolean m_8120_(ItemStack pStack) {
        return false;
    }

    public int m_142159_(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(TAG_COLOR)) {
            return tag.m_128451_(TAG_COLOR);
        }
        return Color.GREEN.getRGB();
    }

    public boolean m_142522_(ItemStack stack) {
        return PortalGunItem.getFuel(stack) < PortalGunItem.getMaxFuel(stack.m_41784_());
    }

    public int m_142158_(ItemStack stack) {
        return Math.round((float)PortalGunItem.getFuel(stack) * 13.0f / (float)PortalGunItem.getMaxFuel(stack.m_41784_()));
    }

    public void addWaypoint(ItemStack stack, Waypoint waypoint) {
        CompoundTag tag = stack.m_41784_();
        ListTag listtag = tag.m_128437_(TAG_WAYPOINTS, 8);
        listtag.add((Object)StringTag.m_129297_((String)waypoint.getWaypointString()));
        tag.m_128365_(TAG_WAYPOINTS, (Tag)listtag);
    }

    public void deleteWaypoint(ItemStack stack, Waypoint waypoint) {
        CompoundTag tag = stack.m_41784_();
        ListTag listtag = tag.m_128437_(TAG_WAYPOINTS, 8);
        listtag.remove((Object)StringTag.m_129297_((String)waypoint.getWaypointString()));
        tag.m_128365_(TAG_WAYPOINTS, (Tag)listtag);
    }

    public int getColor(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128441_(TAG_COLOR) && tag.m_128441_(TAG_DEFAULT_COLOR)) {
            return tag.m_128451_(TAG_DEFAULT_COLOR);
        }
        return tag.m_128451_(TAG_COLOR);
    }

    public void setDefaultColor(CompoundTag tag, int color) {
        tag.m_128405_(TAG_DEFAULT_COLOR, color);
    }

    public void setColor(ItemStack stack, int color) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128405_(TAG_COLOR, color);
    }

    public static List<String> getWaypoints(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (tag.m_128441_(TAG_WAYPOINTS)) {
            return stack.m_41784_().m_128437_(TAG_WAYPOINTS, 8).stream().map(Tag::m_7916_).toList();
        }
        return new ArrayList<String>();
    }

    public void setHopLocation(ItemStack stack, String dimension, BlockPos pos) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_(TAG_DIMENSION, dimension);
        tag.m_128365_(TAG_BPOS, (Tag)NbtUtils.m_129224_((BlockPos)pos));
    }

    public static ResourceLocation getHopDimension(ItemStack itemStack) {
        CompoundTag tag = itemStack.m_41784_();
        if (tag.m_128441_(TAG_DIMENSION)) {
            return new ResourceLocation(tag.m_128461_(TAG_DIMENSION));
        }
        return new ResourceLocation("minecraft:overworld");
    }

    public static BlockPos getHopCoords(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        return tag.m_128441_(TAG_BPOS) ? NbtUtils.m_129239_((CompoundTag)((CompoundTag)tag.m_128423_(TAG_BPOS))) : BlockPos.f_121853_;
    }
}

