/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.packets;

import com.jdolphin.portalgun.config.PortalGunCommonConfig;
import com.jdolphin.portalgun.init.PGTags;
import com.jdolphin.portalgun.item.PortalGunItem;
import com.jdolphin.portalgun.util.helpers.Helper;
import com.jdolphin.portalgun.util.helpers.LevelHelper;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.world.ForgeChunkManager;
import net.minecraftforge.network.NetworkEvent;

public class SBCoordCheckerPacket {
    public SBCoordCheckerPacket() {
    }

    public SBCoordCheckerPacket(FriendlyByteBuf buf) {
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public BlockPos getRandoCoord(Level level) {
        WorldBorder border = level.m_6857_();
        Random rand = new Random();
        int i = (Integer)PortalGunCommonConfig.randomizer_max.get();
        int xCoord = rand.nextInt((double)(-i) < border.m_61955_() ? (int)border.m_61955_() : -i, (double)i > border.m_61957_() ? (int)border.m_61957_() : i);
        int yCoord = rand.nextInt(level.m_141937_() + 5, level.m_151558_());
        int zCoord = rand.nextInt((double)(-i) < border.m_61956_() ? (int)border.m_61956_() : -i, (double)i > border.m_61958_() ? (int)border.m_61958_() : i);
        return new BlockPos(xCoord, yCoord + 1, zCoord);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        ServerPlayer player = context.getSender();
        assert (player != null);
        player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"notice.ricksportalgun.randomizer_find_y.start").m_130940_(ChatFormatting.YELLOW)));
        ServerLevel level = (ServerLevel)player.m_9236_();
        ItemStack stack = player.m_21205_();
        BlockPos pos = this.getRandoCoord((Level)level);
        PortalGunItem item = Helper.getPortalGun(stack);
        try {
            BlockState blockState;
            int y;
            int direction;
            ChunkAccess chunk = level.m_46865_(pos);
            ForgeChunkManager.forceChunk((ServerLevel)level, (String)"ricksportalgun", (Entity)player, (int)chunk.m_7697_().m_45610_(), (int)chunk.m_7697_().m_45612_(), (boolean)true, (boolean)false);
            int height = level.m_6924_(Heightmap.Types.WORLD_SURFACE, pos.m_123341_(), pos.m_123343_());
            int worldCenter = (level.m_141937_() + 2 + height) / 2;
            int n = direction = y > worldCenter ? -1 : 1;
            for (y = pos.m_123342_(); y >= level.m_141937_() + 2 && y <= level.m_151558_(); y += direction) {
                BlockPos pos1 = new BlockPos(pos.m_123341_(), y, pos.m_123343_());
                BlockState blockState2 = level.m_8055_(pos1);
                BlockState belowState = level.m_8055_(pos1.m_7495_());
                BlockState aboveState = level.m_8055_(pos1.m_7494_());
                if (!belowState.m_60713_(Blocks.f_50016_) && !aboveState.m_204336_(PGTags.Blocks.DANGEROUS_BLOCKS) && !blockState2.m_60828_((BlockGetter)level, pos1)) break;
            }
            if ((blockState = level.m_8055_(pos = new BlockPos(pos.m_123341_(), y, pos.m_123343_()))).m_60828_((BlockGetter)level, pos) || blockState.m_204336_(PGTags.Blocks.DANGEROUS_BLOCKS) || y <= level.m_141937_() + 2 || y >= level.m_151558_()) {
                player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"notice.ricksportalgun.randomizer_find_y.fail").m_130940_(ChatFormatting.RED)));
                return false;
            }
            assert (item != null);
            item.setHopLocation(stack, LevelHelper.getPlayerDimensionString((Player)player), pos);
            player.f_8906_.m_9829_((Packet)new ClientboundSetActionBarTextPacket((Component)Component.m_237115_((String)"notice.ricksportalgun.randomizer_find_y.success").m_130940_(ChatFormatting.GREEN)));
            ForgeChunkManager.forceChunk((ServerLevel)level, (String)"ricksportalgun", (Entity)player, (int)chunk.m_7697_().m_45610_(), (int)chunk.m_7697_().m_45612_(), (boolean)false, (boolean)false);
            return true;
        }
        catch (NullPointerException err) {
            err.printStackTrace();
            return false;
        }
    }
}

