/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.packets;

import com.jdolphin.portalgun.init.PGTags;
import com.jdolphin.portalgun.item.PortalGunItem;
import com.jdolphin.portalgun.util.Waypoint;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SBManageWaypointsPacket {
    protected Waypoint wp;
    protected boolean remove;

    public SBManageWaypointsPacket(Waypoint waypoint, boolean remove) {
        this.wp = waypoint;
        this.remove = remove;
    }

    public SBManageWaypointsPacket(FriendlyByteBuf buf) {
        this.wp = Waypoint.getWaypoint(buf.m_130277_());
        this.remove = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.wp.getWaypointString());
        buf.writeBoolean(this.remove);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        ServerPlayer player = supplier.get().getSender();
        try {
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            if (stack.m_204117_(PGTags.Items.PORTAL_GUNS)) {
                PortalGunItem item = (PortalGunItem)stack.m_41720_();
                if (this.remove) {
                    item.deleteWaypoint(stack, this.wp);
                } else {
                    item.addWaypoint(stack, this.wp);
                }
            }
            return true;
        }
        catch (NullPointerException err) {
            err.printStackTrace();
            return false;
        }
    }
}

