/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.packets;

import com.jdolphin.portalgun.PortalGunMod;
import com.jdolphin.portalgun.config.PortalGunCommonConfig;
import com.jdolphin.portalgun.item.PortalGunItem;
import com.jdolphin.portalgun.util.Waypoint;
import com.jdolphin.portalgun.util.helpers.Helper;
import com.jdolphin.portalgun.util.helpers.LevelHelper;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SBSetDestinationPacket {
    protected BlockPos pos;
    protected String dim;

    public SBSetDestinationPacket(BlockPos pos, String dim) {
        this.pos = pos;
        this.dim = dim;
    }

    public SBSetDestinationPacket(Waypoint waypoint) {
        this.pos = waypoint.getBlockPos();
        this.dim = waypoint.getDim();
    }

    public SBSetDestinationPacket(FriendlyByteBuf buf) {
        this.dim = buf.m_130277_();
        this.pos = buf.m_130135_();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.dim);
        buf.m_130064_(this.pos);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        ServerPlayer player = context.getSender();
        assert (player != null);
        try {
            if (!PortalGunCommonConfig.getBlacklistedDims().contains(this.dim) || LevelHelper.getPlayerDimensionString((Player)player).equals(this.dim)) {
                ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
                PortalGunItem item = Helper.getPortalGun(stack);
                item.setHopLocation(stack, this.dim, this.pos);
                return true;
            }
            player.m_5661_((Component)Component.m_237115_((String)"notice.ricksportalgun.dimension_disabled").m_130940_(ChatFormatting.RED), false);
            return false;
        }
        catch (NullPointerException err) {
            PortalGunMod.LOGGER.warn(err.getLocalizedMessage());
            return false;
        }
    }
}

