/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.portalgun.packets;

import com.jdolphin.portalgun.util.helpers.Helper;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SBSettingsPacket {
    protected boolean lock;
    protected String owner;
    protected boolean big;

    public SBSettingsPacket(boolean lock, String owner, boolean big) {
        this.lock = lock;
        this.owner = owner;
        this.big = big;
    }

    public SBSettingsPacket(FriendlyByteBuf buf) {
        this.lock = buf.readBoolean();
        this.owner = buf.m_130277_();
        this.big = buf.readBoolean();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeBoolean(this.lock);
        buf.m_130070_(this.owner);
        buf.writeBoolean(this.big);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        ServerPlayer player = context.getSender();
        assert (player != null);
        try {
            ServerLevel world = player.m_284548_();
            MinecraftServer server = world.m_7654_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            CompoundTag tag = stack.m_41784_();
            ServerPlayer newOwner = server.m_6846_().m_11255_(this.owner);
            if (newOwner != null) {
                tag.m_128362_("Owner", newOwner.m_20148_());
                tag.m_128379_("Lock", this.lock);
                tag.m_128379_("Big", this.big);
                Helper.sendMessage((Player)player, (Component)Component.m_237115_((String)"notice.ricksportalgun.settings.applied").m_130940_(ChatFormatting.GREEN));
                return true;
            }
            Helper.sendMessage((Player)player, (Component)Component.m_237115_((String)"notice.ricksportalgun.settings.player_not_found").m_130940_(ChatFormatting.RED));
        }
        catch (NullPointerException err) {
            err.printStackTrace();
            return false;
        }
        return false;
    }
}

