/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.armor_effects;

import immersive_armors.armor_effects.ArmorEffect;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class FireInflictingArmorEffect
extends ArmorEffect {
    private final int length;

    public FireInflictingArmorEffect(int length) {
        this.length = length;
    }

    @Override
    public float applyArmorToDamage(LivingEntity entity, DamageSource source, float amount, ItemStack armor) {
        if (this.isPrimaryArmor(armor, entity) && source.getEntity() != null && !source.getEntity().fireImmune()) {
            source.getEntity().setRemainingFireTicks(source.getEntity().getRemainingFireTicks() + this.length * this.getSetCount(armor, entity));
            entity.level().playSound(null, (Entity)entity, SoundEvents.BLAZE_BURN, entity.getSoundSource(), 1.0f, entity.getRandom().nextFloat() * 0.7f + 0.3f);
        }
        return amount;
    }

    @Override
    public void appendTooltip(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"armorEffect.fireInflicting", (Object[])new Object[]{this.length}).withStyle(ChatFormatting.RED));
    }

    @Override
    public void equippedTick(ItemStack stack, Level world, LivingEntity entity, int slot) {
        if (world.isClientSide && Minecraft.getInstance().player == entity && !Minecraft.getInstance().options.getCameraType().isFirstPerson() && entity.getRandom().nextInt(15) == 0) {
            world.addParticle((ParticleOptions)ParticleTypes.FLAME, entity.getRandomX(0.5), entity.getRandomY(), entity.getRandomZ(0.5), 0.0, 0.0, 0.0);
        }
    }
}

