/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.armor_effects;

import immersive_armors.armor_effects.ArmorEffect;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class WeaponEfficiency
extends ArmorEffect {
    private final float damage;
    private final TagKey<Item> weapon;
    private final String weaponName;

    public WeaponEfficiency(float damage, ResourceLocation weapon, String weaponName) {
        this.damage = damage;
        this.weapon = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)weapon);
        this.weaponName = weaponName;
    }

    @Override
    public void appendTooltip(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        MutableComponent weaponText = Component.translatable((String)("armorEffect.weaponEfficiency." + this.weaponName));
        tooltip.add((Component)Component.translatable((String)"armorEffect.weaponEfficiency", (Object[])new Object[]{(int)(this.damage * 100.0f), weaponText}).withStyle(ChatFormatting.GOLD));
    }

    @Override
    public float applyArmorToAttack(LivingEntity target, DamageSource source, float amount, ItemStack armor) {
        boolean hasAxe;
        LivingEntity attacker;
        Entity entity;
        if (source.isDirect() && (entity = source.getEntity()) instanceof LivingEntity && this.isPrimaryArmor(armor, attacker = (LivingEntity)entity) && (hasAxe = Stream.of(attacker.getItemBySlot(EquipmentSlot.MAINHAND), attacker.getItemBySlot(EquipmentSlot.OFFHAND)).anyMatch(v -> v.is(this.weapon)))) {
            amount *= 1.0f + (float)this.getSetCount(armor, attacker) * this.damage;
        }
        return amount;
    }
}

