/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.client.render.entity.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import immersive_armors.client.render.entity.model.DecoModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.world.entity.EquipmentSlot;

public class GearModel
extends DecoModel {
    private final String attachTo;
    private final ModelPart part;

    public GearModel(String to, int size) {
        this.attachTo = to;
        MeshDefinition modelData = new MeshDefinition();
        modelData.getRoot().addOrReplaceChild("part", CubeListBuilder.create().addBox((float)(-size) / 2.0f, (float)(-size) / 2.0f, 0.0f, (float)size, (float)size, 0.0f), PartPose.ZERO);
        ModelPart model = LayerDefinition.create((MeshDefinition)modelData, (int)16, (int)8).bakeRoot();
        this.part = model.getChild("part");
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.part.render(matrices, vertices, light, overlay, color);
    }

    @Override
    public void copyFromModel(HumanoidModel model, EquipmentSlot slot) {
        this.part.copyFrom(GearModel.getModelPart(model, this.attachTo));
        super.copyFromModel(model, slot);
    }

    public String getAttachTo() {
        return this.attachTo;
    }

    public ModelPart getPart() {
        return this.part;
    }
}

