/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.client.render.entity.piece;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import immersive_armors.Main;
import immersive_armors.client.render.entity.model.CapeModel;
import immersive_armors.client.render.entity.piece.Piece;
import immersive_armors.item.DyeableExtendedArmorItem;
import immersive_armors.item.ExtendedArmorItem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class CapePiece<M extends CapeModel<LivingEntity>>
extends Piece {
    private static final Map<UUID, CapeAngles> capeAngles = new HashMap<UUID, CapeAngles>();
    private final M model;

    public CapePiece(M model) {
        this.model = model;
    }

    private ResourceLocation getCapeTexture(ExtendedArmorItem item, boolean overlay) {
        return Main.locate("textures/models/armor/" + item.getExtendedMaterial().getName() + "/cape" + (overlay ? "_overlay" : "") + ".png");
    }

    @Override
    public <T extends LivingEntity, A extends HumanoidModel<T>> void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, T entity, ItemStack itemStack, float tickDelta, EquipmentSlot armorSlot, A armorModel) {
        Item item = itemStack.getItem();
        if (item instanceof ExtendedArmorItem) {
            VertexConsumer vertexConsumer;
            ExtendedArmorItem armor = (ExtendedArmorItem)item;
            CapeAngles angles = capeAngles.computeIfAbsent(entity.getUUID(), k -> new CapeAngles());
            angles.updateCapeAngles((Entity)entity, tickDelta);
            matrices.pushPose();
            matrices.translate(0.0, 0.0, 0.125);
            float n = entity.yBodyRotO + (entity.yBodyRot - entity.yBodyRotO);
            double o = Mth.sin((float)(n * ((float)Math.PI / 180)));
            double p = -Mth.cos((float)(n * ((float)Math.PI / 180)));
            double q = angles.deltaY * 40.0;
            q = Mth.clamp((double)q, (double)-6.0, (double)32.0);
            double r = (angles.deltaX * o + angles.deltaZ * p) * 100.0;
            r = Mth.clamp((double)r, (double)0.0, (double)150.0);
            double s = (angles.deltaX * p - angles.deltaZ * o) * 100.0;
            s = Mth.clamp((double)s, (double)-20.0, (double)20.0);
            if (r < 0.0) {
                r = 0.0;
            }
            if (entity.isCrouching()) {
                q += 22.5;
                matrices.translate(0.0, 0.25, 0.0);
            }
            matrices.mulPose(Axis.XP.rotationDegrees((float)(6.0 + r / 2.0 + q)));
            matrices.mulPose(Axis.ZP.rotationDegrees((float)(s / 2.0)));
            matrices.mulPose(Axis.YP.rotationDegrees((float)(180.0 - s / 2.0)));
            ((CapeModel)((Object)this.model)).setupAnim(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            if (armor instanceof DyeableExtendedArmorItem) {
                DyeableExtendedArmorItem dyeableArmorItem = (DyeableExtendedArmorItem)armor;
                int c = dyeableArmorItem.getColor(itemStack);
                vertexConsumer = vertexConsumers.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)this.getCapeTexture(armor, false)));
                ((CapeModel)((Object)this.model)).renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, c);
                vertexConsumer = vertexConsumers.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)this.getCapeTexture(armor, true)));
            } else {
                vertexConsumer = vertexConsumers.getBuffer(RenderType.armorCutoutNoCull((ResourceLocation)this.getCapeTexture(armor, false)));
            }
            ((CapeModel)((Object)this.model)).renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY, -1);
            matrices.popPose();
        }
    }

    private static class CapeAngles {
        private double capeX;
        private double capeY;
        private double capeZ;
        private double deltaX;
        private double deltaY;
        private double deltaZ;
        private float lastTickDelta;

        private CapeAngles() {
        }

        private Vec3 predictPosition(Entity entity, float tickDelta) {
            return new Vec3(Mth.lerp((double)tickDelta, (double)entity.xo, (double)entity.getX()), Mth.lerp((double)tickDelta, (double)entity.yo, (double)entity.getY()), Mth.lerp((double)tickDelta, (double)entity.zo, (double)entity.getZ()));
        }

        private void updateCapeAngles(Entity entity, float tickDelta) {
            float delta;
            Vec3 pos = this.predictPosition(entity, tickDelta);
            double dx = pos.x() - this.capeX;
            double dy = pos.y() - this.capeY;
            double dz = pos.z() - this.capeZ;
            if (dx > 10.0 || dx < -10.0) {
                this.capeX = pos.x();
                dx = 0.0;
            }
            if (dy > 10.0 || dy < -10.0) {
                this.capeY = pos.y();
                dy = 0.0;
            }
            if (dz > 10.0 || dz < -10.0) {
                this.capeZ = pos.z();
                dz = 0.0;
            }
            if ((double)(delta = tickDelta - this.lastTickDelta) < 0.0) {
                delta = 1.0f + delta;
            }
            this.lastTickDelta = tickDelta;
            this.capeX += dx * (double)(delta *= 0.25f);
            this.capeZ += dz * (double)delta;
            this.capeY += dy * (double)delta;
            this.deltaX = this.capeX - pos.x();
            this.deltaY = this.capeY - pos.y();
            this.deltaZ = this.capeZ - pos.z();
        }
    }
}

