/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.mixin;

import immersive_armors.config.Config;
import immersive_armors.item.ExtendedArmorItem;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class MixinPlayer {
    @Shadow
    public abstract boolean isLocalPlayer();

    @Shadow
    public abstract ItemStack getItemBySlot(EquipmentSlot var1);

    @Inject(method={"isModelPartShown(Lnet/minecraft/world/entity/player/PlayerModelPart;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void immersiveArmors$injectIsPartVisible(PlayerModelPart modelPart, CallbackInfoReturnable<Boolean> cir) {
        ExtendedArmorItem armorItem;
        ItemStack stack;
        Item item;
        if (!Config.getInstance().hideSecondLayerUnderArmor) {
            return;
        }
        if (this.isLocalPlayer() && !Minecraft.getInstance().gameRenderer.getMainCamera().isDetached()) {
            return;
        }
        int flag = modelPart.getBit();
        EquipmentSlot slot = null;
        int index = -1;
        switch (flag) {
            case 1: 
            case 2: 
            case 3: {
                slot = EquipmentSlot.CHEST;
                index = 1;
                break;
            }
            case 4: 
            case 5: {
                slot = EquipmentSlot.LEGS;
                index = 2;
                break;
            }
            case 6: {
                slot = EquipmentSlot.HEAD;
                index = 0;
            }
        }
        if (index >= 0 && (item = (stack = this.getItemBySlot(slot)).getItem()) instanceof ExtendedArmorItem && (armorItem = (ExtendedArmorItem)item).getExtendedMaterial().shouldHideSecondLayer()[index]) {
            cir.setReturnValue((Object)false);
        }
    }
}

