/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.network.c2s;

import immersive_armors.armor_effects.ArmorEffect;
import immersive_armors.cobalt.network.Message;
import immersive_armors.item.ExtendedArmorItem;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ArmorCommandMessage
extends Message {
    public static final StreamCodec<RegistryFriendlyByteBuf, ArmorCommandMessage> STREAM_CODEC = StreamCodec.ofMember(ArmorCommandMessage::encode, ArmorCommandMessage::new);
    public static final CustomPacketPayload.Type<ArmorCommandMessage> TYPE = Message.createType("armor_command");
    private final int slot;
    private final String command;

    public ArmorCommandMessage(int slot, String command) {
        this.slot = slot;
        this.command = command;
    }

    public ArmorCommandMessage(RegistryFriendlyByteBuf b) {
        this.slot = b.readInt();
        this.command = b.readUtf();
    }

    @Override
    public void encode(RegistryFriendlyByteBuf b) {
        b.writeInt(this.slot);
        b.writeUtf(this.command);
    }

    @Override
    public void receiveServer(ServerPlayer player) {
        ItemStack stack = player.getInventory().getItem(this.slot);
        Item item = stack.getItem();
        if (item instanceof ExtendedArmorItem) {
            ExtendedArmorItem item2 = (ExtendedArmorItem)item;
            for (ArmorEffect e : item2.getExtendedMaterial().getEffects()) {
                e.receiveCommand(stack, player.level(), (LivingEntity)player, this.slot, this.command);
            }
        }
    }

    @Override
    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

