/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors;

import immersive_armors.Main;
import immersive_armors.armor_effects.ArrowBlockArmorEffect;
import immersive_armors.armor_effects.BerserkArmorEffect;
import immersive_armors.armor_effects.BouncingArmorEffect;
import immersive_armors.armor_effects.DivineArmorEffect;
import immersive_armors.armor_effects.ExplosionProtectionArmorEffect;
import immersive_armors.armor_effects.FireInflictingArmorEffect;
import immersive_armors.armor_effects.FireResistanceArmorEffect;
import immersive_armors.armor_effects.MagicProtectionArmorEffect;
import immersive_armors.armor_effects.SpikesArmorEffect;
import immersive_armors.armor_effects.SteamTechArmorEffect;
import immersive_armors.armor_effects.WeaponEfficiency;
import immersive_armors.armor_effects.WitherArmorEffect;
import immersive_armors.cobalt.registration.Registration;
import immersive_armors.item.DyeableExtendedArmorItem;
import immersive_armors.item.ExtendedArmorItem;
import immersive_armors.item.ExtendedArmorMaterial;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_326;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9282;

public interface Items {
    public static final Map<String, Supplier<class_1792>> coloredItems = new HashMap<String, Supplier<class_1792>>();
    public static final Map<String, Supplier<class_1792>> items = new HashMap<String, Supplier<class_1792>>();
    public static final List<Supplier<class_1792>> itemsOrdered = new LinkedList<Supplier<class_1792>>();
    public static final Map<String, Map<Supplier<class_1792>, Float>> lootLookup = new HashMap<String, Map<Supplier<class_1792>, Float>>();
    public static final ExtendedArmorMaterial BONE_ARMOR = Items.registerSet(new ExtendedArmorMaterial("bone").addLoot("minecraft:chests/village/village_weaponsmith", 1.0f).addLoot("minecraft:chests/jungle_temple", 1.0f).durabilityMultiplier(8).repairIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8606})).protectionAmount(1, 3, 2, 1).enchantability(15).equipSound(class_3417.field_15200).antiSkeleton().weight(-0.02f));
    public static final ExtendedArmorMaterial WITHER_ARMOR = Items.registerSet(new ExtendedArmorMaterial("wither").addLoot("minecraft:chests/jungle_temple", 0.5f).addLoot("minecraft:chests/ruined_portal", 1.0f).addLoot("minecraft:chests/bastion_other", 1.0f).durabilityMultiplier(12).repairIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8606})).protectionAmount(2, 4, 3, 2).enchantability(0).effect(new WitherArmorEffect(0.25f, 20)).hideCape().equipSound(class_3417.field_15214).antiSkeleton().weight(-0.01f));
    public static final ExtendedArmorMaterial WARRIOR_ARMOR = Items.registerSet(new ExtendedArmorMaterial("warrior").addLoot("minecraft:chests/village/village_armorer", 1.0f).addLoot("minecraft:chests/shipwreck_supply", 1.0f).protectionAmount(2, 5, 6, 2).durabilityMultiplier(15).repairIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8620})).toughness(1.0f).enchantability(5).hideCape().effect(new BerserkArmorEffect(0.2f)).effect(new WeaponEfficiency(0.05f, Main.locate("axes"), "axe")).equipSound((class_6880<class_3414>)class_3417.field_14862));
    public static final ExtendedArmorMaterial HEAVY_ARMOR = Items.registerSet(new ExtendedArmorMaterial("heavy").addLoot("minecraft:chests/village/village_armorer", 1.0f).addLoot("minecraft:chests/stronghold_crossing", 1.0f).protectionAmount(4, 6, 5, 3).durabilityMultiplier(20).repairIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8620})).toughness(4.0f).knockbackReduction(0.5f).weight(0.05f).enchantability(6).equipSound((class_6880<class_3414>)class_3417.field_14862));
    public static final ExtendedArmorMaterial ROBE_ARMOR = Items.registerDyeableSet(new ExtendedArmorMaterial("robe").addLoot("minecraft:chests/village/village_shepherd", 0.25f).addLoot("minecraft:chests/woodland_mansion", 1.0f).addLoot("minecraft:chests/igloo_chest", 1.0f).protectionAmount(2, 3, 2, 1).enchantability(50).durabilityMultiplier(14).repairIngredient(() -> class_1856.method_8106((class_6862)class_3489.field_15544)).color(-5238970).effect(new FireResistanceArmorEffect(0.25f)).effect(new FireInflictingArmorEffect(20)).effect(new MagicProtectionArmorEffect(0.2f)).equipSound(class_3417.field_15226));
    public static final ExtendedArmorMaterial SLIME_ARMOR = Items.registerSet(new ExtendedArmorMaterial("slime").addLoot("minecraft:chests/simple_dungeon", 0.25f).protectionAmount(3, 5, 4, 2).enchantability(10).durabilityMultiplier(20).repairIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8777})).knockbackReduction(0.25f).effect(new BouncingArmorEffect(0.25f)).effect(new ExplosionProtectionArmorEffect(0.2f)).equipSound(class_3417.field_15095));
    public static final ExtendedArmorMaterial DIVINE_ARMOR = Items.registerDyeableSet(new ExtendedArmorMaterial("divine").addLoot("minecraft:chests/village/village_temple", 0.4f).addLoot("minecraft:chests/bastion_treasure", 0.25f).addLoot("minecraft:chests/woodland_mansion", 0.25f).addLoot("minecraft:chests/desert_pyramid", 1.0f).protectionAmount(3, 7, 5, 3).durabilityMultiplier(18).repairIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8695})).enchantability(30).effect(new DivineArmorEffect(1200L)).color(-5238970).hideCape().equipSound((class_6880<class_3414>)class_3417.field_14862));
    public static final ExtendedArmorMaterial PRISMARINE_ARMOR = Items.registerSet(new ExtendedArmorMaterial("prismarine").addLoot("minecraft:chests/underwater_ruin_big", 1.0f).addLoot("minecraft:chests/underwater_ruin_small", 0.5f).protectionAmount(3, 8, 6, 3).enchantability(8).durabilityMultiplier(18).repairIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8434})).weight(0.02f).waterMovement(0.25f).effect(new SpikesArmorEffect(1)).equipSound((class_6880<class_3414>)class_3417.field_14862));
    public static final ExtendedArmorMaterial WOODEN_ARMOR = Items.registerSet(new ExtendedArmorMaterial("wooden").addLoot("minecraft:chests/village/village_fletcher", 0.25f).protectionAmount(1, 3, 2, 1).durabilityMultiplier(8).repairIngredient(() -> class_1856.method_8106((class_6862)class_3489.field_15539)).enchantability(4).effect(new ArrowBlockArmorEffect(0.15f)).effect(new ExplosionProtectionArmorEffect(0.1f)).equipSound((class_6880<class_3414>)class_3417.field_14581));
    public static final ExtendedArmorMaterial STEAMPUNK_ARMOR = Items.registerSet(new ExtendedArmorMaterial("steampunk").addLoot("minecraft:chests/village/village_toolsmith", 0.25f).addLoot("minecraft:chests/shipwreck_treasure", 1.0f).protectionAmount(3, 6, 3, 2).durabilityMultiplier(10).repairIngredient(() -> class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8695})).enchantability(4).hideCape().effect(new ExplosionProtectionArmorEffect(0.1f)).effect(new SteamTechArmorEffect()).equipSound(class_3417.field_19199));

    public static void bootstrap() {
    }

    public static ExtendedArmorMaterial registerSet(ExtendedArmorMaterial material) {
        material.registerVanillaMaterial();
        items.putAll(Items.register(material.getName() + "_helmet", () -> new ExtendedArmorItem(Items.baseProps(), class_1738.class_8051.field_41934, material), material));
        items.putAll(Items.register(material.getName() + "_chestplate", () -> new ExtendedArmorItem(Items.baseProps(), class_1738.class_8051.field_41935, material), material));
        items.putAll(Items.register(material.getName() + "_leggings", () -> new ExtendedArmorItem(Items.baseProps(), class_1738.class_8051.field_41936, material), material));
        items.putAll(Items.register(material.getName() + "_boots", () -> new ExtendedArmorItem(Items.baseProps(), class_1738.class_8051.field_41937, material), material));
        return material;
    }

    public static ExtendedArmorMaterial registerDyeableSet(ExtendedArmorMaterial material) {
        material.registerVanillaMaterial();
        coloredItems.putAll(Items.register(material.getName() + "_helmet", () -> new DyeableExtendedArmorItem(Items.baseProps(), class_1738.class_8051.field_41934, material), material));
        coloredItems.putAll(Items.register(material.getName() + "_chestplate", () -> new DyeableExtendedArmorItem(Items.baseProps(), class_1738.class_8051.field_41935, material), material));
        coloredItems.putAll(Items.register(material.getName() + "_leggings", () -> new DyeableExtendedArmorItem(Items.baseProps(), class_1738.class_8051.field_41936, material), material));
        coloredItems.putAll(Items.register(material.getName() + "_boots", () -> new DyeableExtendedArmorItem(Items.baseProps(), class_1738.class_8051.field_41937, material), material));
        items.putAll(coloredItems);
        return material;
    }

    public static Map<String, Supplier<class_1792>> register(String name, Supplier<class_1792> item, ExtendedArmorMaterial material) {
        Supplier<class_1792> register = Registration.register(class_7923.field_41178, Main.locate(name), item);
        for (Map.Entry<String, Float> entry : material.getLoot().entrySet()) {
            lootLookup.putIfAbsent(entry.getKey(), new HashMap());
            lootLookup.get(entry.getKey()).put(register, entry.getValue());
        }
        itemsOrdered.add(register);
        return Collections.singletonMap(name, register);
    }

    public static class_1792.class_1793 baseProps() {
        return new class_1792.class_1793().method_7889(1);
    }

    public static List<class_1799> getSortedItems() {
        return itemsOrdered.stream().map(i -> ((class_1792)i.get()).method_7854()).toList();
    }

    public static class_326 getDyeColor(int defaultColor) {
        return (item, layer) -> {
            if (layer != 0) {
                return -1;
            }
            return class_9282.method_57470((class_1799)item, (int)defaultColor);
        };
    }
}

