/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.armor_effects;

import com.mojang.serialization.Codec;
import immersive_armors.CustomDataComponentTypes;
import immersive_armors.armor_effects.ArmorEffect;
import immersive_armors.cobalt.network.NetworkHandler;
import immersive_armors.network.c2s.ArmorCommandMessage;
import immersive_armors.util.EnumCodec;
import immersive_armors.util.EnumPacketCodec;
import immersive_armors.util.FlowingText;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1588;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_9139;

public class SteamTechArmorEffect
extends ArmorEffect {
    @Override
    public void appendTooltip(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        class_5250 text = class_2561.method_43471((String)("armorEffect.steamTech." + this.getEquipmentSlot(stack).name().toLowerCase(Locale.ROOT))).method_27692(class_124.field_1080);
        tooltip.addAll(FlowingText.wrap((class_2561)text, 140));
    }

    @Override
    public void equippedTick(class_1799 armor, class_1937 world, class_1309 entity, int slot) {
        super.equippedTick(armor, world, entity, slot);
        if (this.getEquipmentSlot(armor) == class_1304.field_6166) {
            class_243 velocity;
            entity.field_6017 = Math.min(1.0f, entity.field_6017);
            if (entity.method_59922().method_43048(10) == 0) {
                double x = Math.cos((double)(entity.field_6283 / 180.0f) * Math.PI - 1.5707963267948966) * 0.25;
                double z = Math.sin((double)(entity.field_6283 / 180.0f) * Math.PI - 1.5707963267948966) * 0.25;
                world.method_8406((class_2394)class_2398.field_11251, entity.method_23317() + x, entity.method_23318() + (double)1.2f, entity.method_23321() + z, x * (double)0.2f, (double)-0.025f, z * (double)0.2f);
            }
            if ((velocity = entity.method_18798()).method_10214() < -0.75 && !entity.method_6128()) {
                entity.method_18800(velocity.field_1352, -0.75, velocity.field_1350);
                this.createSteamParticle(entity);
                if (entity.field_6012 % 5 == 0) {
                    entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_19199, entity.method_5634(), 0.1f, 1.0f);
                }
            }
        }
        if (!world.method_8608() && entity.method_5715() && this.getEquipmentSlot(armor) == class_1304.field_6169 && entity.field_6012 % 20 == 0) {
            boolean[] sound = new boolean[]{false};
            world.method_8335((class_1297)entity, new class_238(entity.method_19538(), entity.method_19538()).method_1014(16.0)).forEach(e -> {
                if (e instanceof class_1588) {
                    class_1588 hostileEntity = (class_1588)e;
                    hostileEntity.method_6092(new class_1293(class_1294.field_5912, 5));
                    if (!sound[0]) {
                        sound[0] = true;
                        entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14791, entity.method_5634(), 0.25f, 3.0f);
                    }
                }
            });
        }
        if (world.field_9236 && this.getEquipmentSlot(armor) == class_1304.field_6172) {
            if (entity.method_24828()) {
                armor.method_57379(CustomDataComponentTypes.THRUSTER_STATE, (Object)ThrusterState.CHARGED);
            } else if (armor.method_57824(CustomDataComponentTypes.THRUSTER_STATE) == ThrusterState.CHARGED) {
                if (!this.isJumping()) {
                    armor.method_57379(CustomDataComponentTypes.THRUSTER_STATE, (Object)ThrusterState.READY);
                }
            } else if (armor.method_57824(CustomDataComponentTypes.THRUSTER_STATE) == ThrusterState.READY && this.isJumping()) {
                this.thrust(entity);
                armor.method_57379(CustomDataComponentTypes.THRUSTER_STATE, (Object)ThrusterState.OFFLINE);
                NetworkHandler.sendToServer(new ArmorCommandMessage(slot, "thrust"));
            }
        }
    }

    private void createSteamParticle(class_1309 entity) {
        entity.method_37908().method_8406((class_2394)class_2398.field_17430, entity.method_23322(0.5), entity.method_23318() - 0.25, entity.method_23325(0.5), ((double)entity.method_59922().method_43057() - 0.5) * 0.1, -0.75 + ((double)entity.method_59922().method_43057() - 0.5) * 0.1, ((double)entity.method_59922().method_43057() - 0.5) * 0.1);
    }

    @Override
    public void receiveCommand(class_1799 armor, class_1937 world, class_1309 entity, int slot, String command) {
        if (command.equals("thrust")) {
            this.thrust(entity);
        }
    }

    private boolean isJumping() {
        class_310 client = class_310.method_1551();
        return client != null && client.field_1724 != null && client.field_1724.field_3913.field_3904;
    }

    private void thrust(class_1309 entity) {
        class_243 velocity = entity.method_18798();
        entity.method_18800(velocity.field_1352, 0.6, velocity.field_1350);
        for (int i = 0; i < 5; ++i) {
            this.createSteamParticle(entity);
        }
        entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_19199, entity.method_5634(), 0.25f, 0.75f);
    }

    private class_1304 getEquipmentSlot(class_1799 stack) {
        return ((class_1738)stack.method_7909()).method_7685();
    }

    public static enum ThrusterState {
        OFFLINE,
        CHARGED,
        READY;

        public static final Codec<ThrusterState> CODEC;
        public static final class_9139<ByteBuf, ThrusterState> PACKET_CODEC;

        static {
            CODEC = new EnumCodec<ThrusterState>(ThrusterState.class);
            PACKET_CODEC = new EnumPacketCodec<ThrusterState>(ThrusterState.class);
        }
    }
}

