/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.client.render.entity.piece;

import immersive_armors.Main;
import immersive_armors.client.render.entity.model.CapeModel;
import immersive_armors.client.render.entity.piece.Piece;
import immersive_armors.item.DyeableExtendedArmorItem;
import immersive_armors.item.ExtendedArmorItem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_572;
import net.minecraft.class_7833;

public class CapePiece<M extends CapeModel<class_1309>>
extends Piece {
    private static final Map<UUID, CapeAngles> capeAngles = new HashMap<UUID, CapeAngles>();
    private final M model;

    public CapePiece(M model) {
        this.model = model;
    }

    private class_2960 getCapeTexture(ExtendedArmorItem item, boolean overlay) {
        return Main.locate("textures/models/armor/" + item.getExtendedMaterial().getName() + "/cape" + (overlay ? "_overlay" : "") + ".png");
    }

    @Override
    public <T extends class_1309, A extends class_572<T>> void render(class_4587 matrices, class_4597 vertexConsumers, int light, T entity, class_1799 itemStack, float tickDelta, class_1304 armorSlot, A armorModel) {
        class_1792 class_17922 = itemStack.method_7909();
        if (class_17922 instanceof ExtendedArmorItem) {
            class_4588 vertexConsumer;
            ExtendedArmorItem armor = (ExtendedArmorItem)class_17922;
            CapeAngles angles = capeAngles.computeIfAbsent(entity.method_5667(), k -> new CapeAngles());
            angles.updateCapeAngles((class_1297)entity, tickDelta);
            matrices.method_22903();
            matrices.method_22904(0.0, 0.0, 0.125);
            float n = entity.field_6220 + (entity.field_6283 - entity.field_6220);
            double o = class_3532.method_15374((float)(n * ((float)Math.PI / 180)));
            double p = -class_3532.method_15362((float)(n * ((float)Math.PI / 180)));
            double q = angles.deltaY * 40.0;
            q = class_3532.method_15350((double)q, (double)-6.0, (double)32.0);
            double r = (angles.deltaX * o + angles.deltaZ * p) * 100.0;
            r = class_3532.method_15350((double)r, (double)0.0, (double)150.0);
            double s = (angles.deltaX * p - angles.deltaZ * o) * 100.0;
            s = class_3532.method_15350((double)s, (double)-20.0, (double)20.0);
            if (r < 0.0) {
                r = 0.0;
            }
            if (entity.method_18276()) {
                q += 22.5;
                matrices.method_22904(0.0, 0.25, 0.0);
            }
            matrices.method_22907(class_7833.field_40714.rotationDegrees((float)(6.0 + r / 2.0 + q)));
            matrices.method_22907(class_7833.field_40718.rotationDegrees((float)(s / 2.0)));
            matrices.method_22907(class_7833.field_40716.rotationDegrees((float)(180.0 - s / 2.0)));
            ((CapeModel)((Object)this.model)).setupAnim(entity, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            if (armor instanceof DyeableExtendedArmorItem) {
                DyeableExtendedArmorItem dyeableArmorItem = (DyeableExtendedArmorItem)armor;
                int c = dyeableArmorItem.getColor(itemStack);
                vertexConsumer = vertexConsumers.getBuffer(class_1921.method_25448((class_2960)this.getCapeTexture(armor, false)));
                ((CapeModel)((Object)this.model)).method_2828(matrices, vertexConsumer, light, class_4608.field_21444, c);
                vertexConsumer = vertexConsumers.getBuffer(class_1921.method_25448((class_2960)this.getCapeTexture(armor, true)));
            } else {
                vertexConsumer = vertexConsumers.getBuffer(class_1921.method_25448((class_2960)this.getCapeTexture(armor, false)));
            }
            ((CapeModel)((Object)this.model)).method_2828(matrices, vertexConsumer, light, class_4608.field_21444, -1);
            matrices.method_22909();
        }
    }

    private static class CapeAngles {
        private double capeX;
        private double capeY;
        private double capeZ;
        private double deltaX;
        private double deltaY;
        private double deltaZ;
        private float lastTickDelta;

        private CapeAngles() {
        }

        private class_243 predictPosition(class_1297 entity, float tickDelta) {
            return new class_243(class_3532.method_16436((double)tickDelta, (double)entity.field_6014, (double)entity.method_23317()), class_3532.method_16436((double)tickDelta, (double)entity.field_6036, (double)entity.method_23318()), class_3532.method_16436((double)tickDelta, (double)entity.field_5969, (double)entity.method_23321()));
        }

        private void updateCapeAngles(class_1297 entity, float tickDelta) {
            float delta;
            class_243 pos = this.predictPosition(entity, tickDelta);
            double dx = pos.method_10216() - this.capeX;
            double dy = pos.method_10214() - this.capeY;
            double dz = pos.method_10215() - this.capeZ;
            if (dx > 10.0 || dx < -10.0) {
                this.capeX = pos.method_10216();
                dx = 0.0;
            }
            if (dy > 10.0 || dy < -10.0) {
                this.capeY = pos.method_10214();
                dy = 0.0;
            }
            if (dz > 10.0 || dz < -10.0) {
                this.capeZ = pos.method_10215();
                dz = 0.0;
            }
            if ((double)(delta = tickDelta - this.lastTickDelta) < 0.0) {
                delta = 1.0f + delta;
            }
            this.lastTickDelta = tickDelta;
            this.capeX += dx * (double)(delta *= 0.25f);
            this.capeZ += dz * (double)delta;
            this.capeY += dy * (double)delta;
            this.deltaX = this.capeX - pos.method_10216();
            this.deltaY = this.capeY - pos.method_10214();
            this.deltaZ = this.capeZ - pos.method_10215();
        }
    }
}

