/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.item;

import com.google.common.base.Suppliers;
import immersive_armors.armor_effects.ArmorEffect;
import immersive_armors.item.ExtendedArmorMaterial;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import org.jetbrains.annotations.NotNull;

public class ExtendedArmorItem
extends class_1738 {
    private Supplier<class_9285> attributeModifiers;
    private final ExtendedArmorMaterial material;

    public ExtendedArmorItem(class_1792.class_1793 settings, class_1738.class_8051 slot, ExtendedArmorMaterial material) {
        super(material.getRegistryReference(), slot, settings.method_7895(slot.method_56690(material.getDurabilityMultiplier())));
        this.material = material;
        this.refreshAttributes();
    }

    public int method_7687() {
        return this.material.getProtection(this.field_41933);
    }

    public float method_26353() {
        return this.material.getToughness();
    }

    public void refreshAttributes() {
        this.attributeModifiers = Suppliers.memoize(() -> {
            float waterMovement;
            float movementSpeed;
            class_9285.class_9286 builder = class_9285.method_57480();
            class_9274 slot = class_9274.method_59524((class_1304)this.field_41933.method_48399());
            class_2960 identifier = class_2960.method_60656((String)("armor." + this.field_41933.method_48400()));
            builder.method_57487(class_5134.field_23724, new class_1322(identifier, (double)this.material.getProtection(this.field_41933), class_1322.class_1323.field_6328), slot);
            builder.method_57487(class_5134.field_23725, new class_1322(identifier, (double)this.material.getToughness(), class_1322.class_1323.field_6328), slot);
            float knockbackResistance = this.material.getKnockbackResistance();
            if (knockbackResistance > 0.0f) {
                builder.method_57487(class_5134.field_23718, new class_1322(identifier, (double)knockbackResistance, class_1322.class_1323.field_6328), slot);
            }
            if ((movementSpeed = -this.material.getWeight()) != 0.0f) {
                builder.method_57487(class_5134.field_23719, new class_1322(identifier, (double)movementSpeed, class_1322.class_1323.field_6331), slot);
            }
            if ((waterMovement = this.material.getWaterMovement()) != 0.0f) {
                builder.method_57487(class_5134.field_51578, new class_1322(identifier, (double)waterMovement, class_1322.class_1323.field_6328), slot);
            }
            return builder.method_57486();
        });
    }

    @NotNull
    public class_9285 method_7844() {
        return this.attributeModifiers.get();
    }

    public ExtendedArmorMaterial getExtendedMaterial() {
        return this.material;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        super.method_7851(stack, context, tooltip, type);
        for (ArmorEffect e : this.getExtendedMaterial().getEffects()) {
            e.appendTooltip(stack, context, tooltip, type);
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        class_1309 livingEntity;
        class_1799 equippedStack;
        super.method_7888(stack, world, entity, slot, selected);
        if (entity instanceof class_1309 && (equippedStack = (livingEntity = (class_1309)entity).method_6118(this.method_7685())) == stack) {
            for (ArmorEffect e : this.getExtendedMaterial().getEffects()) {
                e.equippedTick(stack, world, livingEntity, slot);
            }
        }
    }

    public float applyArmorToDamage(class_1309 entity, class_1282 source, float amount, class_1799 armor) {
        for (ArmorEffect e : this.getExtendedMaterial().getEffects()) {
            amount = e.applyArmorToDamage(entity, source, amount, armor);
        }
        return amount;
    }

    public float applyArmorToAttack(class_1309 target, class_1282 source, float amount, class_1799 armor) {
        for (ArmorEffect e : this.getExtendedMaterial().getEffects()) {
            amount = e.applyArmorToAttack(target, source, amount, armor);
        }
        return amount;
    }
}

