/*
 * Decompiled with CFR 0.152.
 */
package immersive_armors.item;

import immersive_armors.Main;
import immersive_armors.armor_effects.ArmorEffect;
import immersive_armors.client.render.entity.piece.Piece;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1304;
import net.minecraft.class_156;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1856;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class ExtendedArmorMaterial {
    private final String name;
    private int durabilityMultiplier;
    private final EnumMap<class_1738.class_8051, Integer> protection = (EnumMap)class_156.method_654(new EnumMap(class_1738.class_8051.class), map -> {
        map.put(class_1738.class_8051.field_41937, 0);
        map.put(class_1738.class_8051.field_41936, 0);
        map.put(class_1738.class_8051.field_41935, 0);
        map.put(class_1738.class_8051.field_41934, 0);
        map.put(class_1738.class_8051.field_48838, 0);
    });
    private final boolean[] hidesSecondLayer = new boolean[]{false, false, false, false};
    private float toughness;
    private float knockbackResistance;
    private int enchantability;
    private float weight;
    private int color = 10511680;
    private float waterMovement;
    private final List<ArmorEffect> effects = new LinkedList<ArmorEffect>();
    private final Map<String, Float> loot = new HashMap<String, Float>();
    private boolean antiSkeleton;
    private final Map<class_1304, List<Piece>> pieces = new HashMap<class_1304, List<Piece>>();
    private boolean hideCape;
    private class_6880<class_3414> equipSound;
    private Supplier<class_1856> repairIngredient;
    private class_6880<class_1741> registryReference;

    public ExtendedArmorMaterial(String name) {
        this.pieces.put(class_1304.field_6169, new LinkedList());
        this.pieces.put(class_1304.field_6174, new LinkedList());
        this.pieces.put(class_1304.field_6172, new LinkedList());
        this.pieces.put(class_1304.field_6166, new LinkedList());
        this.name = name;
        this.protectionAmount(0, 0, 0, 0);
    }

    public ExtendedArmorMaterial durabilityMultiplier(int durabilityMultiplier) {
        this.durabilityMultiplier = durabilityMultiplier;
        return this;
    }

    public ExtendedArmorMaterial protectionAmount(int helmet, int chestplate, int legging, int boots) {
        this.protection.put(class_1738.class_8051.field_41934, helmet);
        this.protection.put(class_1738.class_8051.field_41935, chestplate);
        this.protection.put(class_1738.class_8051.field_41936, legging);
        this.protection.put(class_1738.class_8051.field_41937, boots);
        this.protection.put(class_1738.class_8051.field_48838, chestplate);
        return this;
    }

    public ExtendedArmorMaterial toughness(float toughness) {
        this.toughness = toughness;
        return this;
    }

    public ExtendedArmorMaterial enchantability(int enchantability) {
        this.enchantability = enchantability;
        return this;
    }

    public ExtendedArmorMaterial equipSound(class_3414 equipSound) {
        return this.equipSound((class_6880<class_3414>)class_6880.method_40223((Object)equipSound));
    }

    public ExtendedArmorMaterial equipSound(class_6880<class_3414> equipSound) {
        this.equipSound = equipSound;
        return this;
    }

    public ExtendedArmorMaterial repairIngredient(Supplier<class_1856> repairIngredient) {
        this.repairIngredient = repairIngredient;
        return this;
    }

    public ExtendedArmorMaterial knockbackReduction(float knockbackReduction) {
        this.knockbackResistance = knockbackReduction;
        return this;
    }

    public ExtendedArmorMaterial weight(float weight) {
        this.weight = weight;
        return this;
    }

    public ExtendedArmorMaterial color(int color) {
        this.color = color;
        return this;
    }

    public ExtendedArmorMaterial waterMovement(float waterMovement) {
        this.waterMovement = waterMovement;
        return this;
    }

    public ExtendedArmorMaterial effect(ArmorEffect effect) {
        this.effects.add(effect);
        return this;
    }

    public ExtendedArmorMaterial antiSkeleton() {
        this.antiSkeleton = true;
        return this;
    }

    public ExtendedArmorMaterial hideCape() {
        this.hideCape = true;
        return this;
    }

    public ExtendedArmorMaterial head(Piece pieceSupplier) {
        this.pieces.get(class_1304.field_6169).add(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial chest(Piece pieceSupplier) {
        this.pieces.get(class_1304.field_6174).add(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial legs(Piece pieceSupplier) {
        this.pieces.get(class_1304.field_6172).add(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial feet(Piece pieceSupplier) {
        this.pieces.get(class_1304.field_6166).add(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial upper(Piece pieceSupplier) {
        this.head(pieceSupplier);
        this.chest(pieceSupplier);
        this.feet(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial lower(Piece pieceSupplier) {
        this.legs(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial full(Piece pieceSupplier) {
        this.upper(pieceSupplier);
        this.lower(pieceSupplier);
        return this;
    }

    public ExtendedArmorMaterial addLoot(String name, float chance) {
        this.loot.put(name, Float.valueOf(chance));
        return this;
    }

    public String getName() {
        return this.name;
    }

    public int getProtection(class_1738.class_8051 slot) {
        return this.protection.get(slot);
    }

    public float getToughness() {
        return this.toughness;
    }

    public int getEnchantability() {
        return this.enchantability;
    }

    public class_6880<class_3414> getEquipSound() {
        return this.equipSound;
    }

    public class_1856 getRepairIngredient() {
        return this.repairIngredient.get();
    }

    public float getKnockbackResistance() {
        return this.knockbackResistance;
    }

    public float getWeight() {
        return this.weight;
    }

    public int getColor() {
        return this.color;
    }

    public float getWaterMovement() {
        return this.waterMovement;
    }

    public List<ArmorEffect> getEffects() {
        if (Main.sharedConfig.enableEffects) {
            return this.effects;
        }
        return Collections.emptyList();
    }

    public boolean shouldHideCape() {
        return this.hideCape;
    }

    public List<Piece> getPieces(class_1304 slot) {
        return this.pieces.get(slot);
    }

    public ExtendedArmorMaterial hidesSecondLayer(boolean head, boolean chest, boolean legs, boolean feet) {
        this.hidesSecondLayer[0] = head;
        this.hidesSecondLayer[1] = chest;
        this.hidesSecondLayer[2] = legs;
        this.hidesSecondLayer[3] = feet;
        return this;
    }

    public boolean[] shouldHideSecondLayer() {
        return this.hidesSecondLayer;
    }

    public boolean isAntiSkeleton() {
        return this.antiSkeleton;
    }

    public EnumMap<class_1738.class_8051, Integer> getProtection() {
        return this.protection;
    }

    public int getDurabilityMultiplier() {
        return this.durabilityMultiplier;
    }

    public Map<String, Float> getLoot() {
        return this.loot;
    }

    public class_1741 getMaterial() {
        return new class_1741(this.protection, this.enchantability, this.equipSound, this.repairIngredient, List.of(), this.toughness, this.knockbackResistance);
    }

    public void registerVanillaMaterial() {
        this.registryReference = class_2378.method_47985((class_2378)class_7923.field_48976, (class_2960)Main.locate(this.getName()), (Object)this.getMaterial());
    }

    public class_6880<class_1741> getRegistryReference() {
        return this.registryReference;
    }
}

