/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.gui;

import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public class PageNumberWidget
extends AbstractWidget {
    private final Font textRenderer;
    private final Consumer<Integer> onPageChange;
    private final int anchorX;
    private Component text;
    private Component hoverText;
    private Component beforeCursor;
    private Component afterCursor;
    public long lastSwitchFocusTime;
    private String input;

    public PageNumberWidget(Consumer<Integer> onPageChange, int x, int y, Font textRenderer) {
        Objects.requireNonNull(textRenderer);
        super(x, y, 0, 9, (Component)Component.empty());
        this.lastSwitchFocusTime = Util.getMillis();
        this.input = "";
        this.onPageChange = onPageChange;
        this.anchorX = x;
        this.textRenderer = textRenderer;
        this.text = CommonComponents.EMPTY;
        this.hoverText = CommonComponents.EMPTY;
        this.beforeCursor = CommonComponents.EMPTY;
        this.afterCursor = CommonComponents.EMPTY;
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float deltaTicks) {
        if (this.isFocused()) {
            int x = this.getX() + this.width;
            context.drawString(this.textRenderer, this.afterCursor, x -= this.textRenderer.width((FormattedText)this.afterCursor), this.getY(), -16777216, false);
            int cursorX = x;
            context.drawString(this.textRenderer, this.input, x -= this.textRenderer.width(this.input), this.getY(), -16777216, false);
            context.drawString(this.textRenderer, this.beforeCursor, x -= this.textRenderer.width((FormattedText)this.beforeCursor), this.getY(), -16777216, false);
            if ((Util.getMillis() - this.lastSwitchFocusTime) / 300L % 2L == 0L) {
                int n = this.getY() - 1;
                int n2 = this.getY() + 1;
                Objects.requireNonNull(this.textRenderer);
                context.fill(cursorX, n, cursorX + 1, n2 + 9, -16777216);
            }
        } else {
            Component text = this.isHovered() ? this.hoverText : this.text;
            int textWidth = this.textRenderer.width((FormattedText)text);
            context.drawString(this.textRenderer, text, this.getX() + this.width - textWidth, this.getY(), -16777216, false);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
        this.defaultButtonNarrationText(builder);
    }

    public boolean charTyped(char chr, int modifiers) {
        if (modifiers != 0) {
            return false;
        }
        if (chr < '0' || chr > '9') {
            return false;
        }
        if (!(this.input.length() < 2 || this.input.equals("10") && chr == '0')) {
            return false;
        }
        this.input = this.input + chr;
        return true;
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (focused) {
            this.lastSwitchFocusTime = Util.getMillis();
            this.input = "";
        }
    }

    public void onClick(double mouseX, double mouseY) {
        this.setFocused(true);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.isFocused()) {
            return super.keyPressed(keyCode, scanCode, modifiers);
        }
        if (!this.input.isEmpty() && keyCode == 259) {
            this.input = Screen.hasControlDown() ? "" : this.input.substring(0, this.input.length() - 1);
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            if (!this.input.isEmpty()) {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
                this.onPageChange.accept(Integer.parseInt(this.input));
            }
            this.setFocused(false);
            return true;
        }
        if (keyCode == 256) {
            this.setFocused(false);
            return true;
        }
        if (keyCode == 263 || keyCode == 262) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void playDownSound(SoundManager soundManager) {
    }

    public void setPageNumber(int page, int total) {
        this.text = Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{page, total});
        this.hoverText = ComponentUtils.mergeStyles((MutableComponent)this.text.copy(), (Style)Style.EMPTY.withUnderlined(Boolean.valueOf(true)));
        MutableComponent indicator = Component.translatable((String)"book.pageIndicator", (Object[])new Object[]{"--INDICATOR--", total});
        String[] parts = indicator.getString().split("--INDICATOR--", 2);
        Style gray = Style.EMPTY.withColor(ChatFormatting.DARK_GRAY);
        this.beforeCursor = Component.literal((String)parts[0]).setStyle(gray);
        this.afterCursor = parts.length > 1 ? Component.literal((String)parts[1]).setStyle(gray) : CommonComponents.EMPTY;
        this.width = this.textRenderer.width((FormattedText)this.text);
        this.setX(this.anchorX - this.width);
    }
}

