/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.history.command;

import java.util.Set;
import java.util.function.Consumer;
import me.chrr.scribble.book.RichText;
import me.chrr.scribble.gui.edit.RichEditBox;
import me.chrr.scribble.history.HistoryListener;
import me.chrr.scribble.history.command.Command;
import net.minecraft.ChatFormatting;
import org.jetbrains.annotations.Nullable;

public class EditCommand
implements Command {
    private final RichText text;
    private final Consumer<RichEditBox> action;
    public int page = -1;
    @Nullable
    public ChatFormatting color = null;
    public Set<ChatFormatting> modifiers = Set.of();
    private final int cursor;
    private final int selectionEnd;
    private final boolean selecting;

    public EditCommand(RichEditBox editBox, Consumer<RichEditBox> action) {
        this.text = editBox.getRichText();
        this.action = action;
        this.cursor = editBox.cursor;
        this.selectionEnd = editBox.selectCursor;
        this.selecting = editBox.selecting;
    }

    public void executeEdit(RichEditBox editBox) {
        editBox.cursor = this.cursor;
        editBox.selectCursor = this.selectionEnd;
        editBox.selecting = this.selecting;
        this.action.accept(editBox);
    }

    @Override
    public void execute(HistoryListener listener) {
        listener.scribble$history$switchPage(this.page);
        listener.scribble$history$setFormat(this.color, this.modifiers);
        RichEditBox editBox = listener.scribble$history$getRichEditBox();
        this.executeEdit(editBox);
    }

    @Override
    public void rollback(HistoryListener listener) {
        listener.scribble$history$switchPage(this.page);
        listener.scribble$history$setFormat(this.color, this.modifiers);
        RichEditBox editBox = listener.scribble$history$getRichEditBox();
        editBox.cursor = this.cursor;
        editBox.selectCursor = this.selectionEnd;
        editBox.selecting = this.selecting;
        editBox.setRichTextWithoutUpdating(this.text);
        editBox.onValueChange();
        editBox.sendUpdateFormat();
    }
}

