/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import me.chrr.scribble.KeyboardUtil;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.book.BookFile;
import me.chrr.scribble.book.FileChooser;
import me.chrr.scribble.book.RichText;
import me.chrr.scribble.config.Config;
import me.chrr.scribble.gui.PageNumberWidget;
import me.chrr.scribble.gui.button.ColorSwatchWidget;
import me.chrr.scribble.gui.button.IconButtonWidget;
import me.chrr.scribble.gui.button.ModifierButtonWidget;
import me.chrr.scribble.gui.edit.RichEditBox;
import me.chrr.scribble.gui.edit.RichEditBoxWidget;
import me.chrr.scribble.history.CommandManager;
import me.chrr.scribble.history.HistoryListener;
import me.chrr.scribble.history.command.EditCommand;
import me.chrr.scribble.history.command.PageDeleteCommand;
import me.chrr.scribble.history.command.PageInsertCommand;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BookEditScreen.class})
public abstract class BookEditScreenMixin
extends Screen
implements HistoryListener {
    @Unique
    private static final ChatFormatting[] scribble$COLORS = new ChatFormatting[]{ChatFormatting.BLACK, ChatFormatting.DARK_GRAY, ChatFormatting.GRAY, ChatFormatting.WHITE, ChatFormatting.DARK_RED, ChatFormatting.RED, ChatFormatting.GOLD, ChatFormatting.YELLOW, ChatFormatting.DARK_GREEN, ChatFormatting.GREEN, ChatFormatting.DARK_AQUA, ChatFormatting.AQUA, ChatFormatting.DARK_BLUE, ChatFormatting.BLUE, ChatFormatting.DARK_PURPLE, ChatFormatting.LIGHT_PURPLE};
    @Shadow
    private MultiLineEditBox page;
    @Shadow
    @Final
    private List<String> pages;
    @Shadow
    private int currentPage;
    @Shadow
    @Final
    private Player owner;
    @Unique
    private ModifierButtonWidget scribble$boldButton;
    @Unique
    private ModifierButtonWidget scribble$italicButton;
    @Unique
    private ModifierButtonWidget scribble$underlineButton;
    @Unique
    private ModifierButtonWidget scribble$strikethroughButton;
    @Unique
    private ModifierButtonWidget scribble$obfuscatedButton;
    @Unique
    private List<ColorSwatchWidget> scribble$colorSwatches = List.of();
    @Unique
    private IconButtonWidget scribble$deletePageButton;
    @Unique
    private IconButtonWidget scribble$insertPageButton;
    @Unique
    private IconButtonWidget scribble$undoButton;
    @Unique
    private IconButtonWidget scribble$redoButton;
    @Unique
    private PageNumberWidget scribble$pageNumberWidget;
    @Unique
    private boolean scribble$dirty = false;
    @Unique
    private final CommandManager scribble$commandManager = new CommandManager(this);

    @Shadow
    protected abstract void updatePageContent();

    @Shadow
    protected abstract void updateButtonVisibility();

    private BookEditScreenMixin() {
        super(null);
    }

    @Redirect(method={"init()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/MultiLineEditBox;builder()Lnet/minecraft/client/gui/components/MultiLineEditBox$Builder;"))
    public MultiLineEditBox.Builder buildEditBoxWidget() {
        return new RichEditBoxWidget.Builder().onInvalidateFormat(this::scribble$invalidateFormattingButtons).onHistoryPush(this::scribble$pushEditCommand);
    }

    @Unique
    private RichEditBoxWidget scribble$getRichEditBoxWidget() {
        return (RichEditBoxWidget)this.page;
    }

    @Inject(method={"init()V"}, at={@At(value="TAIL")})
    public void initFormattingButtons(CallbackInfo ci) {
        int x = this.width / 2 + 78;
        int y = Scribble.getBookScreenYOffset(this.height) + 12;
        this.scribble$boldButton = this.scribble$addModifierButton(ChatFormatting.BOLD, (Component)Component.translatable((String)"text.scribble.modifier.bold"), x, y, 0, 0, 22, 19);
        this.scribble$italicButton = this.scribble$addModifierButton(ChatFormatting.ITALIC, (Component)Component.translatable((String)"text.scribble.modifier.italic"), x, y + 19, 0, 19, 22, 17);
        this.scribble$underlineButton = this.scribble$addModifierButton(ChatFormatting.UNDERLINE, (Component)Component.translatable((String)"text.scribble.modifier.underline"), x, y + 36, 0, 36, 22, 17);
        this.scribble$strikethroughButton = this.scribble$addModifierButton(ChatFormatting.STRIKETHROUGH, (Component)Component.translatable((String)"text.scribble.modifier.strikethrough"), x, y + 53, 0, 53, 22, 17);
        this.scribble$obfuscatedButton = this.scribble$addModifierButton(ChatFormatting.OBFUSCATED, (Component)Component.translatable((String)"text.scribble.modifier.obfuscated"), x, y + 70, 0, 70, 22, 18);
        RichEditBoxWidget editBox = this.scribble$getRichEditBoxWidget();
        this.scribble$colorSwatches = new ArrayList<ColorSwatchWidget>(scribble$COLORS.length);
        for (int i = 0; i < scribble$COLORS.length; ++i) {
            ChatFormatting color = scribble$COLORS[i];
            int dx = i % 2 * 8;
            int dy = i / 2 * 8;
            ColorSwatchWidget swatch = new ColorSwatchWidget((Component)Component.translatable((String)("text.scribble.color." + color.getName())), color, () -> editBox.applyFormatting(color, true), x + 3 + dx, y + 95 + dy, 8, 8, editBox.color == color);
            ColorSwatchWidget widget = (ColorSwatchWidget)this.addRenderableWidget((GuiEventListener)swatch);
            this.scribble$colorSwatches.add(widget);
        }
        this.scribble$invalidateFormattingButtons();
    }

    @Unique
    private ModifierButtonWidget scribble$addModifierButton(ChatFormatting modifier, Component tooltip, int x, int y, int u, int v, int width, int height) {
        RichEditBoxWidget editBox = this.scribble$getRichEditBoxWidget();
        ModifierButtonWidget button = new ModifierButtonWidget(tooltip, toggled -> editBox.applyFormatting(modifier, (boolean)toggled), x, y, u, v, width, height, editBox.modifiers.contains(modifier));
        return (ModifierButtonWidget)this.addRenderableWidget((GuiEventListener)button);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        boolean handled = super.mouseClicked(mouseX, mouseY, button);
        GuiEventListener focused = this.getFocused();
        if (focused instanceof ModifierButtonWidget || focused instanceof ColorSwatchWidget || focused instanceof PageButton) {
            this.setFocused((GuiEventListener)this.page);
        }
        return handled;
    }

    @Unique
    private void scribble$invalidateFormattingButtons() {
        RichEditBoxWidget editBox = this.scribble$getRichEditBoxWidget();
        if (this.scribble$boldButton == null) {
            return;
        }
        this.scribble$boldButton.toggled = editBox.modifiers.contains(ChatFormatting.BOLD);
        this.scribble$italicButton.toggled = editBox.modifiers.contains(ChatFormatting.ITALIC);
        this.scribble$underlineButton.toggled = editBox.modifiers.contains(ChatFormatting.UNDERLINE);
        this.scribble$strikethroughButton.toggled = editBox.modifiers.contains(ChatFormatting.STRIKETHROUGH);
        this.scribble$obfuscatedButton.toggled = editBox.modifiers.contains(ChatFormatting.OBFUSCATED);
        this.scribble$setSwatchColor(editBox.color);
    }

    @Unique
    private void scribble$setSwatchColor(ChatFormatting color) {
        for (ColorSwatchWidget swatch : this.scribble$colorSwatches) {
            swatch.setToggled(swatch.getColor() == color);
        }
    }

    @Inject(method={"init()V"}, at={@At(value="HEAD")})
    public void initPageButtons(CallbackInfo ci) {
        int x = this.width / 2 - 96;
        int y = Scribble.getBookScreenYOffset(this.height) + 12;
        this.scribble$deletePageButton = (IconButtonWidget)this.addRenderableWidget((GuiEventListener)new IconButtonWidget((Component)Component.translatable((String)"text.scribble.action.delete_page"), this::scribble$deletePage, x + 94, y + 148, 0, 90, 12, 12));
        this.scribble$insertPageButton = (IconButtonWidget)this.addRenderableWidget((GuiEventListener)new IconButtonWidget((Component)Component.translatable((String)"text.scribble.action.insert_new_page"), this::scribble$insertPage, x + 78, y + 148, 12, 90, 12, 12));
    }

    @Inject(method={"updateButtonVisibility()V"}, at={@At(value="HEAD")})
    public void invalidatePageButtons(CallbackInfo ci) {
        this.scribble$deletePageButton.visible = this.pages.size() > 1;
        this.scribble$insertPageButton.visible = this.pages.size() < 100;
    }

    @Unique
    private void scribble$deletePage() {
        if (this.pages.size() > 1) {
            PageDeleteCommand command = new PageDeleteCommand(this.currentPage, this.scribble$getRichEditBoxWidget().getRichEditBox().getRichText());
            command.execute(this);
            this.scribble$commandManager.push(command);
            this.scribble$dirty = true;
        }
    }

    @Unique
    private void scribble$insertPage() {
        if (this.pages.size() < 100) {
            PageInsertCommand command = new PageInsertCommand(this.currentPage);
            command.execute(this);
            this.scribble$commandManager.push(command);
            this.scribble$dirty = true;
        }
    }

    @Inject(method={"init()V"}, at={@At(value="TAIL")})
    public void initActionButtons(CallbackInfo ci) {
        int ax = this.width / 2 - 78 - 7 - 12;
        int ay = Scribble.getBookScreenYOffset(this.height) + 12 + 4;
        this.scribble$undoButton = (IconButtonWidget)this.addRenderableWidget((GuiEventListener)new IconButtonWidget((Component)Component.translatable((String)"text.scribble.action.undo"), () -> {
            this.scribble$commandManager.tryUndo();
            this.scribble$invalidateActionButtons();
        }, ax, ay, 24, 90, 12, 12));
        this.scribble$redoButton = (IconButtonWidget)this.addRenderableWidget((GuiEventListener)new IconButtonWidget((Component)Component.translatable((String)"text.scribble.action.redo"), () -> {
            this.scribble$commandManager.tryRedo();
            this.scribble$invalidateActionButtons();
        }, ax, ay + 12, 36, 90, 12, 12));
        if (Scribble.CONFIG_MANAGER.getConfig().showActionButtons != Config.ShowActionButtons.NEVER) {
            this.addRenderableWidget((GuiEventListener)new IconButtonWidget((Component)Component.translatable((String)"text.scribble.action.save_book_to_file"), () -> FileChooser.chooseBook(true, this::scribble$saveTo), ax, ay + 24 + 4, 48, 90, 12, 12));
            this.addRenderableWidget((GuiEventListener)new IconButtonWidget((Component)Component.translatable((String)"text.scribble.action.load_book_from_file"), () -> this.scribble$confirmIf(true, "overwrite_warning", () -> FileChooser.chooseBook(false, this::scribble$loadFrom)), ax, ay + 36 + 4, 60, 90, 12, 12));
        }
        this.scribble$invalidateActionButtons();
    }

    @Unique
    private void scribble$invalidateActionButtons() {
        boolean show;
        this.scribble$undoButton.visible = show = Scribble.CONFIG_MANAGER.getConfig().showActionButtons != Config.ShowActionButtons.NEVER;
        this.scribble$redoButton.visible = show;
        this.scribble$undoButton.active = this.scribble$commandManager.canUndo();
        this.scribble$redoButton.active = this.scribble$commandManager.canRedo();
    }

    @Inject(method={"keyPressed(III)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void onActionKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (Screen.hasControlDown() && !Screen.hasAltDown()) {
            boolean shift = Screen.hasShiftDown();
            if (KeyboardUtil.isKey(keyCode, "Z") && !shift && this.scribble$undoButton.active) {
                this.scribble$undoButton.onPress();
                cir.setReturnValue((Object)true);
            } else if ((KeyboardUtil.isKey(keyCode, "Z") && shift || KeyboardUtil.isKey(keyCode, "Y") && !shift) && this.scribble$redoButton.active) {
                this.scribble$redoButton.onPress();
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"init()V"}, at={@At(value="HEAD")})
    public void initPageNumberWidget(CallbackInfo ci) {
        int x = (this.width - 192) / 2;
        int y = Scribble.getBookScreenYOffset(this.height);
        this.scribble$pageNumberWidget = (PageNumberWidget)this.addRenderableWidget((GuiEventListener)new PageNumberWidget(page -> {
            this.currentPage = Math.clamp((long)(page - 1), 0, this.pages.size() - 1);
            this.updatePageContent();
            this.updateButtonVisibility();
            this.setFocused((GuiEventListener)this.page);
        }, x + 192 - 44, y + 18, this.font));
    }

    @Inject(method={"updatePageContent()V"}, at={@At(value="HEAD")})
    public void updatePageNumber(CallbackInfo ci) {
        this.scribble$pageNumberWidget.setPageNumber(this.currentPage + 1, this.pages.size());
    }

    @Redirect(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIZ)V"))
    public void drawIndicatorText(GuiGraphics instance, Font textRenderer, Component text, int x, int y, int color, boolean shadow) {
    }

    @Override
    public void scribble$history$switchPage(int page) {
        if (page < 0 || page >= this.pages.size()) {
            return;
        }
        this.currentPage = page;
        this.updatePageContent();
        this.updateButtonVisibility();
    }

    @Override
    public void scribble$history$setFormat(@Nullable ChatFormatting color, Set<ChatFormatting> modifiers) {
        RichEditBoxWidget editBox = this.scribble$getRichEditBoxWidget();
        editBox.color = color;
        editBox.modifiers = new HashSet<ChatFormatting>(modifiers);
        this.scribble$invalidateFormattingButtons();
    }

    @Override
    public void scribble$history$insertPage(int page, @Nullable RichText content) {
        this.scribble$history$switchPage(page);
        String text = "";
        if (content != null) {
            text = content.getAsFormattedString();
        }
        this.pages.add(page, text);
        this.updatePageContent();
        this.updateButtonVisibility();
    }

    @Override
    public void scribble$history$deletePage(int page) {
        this.scribble$history$switchPage(page);
        this.pages.remove(page);
        if (this.currentPage == this.pages.size()) {
            --this.currentPage;
        }
        this.updatePageContent();
        this.updateButtonVisibility();
    }

    @Override
    public RichEditBox scribble$history$getRichEditBox() {
        return this.scribble$getRichEditBoxWidget().getRichEditBox();
    }

    @Unique
    private void scribble$pushEditCommand(EditCommand command) {
        RichEditBoxWidget editBox = this.scribble$getRichEditBoxWidget();
        command.page = this.currentPage;
        command.color = editBox.color;
        command.modifiers = editBox.modifiers;
        this.scribble$commandManager.push(command);
        this.scribble$invalidateActionButtons();
    }

    @Inject(method={"pageForward()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void openNextPage(CallbackInfo ci) {
        int lastPage = this.pages.size() - 1;
        if (this.currentPage < lastPage && Screen.hasShiftDown()) {
            this.currentPage = lastPage;
            this.updatePageContent();
            this.updateButtonVisibility();
            ci.cancel();
        }
    }

    @Inject(method={"pageBack()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void openPreviousPage(CallbackInfo ci) {
        if (Screen.hasShiftDown()) {
            this.currentPage = 0;
            this.updatePageContent();
            this.updateButtonVisibility();
            ci.cancel();
        }
    }

    @Unique
    private void scribble$saveTo(Path path) {
        try {
            BookFile bookFile = new BookFile(this.owner.getName().getString(), this.pages);
            bookFile.writeJson(path);
        }
        catch (Exception e) {
            Scribble.LOGGER.error("could not save book to file", (Throwable)e);
        }
    }

    @Unique
    private void scribble$loadFrom(Path path) {
        try {
            BookFile bookFile = BookFile.readFile(path);
            this.pages.clear();
            this.pages.addAll(bookFile.pages());
            this.currentPage = 0;
            this.updatePageContent();
            this.updateButtonVisibility();
            this.scribble$dirty = true;
        }
        catch (Exception e) {
            Scribble.LOGGER.error("could not load book from file", (Throwable)e);
        }
    }

    @ModifyArg(method={"init()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/MultiLineEditBox;setValueListener(Ljava/util/function/Consumer;)V"), index=0)
    public Consumer<String> modifyChangeListener(Consumer<String> changeListener) {
        return text -> {
            if (!text.equals(this.pages.get(this.currentPage))) {
                this.scribble$dirty = true;
            }
            changeListener.accept((String)text);
        };
    }

    @Unique
    public void scribble$confirmIf(boolean condition, String name, Runnable runnable) {
        if (condition && this.minecraft != null) {
            this.minecraft.setScreen((Screen)new ConfirmScreen(confirmed -> {
                this.minecraft.setScreen((Screen)this);
                if (confirmed) {
                    runnable.run();
                }
            }, (Component)Component.translatable((String)("text.scribble." + name + ".title")), (Component)Component.translatable((String)("text.scribble." + name + ".description"))));
        } else {
            runnable.run();
        }
    }

    public void onClose() {
        this.scribble$confirmIf(this.scribble$dirty, "quit_without_saving", () -> super.onClose());
    }

    @ModifyArg(method={"renderBackground(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIFFIIII)V"), index=3)
    public int shiftBackgroundY(int y) {
        return Scribble.getBookScreenYOffset(this.height) + y;
    }

    @WrapOperation(method={"init()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/BookEditScreen;addRenderableWidget(Lnet/minecraft/client/gui/components/events/GuiEventListener;)Lnet/minecraft/client/gui/components/events/GuiEventListener;")})
    public <T extends GuiEventListener & Renderable> T shiftButtonY(BookEditScreen instance, GuiEventListener element, Operation<T> original) {
        if (element instanceof LayoutElement) {
            LayoutElement widget = (LayoutElement)element;
            widget.setY(widget.getY() + Scribble.getBookScreenYOffset(this.height));
        }
        return (T)((GuiEventListener)original.call(new Object[]{instance, element}));
    }

    @ModifyArg(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIZ)V"), index=3)
    public int shiftPageNumberY(int y) {
        return Scribble.getBookScreenYOffset(this.height) + y;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (mouseX < (double)(this.width - 152) / 2.0 || mouseX > (double)(this.width + 152) / 2.0) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }
}

