/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import me.chrr.scribble.KeyboardUtil;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.book.BookFile;
import me.chrr.scribble.book.FileChooser;
import me.chrr.scribble.book.RichText;
import me.chrr.scribble.config.Config;
import me.chrr.scribble.gui.PageNumberWidget;
import me.chrr.scribble.gui.button.ColorSwatchWidget;
import me.chrr.scribble.gui.button.IconButtonWidget;
import me.chrr.scribble.gui.button.ModifierButtonWidget;
import me.chrr.scribble.gui.edit.RichEditBox;
import me.chrr.scribble.gui.edit.RichEditBoxWidget;
import me.chrr.scribble.history.CommandManager;
import me.chrr.scribble.history.HistoryListener;
import me.chrr.scribble.history.command.EditCommand;
import me.chrr.scribble.history.command.PageDeleteCommand;
import me.chrr.scribble.history.command.PageInsertCommand;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_410;
import net.minecraft.class_437;
import net.minecraft.class_473;
import net.minecraft.class_474;
import net.minecraft.class_7529;
import net.minecraft.class_8021;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_473.class})
public abstract class BookEditScreenMixin
extends class_437
implements HistoryListener {
    @Unique
    private static final class_124[] scribble$COLORS = new class_124[]{class_124.field_1074, class_124.field_1063, class_124.field_1080, class_124.field_1068, class_124.field_1079, class_124.field_1061, class_124.field_1065, class_124.field_1054, class_124.field_1077, class_124.field_1060, class_124.field_1062, class_124.field_1075, class_124.field_1058, class_124.field_1078, class_124.field_1064, class_124.field_1076};
    @Shadow
    private class_7529 field_60462;
    @Shadow
    @Final
    private List<String> field_17116;
    @Shadow
    private int field_2840;
    @Shadow
    @Final
    private class_1657 field_2826;
    @Unique
    private ModifierButtonWidget scribble$boldButton;
    @Unique
    private ModifierButtonWidget scribble$italicButton;
    @Unique
    private ModifierButtonWidget scribble$underlineButton;
    @Unique
    private ModifierButtonWidget scribble$strikethroughButton;
    @Unique
    private ModifierButtonWidget scribble$obfuscatedButton;
    @Unique
    private List<ColorSwatchWidget> scribble$colorSwatches = List.of();
    @Unique
    private IconButtonWidget scribble$deletePageButton;
    @Unique
    private IconButtonWidget scribble$insertPageButton;
    @Unique
    private IconButtonWidget scribble$undoButton;
    @Unique
    private IconButtonWidget scribble$redoButton;
    @Unique
    private PageNumberWidget scribble$pageNumberWidget;
    @Unique
    private boolean scribble$dirty = false;
    @Unique
    private final CommandManager scribble$commandManager = new CommandManager(this);

    @Shadow
    protected abstract void method_71537();

    @Shadow
    protected abstract void method_71538();

    private BookEditScreenMixin() {
        super(null);
    }

    @Redirect(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/EditBoxWidget;builder()Lnet/minecraft/client/gui/widget/EditBoxWidget$Builder;"))
    public class_7529.class_11383 buildEditBoxWidget() {
        return new RichEditBoxWidget.Builder().onInvalidateFormat(this::scribble$invalidateFormattingButtons).onHistoryPush(this::scribble$pushEditCommand);
    }

    @Unique
    private RichEditBoxWidget scribble$getRichEditBoxWidget() {
        return (RichEditBoxWidget)this.field_60462;
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void initFormattingButtons(CallbackInfo ci) {
        int x = this.field_22789 / 2 + 78;
        int y = Scribble.getBookScreenYOffset(this.field_22790) + 12;
        this.scribble$boldButton = this.scribble$addModifierButton(class_124.field_1067, (class_2561)class_2561.method_43471((String)"text.scribble.modifier.bold"), x, y, 0, 0, 22, 19);
        this.scribble$italicButton = this.scribble$addModifierButton(class_124.field_1056, (class_2561)class_2561.method_43471((String)"text.scribble.modifier.italic"), x, y + 19, 0, 19, 22, 17);
        this.scribble$underlineButton = this.scribble$addModifierButton(class_124.field_1073, (class_2561)class_2561.method_43471((String)"text.scribble.modifier.underline"), x, y + 36, 0, 36, 22, 17);
        this.scribble$strikethroughButton = this.scribble$addModifierButton(class_124.field_1055, (class_2561)class_2561.method_43471((String)"text.scribble.modifier.strikethrough"), x, y + 53, 0, 53, 22, 17);
        this.scribble$obfuscatedButton = this.scribble$addModifierButton(class_124.field_1051, (class_2561)class_2561.method_43471((String)"text.scribble.modifier.obfuscated"), x, y + 70, 0, 70, 22, 18);
        RichEditBoxWidget editBox = this.scribble$getRichEditBoxWidget();
        this.scribble$colorSwatches = new ArrayList<ColorSwatchWidget>(scribble$COLORS.length);
        for (int i = 0; i < scribble$COLORS.length; ++i) {
            class_124 color = scribble$COLORS[i];
            int dx = i % 2 * 8;
            int dy = i / 2 * 8;
            ColorSwatchWidget swatch = new ColorSwatchWidget((class_2561)class_2561.method_43471((String)("text.scribble.color." + color.method_537())), color, () -> editBox.applyFormatting(color, true), x + 3 + dx, y + 95 + dy, 8, 8, editBox.color == color);
            ColorSwatchWidget widget = (ColorSwatchWidget)this.method_37063((class_364)swatch);
            this.scribble$colorSwatches.add(widget);
        }
        this.scribble$invalidateFormattingButtons();
    }

    @Unique
    private ModifierButtonWidget scribble$addModifierButton(class_124 modifier, class_2561 tooltip, int x, int y, int u, int v, int width, int height) {
        RichEditBoxWidget editBox = this.scribble$getRichEditBoxWidget();
        ModifierButtonWidget button = new ModifierButtonWidget(tooltip, toggled -> editBox.applyFormatting(modifier, (boolean)toggled), x, y, u, v, width, height, editBox.modifiers.contains(modifier));
        return (ModifierButtonWidget)this.method_37063((class_364)button);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        boolean handled = super.method_25402(mouseX, mouseY, button);
        class_364 focused = this.method_25399();
        if (focused instanceof ModifierButtonWidget || focused instanceof ColorSwatchWidget || focused instanceof class_474) {
            this.method_25395((class_364)this.field_60462);
        }
        return handled;
    }

    @Unique
    private void scribble$invalidateFormattingButtons() {
        RichEditBoxWidget editBox = this.scribble$getRichEditBoxWidget();
        if (this.scribble$boldButton == null) {
            return;
        }
        this.scribble$boldButton.toggled = editBox.modifiers.contains(class_124.field_1067);
        this.scribble$italicButton.toggled = editBox.modifiers.contains(class_124.field_1056);
        this.scribble$underlineButton.toggled = editBox.modifiers.contains(class_124.field_1073);
        this.scribble$strikethroughButton.toggled = editBox.modifiers.contains(class_124.field_1055);
        this.scribble$obfuscatedButton.toggled = editBox.modifiers.contains(class_124.field_1051);
        this.scribble$setSwatchColor(editBox.color);
    }

    @Unique
    private void scribble$setSwatchColor(class_124 color) {
        for (ColorSwatchWidget swatch : this.scribble$colorSwatches) {
            swatch.setToggled(swatch.getColor() == color);
        }
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    public void initPageButtons(CallbackInfo ci) {
        int x = this.field_22789 / 2 - 96;
        int y = Scribble.getBookScreenYOffset(this.field_22790) + 12;
        this.scribble$deletePageButton = (IconButtonWidget)this.method_37063((class_364)new IconButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.action.delete_page"), this::scribble$deletePage, x + 94, y + 148, 0, 90, 12, 12));
        this.scribble$insertPageButton = (IconButtonWidget)this.method_37063((class_364)new IconButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.action.insert_new_page"), this::scribble$insertPage, x + 78, y + 148, 12, 90, 12, 12));
    }

    @Inject(method={"updatePreviousPageButtonVisibility"}, at={@At(value="HEAD")})
    public void invalidatePageButtons(CallbackInfo ci) {
        this.scribble$deletePageButton.field_22764 = this.field_17116.size() > 1;
        this.scribble$insertPageButton.field_22764 = this.field_17116.size() < 100;
    }

    @Unique
    private void scribble$deletePage() {
        if (this.field_17116.size() > 1) {
            PageDeleteCommand command = new PageDeleteCommand(this.field_2840, this.scribble$getRichEditBoxWidget().getRichEditBox().getRichText());
            command.execute(this);
            this.scribble$commandManager.push(command);
            this.scribble$dirty = true;
        }
    }

    @Unique
    private void scribble$insertPage() {
        if (this.field_17116.size() < 100) {
            PageInsertCommand command = new PageInsertCommand(this.field_2840);
            command.execute(this);
            this.scribble$commandManager.push(command);
            this.scribble$dirty = true;
        }
    }

    @Inject(method={"init"}, at={@At(value="TAIL")})
    public void initActionButtons(CallbackInfo ci) {
        int ax = this.field_22789 / 2 - 78 - 7 - 12;
        int ay = Scribble.getBookScreenYOffset(this.field_22790) + 12 + 4;
        this.scribble$undoButton = (IconButtonWidget)this.method_37063((class_364)new IconButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.action.undo"), () -> {
            this.scribble$commandManager.tryUndo();
            this.scribble$invalidateActionButtons();
        }, ax, ay, 24, 90, 12, 12));
        this.scribble$redoButton = (IconButtonWidget)this.method_37063((class_364)new IconButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.action.redo"), () -> {
            this.scribble$commandManager.tryRedo();
            this.scribble$invalidateActionButtons();
        }, ax, ay + 12, 36, 90, 12, 12));
        if (Scribble.CONFIG_MANAGER.getConfig().showActionButtons != Config.ShowActionButtons.NEVER) {
            this.method_37063((class_364)new IconButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.action.save_book_to_file"), () -> FileChooser.chooseBook(true, this::scribble$saveTo), ax, ay + 24 + 4, 48, 90, 12, 12));
            this.method_37063((class_364)new IconButtonWidget((class_2561)class_2561.method_43471((String)"text.scribble.action.load_book_from_file"), () -> this.scribble$confirmIf(true, "overwrite_warning", () -> FileChooser.chooseBook(false, this::scribble$loadFrom)), ax, ay + 36 + 4, 60, 90, 12, 12));
        }
        this.scribble$invalidateActionButtons();
    }

    @Unique
    private void scribble$invalidateActionButtons() {
        boolean show;
        this.scribble$undoButton.field_22764 = show = Scribble.CONFIG_MANAGER.getConfig().showActionButtons != Config.ShowActionButtons.NEVER;
        this.scribble$redoButton.field_22764 = show;
        this.scribble$undoButton.field_22763 = this.scribble$commandManager.canUndo();
        this.scribble$redoButton.field_22763 = this.scribble$commandManager.canRedo();
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void onActionKeyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (class_437.method_25441() && !class_437.method_25443()) {
            boolean shift = class_437.method_25442();
            if (KeyboardUtil.isKey(keyCode, "Z") && !shift && this.scribble$undoButton.field_22763) {
                this.scribble$undoButton.method_25306();
                cir.setReturnValue((Object)true);
            } else if ((KeyboardUtil.isKey(keyCode, "Z") && shift || KeyboardUtil.isKey(keyCode, "Y") && !shift) && this.scribble$redoButton.field_22763) {
                this.scribble$redoButton.method_25306();
                cir.setReturnValue((Object)true);
            }
        }
    }

    @Inject(method={"init"}, at={@At(value="HEAD")})
    public void initPageNumberWidget(CallbackInfo ci) {
        int x = (this.field_22789 - 192) / 2;
        int y = Scribble.getBookScreenYOffset(this.field_22790);
        this.scribble$pageNumberWidget = (PageNumberWidget)this.method_37063((class_364)new PageNumberWidget(page -> {
            this.field_2840 = Math.clamp((long)(page - 1), 0, this.field_17116.size() - 1);
            this.method_71537();
            this.method_71538();
            this.method_25395((class_364)this.field_60462);
        }, x + 192 - 44, y + 18, this.field_22793));
    }

    @Inject(method={"updatePage"}, at={@At(value="HEAD")})
    public void updatePageNumber(CallbackInfo ci) {
        this.scribble$pageNumberWidget.setPageNumber(this.field_2840 + 1, this.field_17116.size());
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawText(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;IIIZ)V"))
    public void drawIndicatorText(class_332 instance, class_327 textRenderer, class_2561 text, int x, int y, int color, boolean shadow) {
    }

    @Override
    public void scribble$history$switchPage(int page) {
        if (page < 0 || page >= this.field_17116.size()) {
            return;
        }
        this.field_2840 = page;
        this.method_71537();
        this.method_71538();
    }

    @Override
    public void scribble$history$setFormat(@Nullable class_124 color, Set<class_124> modifiers) {
        RichEditBoxWidget editBox = this.scribble$getRichEditBoxWidget();
        editBox.color = color;
        editBox.modifiers = new HashSet<class_124>(modifiers);
        this.scribble$invalidateFormattingButtons();
    }

    @Override
    public void scribble$history$insertPage(int page, @Nullable RichText content) {
        this.scribble$history$switchPage(page);
        String text = "";
        if (content != null) {
            text = content.getAsFormattedString();
        }
        this.field_17116.add(page, text);
        this.method_71537();
        this.method_71538();
    }

    @Override
    public void scribble$history$deletePage(int page) {
        this.scribble$history$switchPage(page);
        this.field_17116.remove(page);
        if (this.field_2840 == this.field_17116.size()) {
            --this.field_2840;
        }
        this.method_71537();
        this.method_71538();
    }

    @Override
    public RichEditBox scribble$history$getRichEditBox() {
        return this.scribble$getRichEditBoxWidget().getRichEditBox();
    }

    @Unique
    private void scribble$pushEditCommand(EditCommand command) {
        RichEditBoxWidget editBox = this.scribble$getRichEditBoxWidget();
        command.page = this.field_2840;
        command.color = editBox.color;
        command.modifiers = editBox.modifiers;
        this.scribble$commandManager.push(command);
        this.scribble$invalidateActionButtons();
    }

    @Inject(method={"openNextPage"}, at={@At(value="HEAD")}, cancellable=true)
    public void openNextPage(CallbackInfo ci) {
        int lastPage = this.field_17116.size() - 1;
        if (this.field_2840 < lastPage && class_437.method_25442()) {
            this.field_2840 = lastPage;
            this.method_71537();
            this.method_71538();
            ci.cancel();
        }
    }

    @Inject(method={"openPreviousPage"}, at={@At(value="HEAD")}, cancellable=true)
    public void openPreviousPage(CallbackInfo ci) {
        if (class_437.method_25442()) {
            this.field_2840 = 0;
            this.method_71537();
            this.method_71538();
            ci.cancel();
        }
    }

    @Unique
    private void scribble$saveTo(Path path) {
        try {
            BookFile bookFile = new BookFile(this.field_2826.method_5477().getString(), this.field_17116);
            bookFile.writeJson(path);
        }
        catch (Exception e) {
            Scribble.LOGGER.error("could not save book to file", (Throwable)e);
        }
    }

    @Unique
    private void scribble$loadFrom(Path path) {
        try {
            BookFile bookFile = BookFile.readFile(path);
            this.field_17116.clear();
            this.field_17116.addAll(bookFile.pages());
            this.field_2840 = 0;
            this.method_71537();
            this.method_71538();
            this.scribble$dirty = true;
        }
        catch (Exception e) {
            Scribble.LOGGER.error("could not load book from file", (Throwable)e);
        }
    }

    @ModifyArg(method={"init"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/widget/EditBoxWidget;setChangeListener(Ljava/util/function/Consumer;)V"), index=0)
    public Consumer<String> modifyChangeListener(Consumer<String> changeListener) {
        return text -> {
            if (!text.equals(this.field_17116.get(this.field_2840))) {
                this.scribble$dirty = true;
            }
            changeListener.accept((String)text);
        };
    }

    @Unique
    public void scribble$confirmIf(boolean condition, String name, Runnable runnable) {
        if (condition && this.field_22787 != null) {
            this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                this.field_22787.method_1507((class_437)this);
                if (confirmed) {
                    runnable.run();
                }
            }, (class_2561)class_2561.method_43471((String)("text.scribble." + name + ".title")), (class_2561)class_2561.method_43471((String)("text.scribble." + name + ".description"))));
        } else {
            runnable.run();
        }
    }

    public void method_25419() {
        this.scribble$confirmIf(this.scribble$dirty, "quit_without_saving", () -> super.method_25419());
    }

    @ModifyArg(method={"renderBackground"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawTexture(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/util/Identifier;IIFFIIII)V"), index=3)
    public int shiftBackgroundY(int y) {
        return Scribble.getBookScreenYOffset(this.field_22790) + y;
    }

    @WrapOperation(method={"init"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screen/ingame/BookEditScreen;addDrawableChild(Lnet/minecraft/client/gui/Element;)Lnet/minecraft/client/gui/Element;")})
    public <T extends class_364 & class_4068> T shiftButtonY(class_473 instance, class_364 element, Operation<T> original) {
        if (element instanceof class_8021) {
            class_8021 widget = (class_8021)element;
            widget.method_46419(widget.method_46427() + Scribble.getBookScreenYOffset(this.field_22790));
        }
        return (T)((class_364)original.call(new Object[]{instance, element}));
    }

    @ModifyArg(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/DrawContext;drawText(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/Text;IIIZ)V"), index=3)
    public int shiftPageNumberY(int y) {
        return Scribble.getBookScreenYOffset(this.field_22790) + y;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (mouseX < (double)(this.field_22789 - 152) / 2.0 || mouseX > (double)(this.field_22789 + 152) / 2.0) {
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }
}

