/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.book;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Consumer;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.book.BookFile;
import net.minecraft.client.Minecraft;
import net.minecraft.locale.Language;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.Platform;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class FileChooser {
    private FileChooser() {
    }

    public static void chooseBook(boolean save, Consumer<Path> pathConsumer) {
        new Thread(() -> {
            try (MemoryStack stack = MemoryStack.stackPush();){
                String path;
                PointerBuffer filter = null;
                String defaultPath = String.valueOf(FileChooser.createAndGetBookDirectory().toAbsolutePath()) + File.separator;
                if (save) {
                    filter = stack.mallocPointer(1);
                    filter.put(stack.UTF8((CharSequence)"*.json"));
                    filter.flip();
                    path = TinyFileDialogs.tinyfd_saveFileDialog((CharSequence)Language.getInstance().getOrDefault("text.scribble.action.save_book_to_file"), (CharSequence)defaultPath, (PointerBuffer)filter, (CharSequence)"Scribble Book (.json)");
                } else {
                    if (Platform.get() != Platform.MACOSX) {
                        filter = stack.mallocPointer(2);
                        filter.put(stack.UTF8((CharSequence)"*.book"));
                        filter.put(stack.UTF8((CharSequence)"*.json"));
                        filter.flip();
                    }
                    path = TinyFileDialogs.tinyfd_openFileDialog((CharSequence)Language.getInstance().getOrDefault("text.scribble.action.load_book_from_file"), (CharSequence)defaultPath, (PointerBuffer)filter, (CharSequence)"Scribble Book (.book, .json)", (boolean)false);
                }
                if (path == null) {
                    return;
                }
                try {
                    Path p = Path.of(path, new String[0]);
                    Minecraft.getInstance().execute(() -> pathConsumer.accept(p));
                }
                catch (InvalidPathException e) {
                    Scribble.LOGGER.error("failed to choose path", (Throwable)e);
                }
            }
        }, "File chooser").start();
    }

    private static Path createAndGetBookDirectory() {
        try {
            if (!Files.exists(Scribble.BOOK_DIR, new LinkOption[0])) {
                Files.createDirectory(Scribble.BOOK_DIR, new FileAttribute[0]);
            }
        }
        catch (Exception ignored) {
            Scribble.LOGGER.warn("couldn't create the default book directory");
        }
        return Scribble.BOOK_DIR;
    }

    public static void convertLegacyBooks() throws IOException {
        final Path rootDir = Scribble.BOOK_DIR;
        final Path legacyDir = rootDir.resolve("_legacy");
        if (!rootDir.toFile().isDirectory()) {
            return;
        }
        Files.walkFileTree(rootDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            @NotNull
            public FileVisitResult preVisitDirectory(Path dir, @NotNull BasicFileAttributes attrs) {
                if (dir.getFileName().toString().equals("_legacy")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            @NotNull
            public FileVisitResult visitFile(Path file, @NotNull BasicFileAttributes attrs) {
                if (file.toString().endsWith(".book")) {
                    Scribble.LOGGER.info("converting legacy NBT-based book file at {} to JSON.", (Object)file);
                    Path relativePath = rootDir.relativize(file);
                    Path legacyPath = legacyDir.resolve(relativePath);
                    String fileName = file.getFileName().toString();
                    fileName = fileName.substring(0, fileName.length() - 5);
                    Path jsonPath = file.resolveSibling(fileName + ".json");
                    try {
                        BookFile book = BookFile.readFile(file);
                        book.writeJson(jsonPath);
                        Files.createDirectories(legacyPath.getParent(), new FileAttribute[0]);
                        Files.move(file, legacyPath, new CopyOption[0]);
                    }
                    catch (Exception e) {
                        Scribble.LOGGER.error("failed to convert legacy NBT-based book file at {} to JSON.", (Object)file, (Object)e);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

