/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.gui.button;

import me.chrr.scribble.Scribble;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class IconButtonWidget
extends AbstractButton {
    private static final ResourceLocation WIDGETS_TEXTURE = Scribble.id("textures/gui/scribble_widgets.png");
    private final Runnable onPress;
    private final int u;
    private final int v;

    public IconButtonWidget(Component tooltip, Runnable onPress, int x, int y, int u, int v, int width, int height) {
        super(x, y, width, height, tooltip);
        this.setTooltip(Tooltip.create((Component)tooltip));
        this.onPress = onPress;
        this.u = u;
        this.v = v;
    }

    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int v = this.v + (!this.active ? 2 : (this.isHoveredOrFocused() ? 1 : 0)) * this.height;
        context.blit(RenderPipelines.GUI_TEXTURED, WIDGETS_TEXTURE, this.getX(), this.getY(), (float)this.u, (float)v, this.width, this.height, 128, 128);
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
        this.defaultButtonNarrationText(builder);
    }

    public void onPress() {
        this.onPress.run();
    }
}

