/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.nio.file.Path;
import java.util.List;
import me.chrr.scribble.Scribble;
import me.chrr.scribble.book.BookFile;
import me.chrr.scribble.book.FileChooser;
import me.chrr.scribble.book.RichText;
import me.chrr.scribble.config.Config;
import me.chrr.scribble.gui.PageNumberWidget;
import me.chrr.scribble.gui.button.IconButtonWidget;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookViewScreen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BookViewScreen.class})
public abstract class BookScreenMixin
extends Screen {
    @Shadow
    private BookViewScreen.BookAccess bookAccess;
    @Shadow
    private int currentPage;
    @Unique
    private PageNumberWidget scribble$pageNumberWidget;

    @Shadow
    public abstract boolean setPage(int var1);

    private BookScreenMixin() {
        super(null);
    }

    @Inject(method={"init()V"}, at={@At(value="TAIL")})
    public void initButtons(CallbackInfo info) {
        if (Scribble.CONFIG_MANAGER.getConfig().showActionButtons == Config.ShowActionButtons.ALWAYS) {
            int x = this.width / 2 - 78 - 7 - 12;
            int y = Scribble.getBookScreenYOffset(this.height) + 12 + 4;
            Runnable saveBook = () -> FileChooser.chooseBook(true, path -> {
                try {
                    List<String> pages = this.bookAccess.pages().stream().map(RichText::fromStringVisitableLossy).map(RichText::getAsFormattedString).toList();
                    BookFile bookFile = new BookFile("<written book>", pages);
                    bookFile.writeJson((Path)path);
                }
                catch (Exception e) {
                    Scribble.LOGGER.error("could not save book to file", (Throwable)e);
                }
            });
            this.addRenderableWidget((GuiEventListener)new IconButtonWidget((Component)Component.translatable((String)"text.scribble.action.save_book_to_file"), saveBook, x, y, 48, 90, 12, 12));
        }
    }

    @Inject(method={"init()V"}, at={@At(value="HEAD")})
    public void initPageNumberWidget(CallbackInfo ci) {
        int x = (this.width - 192) / 2;
        int y = Scribble.getBookScreenYOffset(this.height);
        this.scribble$pageNumberWidget = (PageNumberWidget)this.addRenderableWidget((GuiEventListener)new PageNumberWidget(page -> this.setPage(page - 1), x + 192 - 44, y + 18, this.font));
    }

    @Inject(method={"updateButtonVisibility()V"}, at={@At(value="HEAD")})
    public void updatePageNumber(CallbackInfo ci) {
        this.scribble$pageNumberWidget.setPageNumber(this.currentPage + 1, this.bookAccess.getPageCount());
    }

    @Redirect(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIZ)V"))
    public void drawIndicatorText(GuiGraphics instance, Font textRenderer, Component text, int x, int y, int color, boolean shadow) {
    }

    @ModifyArg(method={"renderBackground(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blit(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIFFIIII)V"), index=3)
    public int shiftBackgroundY(int y) {
        return Scribble.getBookScreenYOffset(this.height) + y;
    }

    @WrapOperation(method={"createMenuControls()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/BookViewScreen;addRenderableWidget(Lnet/minecraft/client/gui/components/events/GuiEventListener;)Lnet/minecraft/client/gui/components/events/GuiEventListener;")})
    public <T extends GuiEventListener & Renderable> T shiftCloseButtonY(BookViewScreen instance, GuiEventListener element, Operation<T> original) {
        if (element instanceof LayoutElement) {
            LayoutElement widget = (LayoutElement)element;
            widget.setY(widget.getY() + Scribble.getBookScreenYOffset(this.height));
        }
        return (T)((GuiEventListener)original.call(new Object[]{instance, element}));
    }

    @WrapOperation(method={"createPageControlButtons()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/BookViewScreen;addRenderableWidget(Lnet/minecraft/client/gui/components/events/GuiEventListener;)Lnet/minecraft/client/gui/components/events/GuiEventListener;")})
    public <T extends GuiEventListener & Renderable> T shiftPageButtonY(BookViewScreen instance, GuiEventListener element, Operation<T> original) {
        if (element instanceof LayoutElement) {
            LayoutElement widget = (LayoutElement)element;
            widget.setY(widget.getY() + Scribble.getBookScreenYOffset(this.height));
        }
        return (T)((GuiEventListener)original.call(new Object[]{instance, element}));
    }

    @ModifyVariable(method={"getClickedComponentStyleAt(DD)Lnet/minecraft/network/chat/Style;"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    public double shiftTextStyleY(double y) {
        return y - (double)Scribble.getBookScreenYOffset(this.height);
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/Screen;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", shift=At.Shift.AFTER)})
    public void translateRender(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        context.pose().pushMatrix();
        context.pose().translate(0.0f, (float)Scribble.getBookScreenYOffset(this.height));
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="RETURN")})
    public void popRender(GuiGraphics context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        context.pose().popMatrix();
    }
}

