/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.book;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;

public record BookFile(String author, Collection<String> pages) {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static BookFile readFile(Path path) throws IOException {
        if (path.toString().endsWith(".book")) {
            return BookFile.readNbt(path);
        }
        if (path.toString().endsWith(".json")) {
            return BookFile.readJson(path);
        }
        throw new IOException("unrecognized file format");
    }

    public void writeJson(Path path) throws IOException {
        String json = GSON.toJson((Object)this);
        Files.write(path, json.getBytes(), new OpenOption[0]);
    }

    private static BookFile readJson(Path path) throws IOException {
        return (BookFile)GSON.fromJson((Reader)Files.newBufferedReader(path), BookFile.class);
    }

    private static BookFile readNbt(Path path) throws IOException {
        CompoundTag root = NbtIo.read((Path)path);
        if (root == null) {
            throw new IOException("could not read book nbt file");
        }
        String author = root.getString("author").orElse("<unknown>");
        List<String> pages = root.getList("pages").orElse(new ListTag()).stream().map(Tag::asString).map(Optional::orElseThrow).toList();
        return new BookFile(author, pages);
    }
}

