/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.gui.button;

import java.util.function.Consumer;
import me.chrr.scribble.Scribble;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ModifierButtonWidget
extends AbstractButton {
    private static final ResourceLocation WIDGETS_TEXTURE = Scribble.id("textures/gui/scribble_widgets.png");
    private final int u;
    private final int v;
    public boolean toggled;
    private final Consumer<Boolean> onToggle;

    public ModifierButtonWidget(Component tooltip, Consumer<Boolean> onToggle, int x, int y, int u, int v, int width, int height, boolean toggled) {
        super(x, y, width, height, tooltip);
        this.setTooltip(Tooltip.create((Component)tooltip));
        this.u = u;
        this.v = v;
        this.toggled = toggled;
        this.onToggle = onToggle;
    }

    protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.isHoveredOrFocused()) {
            // empty if block
        }
        int u = this.u + (this.isHoveredOrFocused() ? 22 : 0) + (this.toggled ? 44 : 0);
        context.blit(RenderPipelines.GUI_TEXTURED, WIDGETS_TEXTURE, this.getX(), this.getY(), (float)u, (float)this.v, this.width, this.height + 1, 128, 128);
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
        this.defaultButtonNarrationText(builder);
    }

    public void onPress() {
        this.toggled = !this.toggled;
        this.onToggle.accept(this.toggled);
    }
}

