/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.scribble.gui.edit;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import me.chrr.scribble.book.RichText;
import me.chrr.scribble.gui.edit.RichEditBox;
import me.chrr.scribble.history.command.EditCommand;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3544;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_7529;
import net.minecraft.class_7530;
import org.jetbrains.annotations.Nullable;

public class RichEditBoxWidget
extends class_7529 {
    @Nullable
    private final Runnable onInvalidateFormat;
    @Nullable
    private final Consumer<EditCommand> onHistoryPush;
    @Nullable
    public class_124 color = class_124.field_1074;
    public Set<class_124> modifiers = new HashSet<class_124>();

    private RichEditBoxWidget(class_327 textRenderer, int x, int y, int width, int height, class_2561 placeholder, class_2561 message, int textColor, boolean textShadow, int cursorColor, boolean hasBackground, boolean hasOverlay, @Nullable Runnable onInvalidateFormat, @Nullable Consumer<EditCommand> onHistoryPush) {
        super(textRenderer, x, y, width, height, placeholder, message, textColor, textShadow, cursorColor, hasBackground, hasOverlay);
        this.onInvalidateFormat = onInvalidateFormat;
        this.onHistoryPush = onHistoryPush;
        this.field_39509 = new RichEditBox(textRenderer, width - this.method_65512(), () -> new class_3545((Object)Optional.ofNullable(this.color).orElse(class_124.field_1074), this.modifiers), (color, modifiers) -> {
            this.color = color;
            this.modifiers = new HashSet<class_124>((Collection<class_124>)modifiers);
            this.notifyInvalidateFormat();
        });
    }

    private void notifyInvalidateFormat() {
        if (this.onInvalidateFormat != null) {
            this.onInvalidateFormat.run();
        }
    }

    private void pushHistory(EditCommand command) {
        if (this.onHistoryPush != null) {
            this.onHistoryPush.accept(command);
        }
    }

    public void applyFormatting(class_124 formatting, boolean active) {
        RichEditBox editBox = this.getRichEditBox();
        if (editBox.method_44435()) {
            EditCommand command = new EditCommand(editBox, box -> box.applyFormatting(formatting, active));
            command.executeEdit(editBox);
            this.pushHistory(command);
        } else {
            if (formatting.method_542()) {
                if (active) {
                    this.modifiers.add(formatting);
                } else {
                    this.modifiers.remove(formatting);
                }
            } else {
                this.color = formatting;
            }
            this.notifyInvalidateFormat();
        }
    }

    private int getCursorColor() {
        if (this.color == null) {
            return -16777216;
        }
        return 0xFF000000 | this.color.method_532();
    }

    protected void method_44389(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        RichText text = this.getRichEditBox().getRichText();
        if (text.isEmpty() && !this.method_25370()) {
            context.method_65179(this.field_39507, (class_5348)this.field_39508, this.method_65513(), this.method_65514(), this.field_22758 - this.method_65512(), -857677600);
            return;
        }
        int cursor = this.field_39509.method_44424();
        boolean blink = this.method_25370() && (class_156.method_658() - this.field_45364) / 300L % 2L == 0L;
        boolean cursorInText = cursor < text.getLength();
        int lastX = 0;
        int lastY = 0;
        int y = this.method_65514();
        boolean hasDrawnCursor = false;
        for (class_7530.class_7531 line : this.field_39509.method_44434()) {
            Objects.requireNonNull(this.field_39507);
            boolean visible = this.method_65510(y, y + 9);
            int x = this.method_65513();
            if (blink && cursorInText && cursor >= line.comp_862() && cursor <= line.comp_863()) {
                if (visible) {
                    lineText = text.subText(line.comp_862(), line.comp_863());
                    context.method_51439(this.field_39507, (class_2561)lineText.getAsMutableText(), x, y, this.field_60439, this.field_60440);
                    RichText beforeCursor = text.subText(line.comp_862(), cursor);
                    lastX = x + this.field_39507.method_27525((class_5348)beforeCursor);
                    if (!hasDrawnCursor) {
                        Objects.requireNonNull(this.field_39507);
                        context.method_25294(lastX, y - 1, lastX + 1, y + 1 + 9, this.getCursorColor());
                        hasDrawnCursor = true;
                    }
                }
            } else {
                if (visible) {
                    lineText = text.subText(line.comp_862(), line.comp_863());
                    context.method_51439(this.field_39507, (class_2561)lineText.getAsMutableText(), x, y, this.field_60439, this.field_60440);
                    lastX = x + this.field_39507.method_27525((class_5348)lineText) - 1;
                }
                lastY = y;
            }
            Objects.requireNonNull(this.field_39507);
            y += 9;
        }
        if (blink && !cursorInText) {
            Objects.requireNonNull(this.field_39507);
            if (this.method_65510(lastY, lastY + 9)) {
                context.method_51433(this.field_39507, "_", lastX + 1, lastY, this.getCursorColor(), this.field_60440);
            }
        }
        if (this.field_39509.method_44435()) {
            class_7530.class_7531 selection = this.field_39509.method_44427();
            int x = this.method_65513();
            y = this.method_65514();
            for (class_7530.class_7531 line : this.field_39509.method_44434()) {
                if (selection.comp_862() <= line.comp_863()) {
                    if (line.comp_862() > selection.comp_863()) break;
                    Objects.requireNonNull(this.field_39507);
                    if (this.method_65510(y, y + 9)) {
                        int start = this.field_39507.method_27525((class_5348)text.subText(line.comp_862(), Math.max(selection.comp_862(), line.comp_862())));
                        int end = selection.comp_863() > line.comp_863() ? this.field_22758 - this.method_65509() : this.field_39507.method_27525((class_5348)text.subText(line.comp_862(), selection.comp_863()));
                        Objects.requireNonNull(this.field_39507);
                        this.method_44403(context, x + start, y, x + end, y + 9);
                    }
                }
                Objects.requireNonNull(this.field_39507);
                y += 9;
            }
        }
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.field_22764 && this.method_25370() && class_3544.method_57175((char)chr)) {
            EditCommand command = new EditCommand(this.getRichEditBox(), editBox -> editBox.method_44420(Character.toString(chr)));
            command.executeEdit(this.getRichEditBox());
            this.pushHistory(command);
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (class_437.method_25441() && !class_437.method_25442() && !class_437.method_25443()) {
            class_124 modifier;
            switch (keyCode) {
                case 66: {
                    class_124 class_1242 = class_124.field_1067;
                    break;
                }
                case 73: {
                    class_124 class_1242 = class_124.field_1056;
                    break;
                }
                case 85: {
                    class_124 class_1242 = class_124.field_1073;
                    break;
                }
                case 45: {
                    class_124 class_1242 = class_124.field_1055;
                    break;
                }
                case 75: {
                    class_124 class_1242 = class_124.field_1051;
                    break;
                }
                default: {
                    class_124 class_1242 = modifier = null;
                }
            }
            if (modifier != null) {
                this.applyFormatting(modifier, !this.modifiers.contains(modifier));
                return true;
            }
        }
        if (class_437.method_25436((int)keyCode) || class_437.method_25437((int)keyCode) || List.of(Integer.valueOf(257), Integer.valueOf(335), Integer.valueOf(259), Integer.valueOf(261)).contains(keyCode)) {
            EditCommand command = new EditCommand(this.getRichEditBox(), editBox -> editBox.method_44428(keyCode));
            command.executeEdit(this.getRichEditBox());
            this.pushHistory(command);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_47399(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43469((String)"gui.narrate.editBox", (Object[])new Object[]{this.method_25369(), this.getRichEditBox().getRichText().getPlainText()}));
    }

    public RichEditBox getRichEditBox() {
        return (RichEditBox)this.field_39509;
    }

    public static class Builder
    extends class_7529.class_11383 {
        @Nullable
        private Runnable onInvalidateFormat = null;
        @Nullable
        private Consumer<EditCommand> onHistoryPush = null;

        public Builder onInvalidateFormat(Runnable onInvalidateFormat) {
            this.onInvalidateFormat = onInvalidateFormat;
            return this;
        }

        public Builder onHistoryPush(Consumer<EditCommand> onHistoryPush) {
            this.onHistoryPush = onHistoryPush;
            return this;
        }

        public class_7529 method_71509(class_327 textRenderer, int width, int height, class_2561 message) {
            return new RichEditBoxWidget(textRenderer, this.field_60442, this.field_60443, width, height, this.field_60444, message, this.field_60445, this.field_60446, this.field_60447, this.field_60448, this.field_60449, this.onInvalidateFormat, this.onHistoryPush);
        }
    }
}

