/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.general;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.templates.PlateBlock;
import org.dawnoftime.dawnoftime.util.Utils;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class IronFenceBlock
extends PlateBlock {
    private static final BooleanProperty UP = BlockStateProperties.f_61366_;

    public IronFenceBlock(BlockBehaviour.Properties properties) {
        super(properties, VoxelShapes.IRON_FENCE_SHAPES);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)PlateBlock.FACING, (Comparable)Direction.NORTH)).m_61124_(PlateBlock.SHAPE, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)UP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = (((Direction)state.m_61143_((Property)FACING)).m_122416_() + 2) % 4;
        index *= 3;
        switch ((StairsShape)state.m_61143_((Property)SHAPE)) {
            case OUTER_RIGHT: {
                index += 3;
                break;
            }
            case STRAIGHT: {
                ++index;
                break;
            }
            case INNER_LEFT: {
                index += 2;
                break;
            }
            case INNER_RIGHT: {
                index += 5;
                break;
            }
        }
        return (Boolean)state.m_61143_((Property)UP) != false ? index + 12 : (index %= 12);
    }

    @Override
    public void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{UP});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)super.m_5573_(context).m_61124_((Property)UP, (Comparable)Boolean.valueOf(!context.m_43725_().m_8055_(context.m_8083_().m_7494_()).m_60713_((Block)this)));
    }

    @Override
    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (facing == Direction.UP) {
            stateIn = (BlockState)stateIn.m_61124_((Property)UP, (Comparable)Boolean.valueOf(!facingState.m_60713_((Block)this)));
        }
        return super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        BlockPos topPos;
        ItemStack heldItemStack = player.m_21120_(handIn);
        if (player.m_6047_()) {
            if (((Boolean)state.m_61143_((Property)UP)).booleanValue()) {
                return super.m_6227_(state, worldIn, pos, player, handIn, hit);
            }
            BlockPos topPos2 = this.getHighestColumnPos(worldIn, pos);
            if (topPos2 != pos) {
                if (!worldIn.m_5776_()) {
                    worldIn.m_7731_(topPos2, Blocks.f_50016_.m_49966_(), 35);
                    if (!player.m_7500_()) {
                        Block.m_49881_((BlockState)state, (Level)worldIn, (BlockPos)pos, null, (Entity)player, (ItemStack)heldItemStack);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        } else if (!heldItemStack.m_41619_() && heldItemStack.m_41720_() == this.m_5456_() && (topPos = this.getHighestColumnPos(worldIn, pos).m_7494_()).m_123342_() <= 255) {
            if (!worldIn.m_5776_() && worldIn.m_8055_(topPos).m_60795_()) {
                worldIn.m_7731_(topPos, state, 11);
                if (!player.m_7500_()) {
                    heldItemStack.m_41774_(1);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    private BlockPos getHighestColumnPos(Level worldIn, BlockPos pos) {
        int yOffset = 0;
        while (yOffset + pos.m_123342_() <= 255 && worldIn.m_8055_(pos.m_6630_(yOffset)).m_60734_() == this) {
            ++yOffset;
        }
        return pos.m_6630_(yOffset - 1);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, "column");
    }
}

