/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.japanese;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.dawnoftime.dawnoftime.block.japanese.TatamiFloorBlock;
import org.dawnoftime.dawnoftime.block.templates.WaterloggedBlock;
import org.dawnoftime.dawnoftime.registry.DoTBBlocksRegistry;
import org.dawnoftime.dawnoftime.registry.DoTBTags;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class TatamiMatBlock
extends WaterloggedBlock {
    public static final EnumProperty<Half> HALF = BlockStateProperties.f_61402_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty ROLLED = BlockStatePropertiesAA.ROLLED;
    public static final IntegerProperty STACK = BlockStatePropertiesAA.STACK;

    public TatamiMatBlock(BlockBehaviour.Properties properties) {
        super(properties.m_278166_(PushReaction.DESTROY), VoxelShapes.TATAMI_MAT_SHAPES);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ROLLED, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)Half.TOP)).m_61124_((Property)STACK, (Comparable)Integer.valueOf(1)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING, HALF, ROLLED, STACK});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Boolean)state.m_61143_((Property)ROLLED) != false ? (Integer)state.m_61143_((Property)STACK) - 1 + ((Direction)state.m_61143_((Property)FACING)).m_122416_() * 3 : 12;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction;
        BlockPos pos;
        Level world = context.m_43725_();
        BlockState oldState = world.m_8055_(pos = context.m_8083_());
        if (oldState.m_60734_() == this) {
            int stack = (Integer)oldState.m_61143_((Property)STACK);
            if (((Boolean)oldState.m_61143_((Property)ROLLED)).booleanValue() && stack < 3) {
                return (BlockState)oldState.m_61124_((Property)STACK, (Comparable)Integer.valueOf(stack + 1));
            }
        }
        if (world.m_8055_(pos.m_121945_(direction = context.m_8125_())).m_60629_(context)) {
            return (BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)ROLLED, (Comparable)Boolean.valueOf(world.m_8055_(pos.m_7495_()).m_204336_(DoTBTags.INSTANCE.COVERED_BLOCKS) || world.m_8055_(pos.m_7495_().m_121945_(direction)).m_204336_(DoTBTags.INSTANCE.COVERED_BLOCKS)))).m_61124_((Property)FACING, (Comparable)direction);
        }
        return null;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        if (state.m_61143_(HALF) == Half.BOTTOM) {
            BlockState topState = worldIn.m_8055_(pos.m_121945_(((Direction)state.m_61143_((Property)FACING)).m_122424_()));
            if (topState.m_60734_() == this && topState.m_61143_(HALF) == Half.TOP && topState.m_61143_((Property)FACING) == state.m_61143_((Property)FACING)) {
                return !worldIn.m_46859_(pos.m_7495_());
            }
        } else {
            return !worldIn.m_46859_(pos.m_7495_());
        }
        return false;
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockState newState = this.tryMergingWithSprucePlanks(state, (LevelAccessor)worldIn, pos);
        if (newState.m_60734_() == Blocks.f_50016_) {
            worldIn.m_7731_(pos, newState, 10);
        } else if (!((Boolean)newState.m_61143_((Property)ROLLED)).booleanValue()) {
            worldIn.m_7731_(pos.m_121945_((Direction)newState.m_61143_((Property)FACING)), (BlockState)newState.m_61124_(HALF, (Comparable)Half.BOTTOM), 3);
        }
    }

    @Override
    @NotNull
    public BlockState m_7417_(BlockState stateIn, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor worldIn, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        stateIn = super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (facing.m_122434_().m_122478_()) {
            return !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : this.tryMergingWithSprucePlanks(stateIn, worldIn, currentPos);
        }
        boolean mustDisappear = false;
        if (((Boolean)stateIn.m_61143_((Property)ROLLED)).booleanValue()) {
            return stateIn;
        }
        Direction direction = (Direction)stateIn.m_61143_((Property)FACING);
        if (stateIn.m_61143_(HALF) == Half.TOP) {
            if (direction == facing) {
                if (facingState.m_60734_() == this) {
                    if (facingState.m_61143_((Property)FACING) != facing || facingState.m_61143_(HALF) != Half.BOTTOM || ((Boolean)facingState.m_61143_((Property)ROLLED)).booleanValue()) {
                        mustDisappear = true;
                    }
                } else {
                    mustDisappear = true;
                }
            }
        } else if (direction == facing.m_122424_()) {
            if (facingState.m_60734_() == this) {
                if (facingState.m_61143_((Property)FACING) != direction || facingState.m_61143_(HALF) != Half.TOP || ((Boolean)facingState.m_61143_((Property)ROLLED)).booleanValue()) {
                    mustDisappear = true;
                }
            } else {
                mustDisappear = true;
            }
        }
        if (mustDisappear) {
            stateIn = Blocks.f_50016_.m_49966_();
            worldIn.m_7731_(currentPos, stateIn, 2);
        }
        return stateIn;
    }

    private BlockState tryMergingWithSprucePlanks(BlockState state, LevelAccessor worldIn, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)ROLLED)).booleanValue()) {
            return state;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        Block blockDown = worldIn.m_8055_(pos.m_7495_()).m_60734_();
        Block blockDownAdjacent = worldIn.m_8055_(pos.m_121945_(facing).m_7495_()).m_60734_();
        if (blockDown == Blocks.f_50741_ && blockDownAdjacent == Blocks.f_50741_) {
            worldIn.m_7731_(pos.m_7495_(), (BlockState)((BlockState)DoTBBlocksRegistry.INSTANCE.TATAMI_FLOOR.get().m_49966_().m_61124_((Property)TatamiFloorBlock.FACING, (Comparable)facing)).m_61124_(TatamiFloorBlock.HALF, (Comparable)((Half)state.m_61143_(HALF))), 10);
            worldIn.m_7731_(pos.m_121945_(facing).m_7495_(), (BlockState)((BlockState)DoTBBlocksRegistry.INSTANCE.TATAMI_FLOOR.get().m_49966_().m_61124_((Property)TatamiFloorBlock.FACING, (Comparable)facing)).m_61124_(TatamiFloorBlock.HALF, (Comparable)(state.m_61143_(HALF) == Half.TOP ? Half.BOTTOM : Half.TOP)), 10);
            return Blocks.f_50016_.m_49966_();
        }
        return state;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_6047_()) {
            int stack = (Integer)state.m_61143_((Property)STACK);
            boolean isRolled = (Boolean)state.m_61143_((Property)ROLLED);
            if (isRolled && stack == 1 && worldIn.m_8055_(pos.m_7495_()).m_204336_(DoTBTags.INSTANCE.COVERED_BLOCKS)) {
                return InteractionResult.PASS;
            }
            if ((Integer)state.m_61143_((Property)STACK) > 1) {
                state = (BlockState)state.m_61124_((Property)STACK, (Comparable)Integer.valueOf(stack - 1));
                Containers.m_18992_((Level)worldIn, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)new ItemStack((ItemLike)this.m_5456_()));
            } else {
                state = (BlockState)state.m_61124_((Property)ROLLED, (Comparable)Boolean.valueOf(!isRolled));
                Direction facing = (Direction)state.m_61143_((Property)FACING);
                if (isRolled) {
                    if (!worldIn.m_46859_(pos.m_121945_(facing)) || worldIn.m_46859_(pos.m_121945_(facing).m_7495_()) || worldIn.m_8055_(pos.m_7495_().m_121945_(facing)).m_204336_(DoTBTags.INSTANCE.COVERED_BLOCKS)) {
                        return InteractionResult.PASS;
                    }
                    worldIn.m_7731_(pos.m_121945_(facing), (BlockState)state.m_61124_(HALF, (Comparable)Half.BOTTOM), 2);
                } else if (state.m_61143_(HALF) == Half.BOTTOM) {
                    state = (BlockState)((BlockState)state.m_61124_(HALF, (Comparable)Half.TOP)).m_61124_((Property)FACING, (Comparable)facing.m_122424_());
                }
            }
            state = this.m_7417_(state, Direction.DOWN, worldIn.m_8055_(pos.m_7495_()), (LevelAccessor)worldIn, pos, pos.m_7495_());
            worldIn.m_7731_(pos, state, 2);
            worldIn.m_5594_(player, pos, this.f_60446_.m_56777_(), SoundSource.BLOCKS, (this.f_60446_.m_56773_() + 1.0f) / 2.0f, this.f_60446_.m_56774_() * 0.8f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext useContext) {
        ItemStack itemstack = useContext.m_43722_();
        if (itemstack.m_41720_() == this.m_5456_()) {
            if (!((Boolean)state.m_61143_((Property)ROLLED)).booleanValue() || (Integer)state.m_61143_((Property)STACK) == 3) {
                return false;
            }
            return useContext.m_7058_();
        }
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)).m_122424_())).m_61124_(HALF, (Comparable)(state.m_61143_(HALF) == Half.TOP ? Half.BOTTOM : Half.TOP));
            }
            case FRONT_BACK: {
                return (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)).m_122424_());
            }
        }
        return super.m_6943_(state, mirrorIn);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, this, new String[0]);
    }
}

