/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.EmptyFluid;
import net.minecraft.world.level.material.WaterFluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.general.WaterTrickleBlock;
import org.dawnoftime.dawnoftime.block.templates.BlockDoT;
import org.dawnoftime.dawnoftime.block.templates.FaucetBlock;
import org.dawnoftime.dawnoftime.mixin.impl.BucketItemAccessor;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.Utils;
import org.jetbrains.annotations.NotNull;

public class PoolBlock
extends BlockDoT {
    public final int maxLevel;
    public final int faucetLevel;

    public PoolBlock(BlockBehaviour.Properties propertiesIn, int maxLevelIn, int faucetLevelIn, VoxelShape[] shapes) {
        super(propertiesIn.m_60953_(state -> 1), shapes);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStatePropertiesAA.HAS_PILLAR, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(0)));
        this.maxLevel = maxLevelIn;
        this.faucetLevel = faucetLevelIn;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61368_}).m_61104_(new Property[]{BlockStateProperties.f_61369_}).m_61104_(new Property[]{BlockStateProperties.f_61370_}).m_61104_(new Property[]{BlockStateProperties.f_61371_}).m_61104_(new Property[]{BlockStatePropertiesAA.HAS_PILLAR}).m_61104_(new Property[]{BlockStatePropertiesAA.LEVEL});
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = 0;
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_)).booleanValue()) {
            ++index;
        }
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_)).booleanValue()) {
            index += 2;
        }
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_)).booleanValue()) {
            index += 4;
        }
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_)).booleanValue()) {
            index += 8;
        }
        if (((Boolean)state.m_61143_((Property)BlockStatePropertiesAA.HAS_PILLAR)).booleanValue()) {
            index += 16;
        }
        return index;
    }

    public BlockState m_5573_(BlockPlaceContext contextIn) {
        PoolLevelAndSides levelAndSides = PoolBlock.levelOfPoolAround(contextIn.m_8083_(), (LevelAccessor)contextIn.m_43725_());
        BlockState state = (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(levelAndSides.south))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(levelAndSides.north))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(levelAndSides.right))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(levelAndSides.left));
        int level = levelAndSides.level;
        if (level <= 0 && EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAround(contextIn.m_8083_(), (LevelAccessor)contextIn.m_43725_()))) {
            level = 1;
            if (!contextIn.m_43725_().m_5776_()) {
                contextIn.m_43725_().m_186460_(contextIn.m_8083_(), (Block)this, 5);
            }
        }
        state = (BlockState)state.m_61124_((Property)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(level));
        return state;
    }

    public InteractionResult m_6227_(BlockState blockStateIn, Level worldIn, BlockPos blockPosIn, Player playerEntityIn, InteractionHand handIn, BlockHitResult blockRayTraceResultIn) {
        ItemStack itemStack = playerEntityIn.m_21205_();
        if (!playerEntityIn.m_6047_()) {
            int lastLevel;
            int nextLevel = lastLevel = ((Integer)blockStateIn.m_61143_((Property)BlockStatePropertiesAA.LEVEL)).intValue();
            boolean tryToChangeLevel = false;
            ItemStack newItemStack = null;
            if (itemStack.m_41720_() instanceof BucketItem) {
                if (((BucketItemAccessor)itemStack.m_41720_()).getContent() instanceof WaterFluid) {
                    nextLevel = this.maxLevel;
                    if (!playerEntityIn.m_7500_()) {
                        newItemStack = new ItemStack((ItemLike)Items.f_42446_);
                    }
                } else if (((BucketItemAccessor)itemStack.m_41720_()).getContent() instanceof EmptyFluid) {
                    nextLevel = 0;
                    if (!playerEntityIn.m_7500_()) {
                        newItemStack = new ItemStack((ItemLike)Items.f_42447_);
                    }
                }
                tryToChangeLevel = true;
            } else if (itemStack.m_41720_() instanceof PotionItem) {
                Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
                if (potion.m_43488_().isEmpty() && nextLevel + 1 < this.maxLevel) {
                    ++nextLevel;
                    if (!playerEntityIn.m_7500_()) {
                        newItemStack = new ItemStack((ItemLike)Items.f_42590_);
                    }
                }
                tryToChangeLevel = true;
            } else if (itemStack.m_41720_() instanceof BottleItem) {
                Potion potion = PotionUtils.m_43579_((ItemStack)itemStack);
                if (potion.m_43488_().isEmpty() && nextLevel - 1 >= 0) {
                    --nextLevel;
                    if (!playerEntityIn.m_7500_()) {
                        newItemStack = Items.f_42589_.m_7968_();
                    }
                }
                tryToChangeLevel = true;
            }
            if (tryToChangeLevel) {
                if (nextLevel == lastLevel) {
                    return InteractionResult.CONSUME;
                }
                if (newItemStack != null) {
                    itemStack.m_41774_(1);
                    playerEntityIn.m_150109_().m_36054_(newItemStack);
                }
                blockStateIn = (BlockState)blockStateIn.m_61124_((Property)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(nextLevel));
                worldIn.m_7731_(blockPosIn, blockStateIn, 10);
                if (nextLevel == 0) {
                    PoolBlock.removeWaterAround(blockStateIn, blockPosIn, worldIn);
                }
                return InteractionResult.SUCCESS;
            }
        } else if (itemStack.m_41619_()) {
            blockStateIn = (BlockState)blockStateIn.m_61124_((Property)BlockStatePropertiesAA.HAS_PILLAR, (Comparable)Boolean.valueOf((Boolean)blockStateIn.m_61143_((Property)BlockStatePropertiesAA.HAS_PILLAR) == false));
            worldIn.m_7731_(blockPosIn, blockStateIn, 10);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level worldIn, BlockPos blockPosIn, BlockState blockStateIn, LivingEntity entityIn, ItemStack itemStackIn) {
        if (entityIn instanceof Player && !entityIn.m_6144_()) {
            super.m_6402_(worldIn, blockPosIn, blockStateIn, entityIn, itemStackIn);
            BlockPos blockPos = blockPosIn.m_7495_();
            BlockState blockState = worldIn.m_8055_(blockPos);
            if (blockState.m_60734_() == this) {
                blockState = (BlockState)blockState.m_61124_((Property)BlockStatePropertiesAA.HAS_PILLAR, (Comparable)Boolean.valueOf(true));
                worldIn.m_7731_(blockPos, blockState, 10);
            }
        }
    }

    public void m_213897_(BlockState blockStateIn, ServerLevel serverWorldIn, BlockPos blockPosIn, RandomSource randomIn) {
        super.m_213897_(blockStateIn, serverWorldIn, blockPosIn, randomIn);
        boolean increase = EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAround(blockPosIn, (LevelAccessor)serverWorldIn));
        if (increase) {
            int level = (Integer)blockStateIn.m_61143_((Property)BlockStatePropertiesAA.LEVEL);
            if (level < this.maxLevel) {
                blockStateIn = (BlockState)blockStateIn.m_61124_((Property)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(level + 1));
                serverWorldIn.m_7731_(blockPosIn, blockStateIn, 10);
                if (level + 1 < this.maxLevel) {
                    serverWorldIn.m_186460_(blockPosIn, (Block)this, 5);
                }
            }
        } else {
            int level = (Integer)blockStateIn.m_61143_((Property)BlockStatePropertiesAA.LEVEL);
            if (level - 1 >= 0) {
                blockStateIn = (BlockState)blockStateIn.m_61124_((Property)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(--level));
                serverWorldIn.m_7731_(blockPosIn, blockStateIn, 10);
                if (level - 1 >= 0) {
                    serverWorldIn.m_186460_(blockPosIn, (Block)this, 5);
                }
            }
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction directionIn, BlockState facingStateIn, LevelAccessor worldIn, BlockPos currentPosIn, BlockPos facingPosIn) {
        if (directionIn.m_122434_().m_122479_()) {
            boolean hasPoolInSide;
            boolean bl = hasPoolInSide = facingStateIn.m_60734_() == this;
            if (hasPoolInSide && (Integer)facingStateIn.m_61143_((Property)BlockStatePropertiesAA.LEVEL) >= 0) {
                stateIn = (BlockState)stateIn.m_61124_((Property)BlockStatePropertiesAA.LEVEL, (Comparable)((Integer)facingStateIn.m_61143_((Property)BlockStatePropertiesAA.LEVEL)));
            }
            switch (directionIn) {
                case NORTH: {
                    stateIn = (BlockState)stateIn.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)Boolean.valueOf(hasPoolInSide));
                    break;
                }
                case EAST: {
                    stateIn = (BlockState)stateIn.m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)Boolean.valueOf(hasPoolInSide));
                    break;
                }
                case SOUTH: {
                    stateIn = (BlockState)stateIn.m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)Boolean.valueOf(hasPoolInSide));
                    break;
                }
                case WEST: {
                    stateIn = (BlockState)stateIn.m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)Boolean.valueOf(hasPoolInSide));
                    break;
                }
            }
        }
        int level = (Integer)stateIn.m_61143_((Property)BlockStatePropertiesAA.LEVEL);
        if (facingPosIn.m_123342_() == currentPosIn.m_123342_() + 1) {
            int lastLevel = level;
            EnumActivatorState state = PoolBlock.hasOnePoolActivatorAround(currentPosIn, worldIn);
            if (EnumActivatorState.ENABLED.equals((Object)state)) {
                if (level < this.maxLevel) {
                    ++level;
                }
            } else if (EnumActivatorState.DISABLED.equals((Object)state) && level - 1 >= 0) {
                --level;
            }
            stateIn = (BlockState)stateIn.m_61124_((Property)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(level));
            if (!worldIn.m_5776_() && lastLevel != level) {
                worldIn.m_186460_(currentPosIn, (Block)this, 5);
            }
        }
        return stateIn;
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        Utils.addTooltip(tooltip, "add_column");
    }

    public int m_7753_(BlockState p_200011_1_In, BlockGetter p_200011_2_In, BlockPos p_200011_3_In) {
        return 1;
    }

    public boolean m_7923_(BlockState p_220074_1_In) {
        return false;
    }

    public boolean m_7420_(BlockState p_200123_1_In, BlockGetter p_200123_2_In, BlockPos p_200123_3_In) {
        return true;
    }

    public static boolean removeWaterAround(BlockState blockStateIn, BlockPos blockPosIn, Level worldIn) {
        return PoolBlock.removeWaterAround(new LinkedHashMap<BlockPos, BlockState>(), blockStateIn, blockPosIn, worldIn, 0.0f, 0.0f);
    }

    private static boolean removeWaterAround(Map<BlockPos, BlockState> testedPositionsIn, BlockState blockStateIn, BlockPos blockPosIn, Level worldIn, float prohibitedXIn, float prohibitedZIn) {
        boolean success = (Integer)blockStateIn.m_61143_((Property)BlockStatePropertiesAA.LEVEL) > 0;
        blockStateIn = (BlockState)blockStateIn.m_61124_((Property)BlockStatePropertiesAA.LEVEL, (Comparable)Integer.valueOf(0));
        worldIn.m_7731_(blockPosIn, blockStateIn, 10);
        if (prohibitedXIn != 1.0f && PoolBlock.removeWaterAroundOffset(testedPositionsIn, blockPosIn, worldIn, 1, 0)) {
            success = true;
        }
        if (prohibitedXIn != -1.0f && PoolBlock.removeWaterAroundOffset(testedPositionsIn, blockPosIn, worldIn, -1, 0)) {
            success = true;
        }
        if (prohibitedZIn != 1.0f && PoolBlock.removeWaterAroundOffset(testedPositionsIn, blockPosIn, worldIn, 0, 1)) {
            success = true;
        }
        if (prohibitedZIn != -1.0f && PoolBlock.removeWaterAroundOffset(testedPositionsIn, blockPosIn, worldIn, 0, -1)) {
            success = true;
        }
        return success;
    }

    private static boolean removeWaterAroundOffset(Map<BlockPos, BlockState> testedPositionsIn, BlockPos blockPosIn, Level worldIn, int x, int z) {
        BlockPos pos = blockPosIn.m_7918_(x, 0, z);
        if (!testedPositionsIn.containsKey(pos)) {
            BlockState state = worldIn.m_8055_(pos);
            if (state.m_60734_() instanceof PoolBlock) {
                testedPositionsIn.put(pos, state);
                return PoolBlock.removeWaterAround(testedPositionsIn, state, pos, worldIn, x, z);
            }
            if (state.m_60734_() instanceof FaucetBlock) {
                state = (BlockState)state.m_61124_((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(false));
                worldIn.m_7731_(pos, state, 10);
            }
        }
        return false;
    }

    public static EnumActivatorState hasOnePoolActivatorAround(BlockPos blockPosIn, LevelAccessor worldIn) {
        return PoolBlock.hasOnePoolActivatorAround(new LinkedHashMap<BlockPos, BlockState>(), blockPosIn, worldIn, 0.0f, 0.0f);
    }

    private static EnumActivatorState hasOnePoolActivatorAround(Map<BlockPos, BlockState> testedPositionsIn, BlockPos blockPosIn, LevelAccessor worldIn, float prohibitedXIn, float prohibitedZIn) {
        if (testedPositionsIn.containsKey(blockPosIn)) {
            return EnumActivatorState.NO;
        }
        BlockState state = worldIn.m_8055_(blockPosIn.m_7494_());
        testedPositionsIn.put(blockPosIn, state);
        if (state.m_60734_() instanceof WaterTrickleBlock || state.m_60734_() instanceof FaucetBlock && ((Boolean)state.m_61143_((Property)BlockStatePropertiesAA.ACTIVATED)).booleanValue()) {
            return EnumActivatorState.ENABLED;
        }
        if (prohibitedXIn != 1.0f && EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAroundOffset(testedPositionsIn, worldIn, blockPosIn, 1, 0)) || prohibitedXIn != -1.0f && EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAroundOffset(testedPositionsIn, worldIn, blockPosIn, -1, 0)) || prohibitedZIn != 1.0f && EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAroundOffset(testedPositionsIn, worldIn, blockPosIn, 0, 1)) || prohibitedZIn != -1.0f && EnumActivatorState.ENABLED.equals((Object)PoolBlock.hasOnePoolActivatorAroundOffset(testedPositionsIn, worldIn, blockPosIn, 0, -1))) {
            return EnumActivatorState.ENABLED;
        }
        return EnumActivatorState.NO;
    }

    public static EnumActivatorState hasOnePoolActivatorAroundOffset(Map<BlockPos, BlockState> testedPositionsIn, LevelAccessor worldIn, BlockPos baseBlockPosIn, int xOffsetIn, int zOffsetIn) {
        BlockPos offsetBlockPos = baseBlockPosIn.m_7918_(xOffsetIn, 0, zOffsetIn);
        BlockState offsetState = worldIn.m_8055_(offsetBlockPos);
        if (offsetState.m_60734_() instanceof PoolBlock) {
            return PoolBlock.hasOnePoolActivatorAround(testedPositionsIn, offsetBlockPos, worldIn, -xOffsetIn, -zOffsetIn);
        }
        return EnumActivatorState.NO;
    }

    private static PoolLevelAndSides levelOfPoolAround(BlockPos blockPosIn, LevelAccessor worldIn) {
        return PoolBlock.levelOfPoolAround(new LinkedHashMap<BlockPos, BlockState>(), new PoolLevelAndSides(), blockPosIn, worldIn, 0.0f, 0.0f);
    }

    private static PoolLevelAndSides levelOfPoolAround(Map<BlockPos, BlockState> testedPositionsIn, PoolLevelAndSides poolLevelAndSidesIn, BlockPos blockPosIn, LevelAccessor worldIn, float prohibitedXIn, float prohibitedZIn) {
        int level;
        boolean center;
        boolean bl = center = prohibitedXIn == 0.0f && prohibitedZIn == 0.0f;
        if (prohibitedXIn != 1.0f) {
            level = PoolBlock.poolLevelAroundOffset(testedPositionsIn, poolLevelAndSidesIn, blockPosIn, worldIn, 1, 0);
            if (level > 0 && center) {
                poolLevelAndSidesIn.right = true;
            }
            if (level > poolLevelAndSidesIn.level) {
                poolLevelAndSidesIn.level = level;
            }
        }
        if (prohibitedXIn != -1.0f) {
            level = PoolBlock.poolLevelAroundOffset(testedPositionsIn, poolLevelAndSidesIn, blockPosIn, worldIn, -1, 0);
            if (level > 0 && center) {
                poolLevelAndSidesIn.left = true;
            }
            if (level > poolLevelAndSidesIn.level) {
                poolLevelAndSidesIn.level = level;
            }
        }
        if (prohibitedZIn != 1.0f) {
            level = PoolBlock.poolLevelAroundOffset(testedPositionsIn, poolLevelAndSidesIn, blockPosIn, worldIn, 0, 1);
            if (level > 0 && center) {
                poolLevelAndSidesIn.north = true;
            }
            if (level > poolLevelAndSidesIn.level) {
                poolLevelAndSidesIn.level = level;
            }
        }
        if (prohibitedZIn != -1.0f) {
            level = PoolBlock.poolLevelAroundOffset(testedPositionsIn, poolLevelAndSidesIn, blockPosIn, worldIn, 0, -1);
            if (level > 0 && center) {
                poolLevelAndSidesIn.south = true;
            }
            if (level > poolLevelAndSidesIn.level) {
                poolLevelAndSidesIn.level = level;
            }
        }
        return poolLevelAndSidesIn;
    }

    private static int poolLevelAroundOffset(Map<BlockPos, BlockState> testedPositionsIn, PoolLevelAndSides poolLevelAndSidesIn, BlockPos baseBlockPosIn, LevelAccessor worldIn, int xOffsetIn, int zOffsetIn) {
        BlockPos pos = baseBlockPosIn.m_7918_(xOffsetIn, 0, zOffsetIn);
        if (testedPositionsIn.containsKey(pos)) {
            return -1;
        }
        BlockState state = worldIn.m_8055_(pos);
        testedPositionsIn.put(pos, state);
        if (state.m_60734_() instanceof PoolBlock) {
            PoolBlock.levelOfPoolAround(testedPositionsIn, poolLevelAndSidesIn, pos, worldIn, -xOffsetIn, -zOffsetIn);
            int currentLevel = (Integer)state.m_61143_((Property)BlockStatePropertiesAA.LEVEL);
            return Math.max(currentLevel, poolLevelAndSidesIn.level);
        }
        return -1;
    }

    public static final class PoolLevelAndSides {
        public boolean left;
        public boolean right;
        public boolean north;
        public boolean south;
        public int level = 0;
    }

    public static enum EnumActivatorState {
        NO,
        DISABLED,
        ENABLED;

    }
}

