/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GlazedTerracottaBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import org.dawnoftime.dawnoftime.block.IBlockGeneration;
import org.dawnoftime.dawnoftime.platform.Services;
import org.dawnoftime.dawnoftime.util.Utils;

public class SoilCropsBlock
extends CropBlock
implements IBlockGeneration {
    private final PlantType plantType;
    public static final BooleanProperty PERSISTENT = BlockStateProperties.f_61447_;

    public SoilCropsBlock(PlantType type) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50355_).m_222979_(BlockBehaviour.OffsetType.NONE).m_60977_().m_60918_(SoundType.f_56758_));
        this.plantType = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(0))).m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PERSISTENT});
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        float f;
        int age;
        if (((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue()) {
            return;
        }
        if (!worldIn.m_46749_(pos)) {
            return;
        }
        if (worldIn.m_45524_(pos, 0) >= 9 && (age = this.m_52305_(state)) < this.m_7419_() && random.m_188503_((int)(25.0f / (f = SoilCropsBlock.m_52272_((Block)this, (BlockGetter)worldIn, (BlockPos)pos))) + 1) == 0) {
            this.setPlantWithAge(state, (LevelAccessor)worldIn, pos, age + 1);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return this.mayGenerateOn((BlockGetter)world, pos.m_7495_(), this.getPlantType()) && super.m_7898_(state, world, pos);
    }

    private PlantType getPlantType() {
        return this.plantType;
    }

    protected boolean m_6266_(BlockState state, BlockGetter world, BlockPos pos) {
        return this.mayGenerateOn(world, pos, this.getPlantType());
    }

    public boolean mayGenerateOn(BlockGetter worldIn, BlockPos pos, PlantType plantType) {
        BlockState stateOn = worldIn.m_8055_(pos);
        Block blockOn = stateOn.m_60734_();
        if (plantType.equals((Object)PlantType.DESERT)) {
            return stateOn.m_60713_(Blocks.f_49992_) || stateOn.m_60713_(Blocks.f_50352_) || blockOn instanceof GlazedTerracottaBlock;
        }
        if (plantType.equals((Object)PlantType.NETHER)) {
            return stateOn.m_60713_(Blocks.f_50135_);
        }
        if (plantType.equals((Object)PlantType.CROP)) {
            return stateOn.m_60713_(Blocks.f_50093_) || this.isModCompatible(stateOn);
        }
        if (plantType.equals((Object)PlantType.CAVE)) {
            return stateOn.m_60783_(worldIn, pos, Direction.UP);
        }
        if (plantType.equals((Object)PlantType.PLAINS)) {
            return stateOn.m_60713_(Blocks.f_50440_) || stateOn.m_60713_(Blocks.f_50493_) || stateOn.m_60713_(Blocks.f_50093_) || this.isModCompatible(stateOn);
        }
        if (plantType.equals((Object)PlantType.WATER)) {
            return worldIn.m_6425_(pos.m_7494_()).m_76152_() == Fluids.f_76193_ && (stateOn.m_60713_(Blocks.f_50129_) || stateOn.m_60713_(Blocks.f_50493_) || stateOn.m_60713_(Blocks.f_50093_) || stateOn.m_60713_(Blocks.f_49994_));
        }
        if (plantType.equals((Object)PlantType.BEACH)) {
            boolean isBeach;
            boolean bl = isBeach = stateOn.m_60713_(Blocks.f_50440_) || stateOn.m_60713_(Blocks.f_50493_) || stateOn.m_60713_(Blocks.f_49992_) || stateOn.m_60713_(Blocks.f_49993_);
            if (isBeach) {
                boolean hasWater = false;
                for (Direction face : Direction.Plane.HORIZONTAL) {
                    BlockState blockState = worldIn.m_8055_(pos.m_121945_(face));
                    FluidState fluidState = worldIn.m_6425_(pos.m_121945_(face));
                    hasWater = blockState.m_60713_(Blocks.f_50449_);
                    if (!(hasWater |= fluidState.m_205070_(FluidTags.f_13131_))) continue;
                    break;
                }
                return hasWater;
            }
        }
        return false;
    }

    private boolean isModCompatible(BlockState stateOn) {
        if (Services.PLATFORM.isModLoaded("farmersdelight") && stateOn.m_60713_(this.getBlockFromRegistry("farmersdelight:rich_soil_farmland"))) {
            return true;
        }
        if (Services.PLATFORM.isModLoaded("aether") && stateOn.m_60713_(this.getBlockFromRegistry("aether:aether_farmland"))) {
            return true;
        }
        return Services.PLATFORM.isModLoaded("immersive_weathering") && (stateOn.m_60713_(this.getBlockFromRegistry("immersive_weathering:loamy_farmland")) || stateOn.m_60713_(this.getBlockFromRegistry("immersive_weathering:earthen_clay_farmland")) || stateOn.m_60713_(this.getBlockFromRegistry("immersive_weathering:sandy_farmland")) || stateOn.m_60713_(this.getBlockFromRegistry("immersive_weathering:silty_farmland")));
    }

    private Block getBlockFromRegistry(String name) {
        return (Block)BuiltInRegistries.f_256975_.m_7745_(ResourceLocation.m_135820_((String)name));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (((Boolean)state.m_61143_((Property)PERSISTENT)).booleanValue()) {
            if (player.m_7500_()) {
                int age = this.m_52305_(state);
                if (player.m_6047_()) {
                    if (age > 0) {
                        this.setPlantWithAge(state, (LevelAccessor)worldIn, pos, age - 1);
                        return InteractionResult.SUCCESS;
                    }
                } else if (age < this.m_7419_()) {
                    this.setPlantWithAge(state, (LevelAccessor)worldIn, pos, age + 1);
                    return InteractionResult.SUCCESS;
                }
            }
        } else if (Utils.useLighter(worldIn, pos, player, handIn)) {
            Random rand = new Random();
            for (int i = 0; i < 5; ++i) {
                worldIn.m_7107_((ParticleOptions)ParticleTypes.f_123762_, (double)pos.m_123341_() + rand.nextDouble(), (double)pos.m_123342_() + 0.5 + rand.nextDouble() / 2.0, (double)pos.m_123343_() + rand.nextDouble(), 0.0, 0.07, 0.0);
            }
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)PERSISTENT, (Comparable)Boolean.valueOf(true)), 10);
            return InteractionResult.SUCCESS;
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public void setPlantWithAge(BlockState currentState, LevelAccessor worldIn, BlockPos pos, int newAge) {
        worldIn.m_7731_(pos, (BlockState)currentState.m_61124_((Property)this.m_7959_(), (Comparable)Integer.valueOf(newAge)), 10);
    }

    @Nonnull
    protected ItemLike m_6404_() {
        return this.m_5456_();
    }

    @Override
    public boolean generateOnPos(WorldGenLevel world, BlockPos pos, BlockState state, RandomSource random) {
        BlockState groundState = world.m_8055_(pos.m_7495_());
        if (!groundState.m_204336_(BlockTags.f_144274_)) {
            return false;
        }
        this.setPlantWithAge(state, (LevelAccessor)world, pos, random.m_188503_(this.m_7419_() + 1));
        return true;
    }

    public static enum PlantType {
        DESERT,
        NETHER,
        CROP,
        CAVE,
        PLAINS,
        WATER,
        BEACH;

    }
}

