/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.container;

import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.dawnoftime.dawnoftime.block.IBlockSpecialDisplay;
import org.dawnoftime.dawnoftime.blockentity.DisplayerBlockEntity;
import org.dawnoftime.dawnoftime.registry.DoTBMenuTypesRegistry;

public class DisplayerMenu
extends AbstractContainerMenu {
    private DisplayerBlockEntity blockEntity;
    private final ContainerLevelAccess levelAccess;

    public DisplayerMenu(int windowId, Inventory playerInventory, FriendlyByteBuf additionalData) {
        this(windowId, playerInventory, playerInventory.f_35978_.m_9236_().m_7702_(additionalData.m_130135_()));
    }

    public DisplayerMenu(int windowId, Inventory playerInventory, BlockEntity blockEntity) {
        super(DoTBMenuTypesRegistry.INSTANCE.DISPLAYER.get(), windowId);
        DisplayerBlockEntity displayerBlockEntity;
        if (!(blockEntity instanceof DisplayerBlockEntity)) {
            throw new IllegalStateException(String.format("Incorrect block entity class (%s) passed into DisplayerMenu.", blockEntity.getClass().getCanonicalName()));
        }
        this.blockEntity = displayerBlockEntity = (DisplayerBlockEntity)blockEntity;
        this.levelAccess = ContainerLevelAccess.m_39289_((Level)blockEntity.m_58904_(), (BlockPos)blockEntity.m_58899_());
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.m_38897_(new Slot((Container)this.blockEntity, j + i * 3, 19 + j * 18, 168 + i * 18));
            }
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.m_38897_(new Slot((Container)playerInventory, 9 + x + y * 9, 88 + x * 18, 157 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.m_38897_(new Slot((Container)playerInventory, x, 88 + x * 18, 215));
        }
    }

    public boolean m_6875_(Player playerIn) {
        if (this.blockEntity.m_58904_() == null) {
            return false;
        }
        return DisplayerMenu.m_38889_((ContainerLevelAccess)this.levelAccess, (Player)playerIn, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    public void m_38946_() {
        super.m_38946_();
        if (this.blockEntity.m_58904_() != null && !this.blockEntity.m_58904_().m_5776_()) {
            boolean lit = false;
            for (int index = 0; index < this.blockEntity.m_6643_(); ++index) {
                Item item;
                ItemStack itemstack = this.blockEntity.m_8020_(index);
                if (!itemstack.m_41619_() && (item = itemstack.m_41720_()) instanceof BlockItem) {
                    Block block = ((BlockItem)item).m_40614_();
                    if (block instanceof IBlockSpecialDisplay) {
                        lit = ((IBlockSpecialDisplay)block).emitsLight();
                    } else {
                        boolean bl = lit = block.m_7753_(block.m_49966_(), (BlockGetter)this.blockEntity.m_58904_(), this.blockEntity.m_58899_()) > 0;
                    }
                }
                if (lit) break;
            }
        }
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack stackFromSlot = slot.m_7993_();
            itemStack = stackFromSlot.m_41777_();
            if (index < 9 ? !this.m_38903_(stackFromSlot, 9, this.f_38839_.size(), true) : !this.m_38903_(stackFromSlot, 0, 9, false)) {
                return ItemStack.f_41583_;
            }
            if (stackFromSlot.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemStack;
    }
}

