/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.dawnoftime.dawnoftime.registry.DoTBEntitiesRegistry;
import org.jetbrains.annotations.NotNull;

public class ChairEntity
extends Entity {
    private BlockPos pos;

    public ChairEntity(Level level) {
        super(DoTBEntitiesRegistry.INSTANCE.CHAIR_ENTITY.get(), level);
        this.f_19794_ = true;
    }

    private ChairEntity(Level level, BlockPos pos, Direction direction, float pixelsXOffset, float pixelsYOffset, float pixelsZOffset) {
        this(level);
        this.pos = pos;
        this.m_146922_(direction.m_122435_());
        this.m_6034_((double)pos.m_123341_() + (double)pixelsXOffset / 16.0, (double)pos.m_123342_() + ((double)pixelsYOffset - 3.0) / 16.0, (double)pos.m_123343_() + (double)pixelsZOffset / 16.0);
    }

    public static InteractionResult createEntity(Level level, BlockPos pos, Player player, Direction direction, float pixelsXOffset, float pixelsYOffset, float pixelsZOffset) {
        if (!level.m_5776_()) {
            List seats = level.m_45976_(ChairEntity.class, new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)pos.m_123341_() + 1.0, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 1.0));
            if (seats.isEmpty()) {
                ChairEntity seat = new ChairEntity(level, pos, direction, pixelsXOffset, pixelsYOffset, pixelsZOffset);
                level.m_7967_((Entity)seat);
                if (player.m_7998_((Entity)seat, false)) {
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.SUCCESS;
    }

    public static InteractionResult createEntity(Level level, BlockPos pos, Player player, Direction direction, float pixelsYOffset) {
        return ChairEntity.createEntity(level, pos, player, direction, 8.0f, pixelsYOffset, 8.0f);
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.pos == null) {
            this.pos = this.m_20183_();
        }
        if (!this.m_9236_().m_5776_() && (this.m_20197_().isEmpty() || this.m_9236_().m_46859_(this.pos))) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_9236_().m_46717_(this.m_20183_(), this.m_9236_().m_8055_(this.m_20183_()).m_60734_());
        }
    }

    protected void m_7378_(@NotNull CompoundTag p_70037_1_) {
    }

    protected void m_7380_(@NotNull CompoundTag p_213281_1_) {
    }

    @NotNull
    public Packet<ClientGamePacketListener> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this);
    }

    protected void clampRotation(Entity player) {
        player.m_5618_(this.m_146908_());
        float f = Mth.m_14177_((float)(player.m_146908_() - this.m_146908_()));
        float f1 = Mth.m_14036_((float)f, (float)-105.0f, (float)105.0f);
        player.f_19859_ += f1 - f;
        player.m_146922_(player.m_146908_() + f1 - f);
        player.m_5616_(player.m_146908_());
    }

    public void m_7340_(Entity pEntityToUpdate) {
        this.clampRotation(pEntityToUpdate);
    }

    public double m_6048_() {
        return 0.0;
    }

    protected boolean m_7341_(Entity entity) {
        return true;
    }

    @NotNull
    public Vec3 m_7688_(@NotNull LivingEntity passenger) {
        Direction dir = this.m_6350_();
        Direction dirCW = dir.m_122427_();
        Direction dirCCW = dir.m_122428_();
        int[][] candidatePositions = new int[][]{{dir.m_122429_(), dir.m_122431_()}, {dirCW.m_122429_(), dirCW.m_122431_()}, {dirCCW.m_122429_(), dirCCW.m_122431_()}};
        BlockPos pos = this.m_20183_();
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        for (Pose pose : passenger.m_7431_()) {
            AABB aabb = passenger.m_21270_(pose);
            for (int[] candidatePos : candidatePositions) {
                posMutable.m_122178_(pos.m_123341_() + candidatePos[0], pos.m_123342_(), pos.m_123343_() + candidatePos[1]);
                double posY = this.m_9236_().m_45573_((BlockPos)posMutable);
                if (!DismountHelper.m_38439_((double)posY)) continue;
                Vec3 vec3 = Vec3.m_82514_((Vec3i)posMutable, (double)posY);
                if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)passenger, (AABB)aabb.m_82383_(vec3))) continue;
                passenger.m_20124_(pose);
                return vec3;
            }
        }
        return new Vec3(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
    }
}

