/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.util;

import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;

public class VoxelShapesBuilder {
    public static VoxelShape[] generateHorizontalShapes(VoxelShape[] shapes, VoxelShape ... nonRotatedShapes) {
        int n;
        VoxelShape[] newShape = new VoxelShape[]{Shapes.m_83040_()};
        VoxelShape[] newShapes = new VoxelShape[shapes.length * 4 + nonRotatedShapes.length];
        int i = 0;
        VoxelShape[] voxelShapeArray = shapes;
        int n2 = voxelShapeArray.length;
        for (n = 0; n < n2; ++n) {
            VoxelShape shape;
            newShapes[i] = shape = voxelShapeArray[n];
            ++i;
        }
        for (int rotation = 1; rotation < 4; ++rotation) {
            int j = 0;
            for (VoxelShape shape : shapes) {
                shape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    newShape[0] = Shapes.m_83110_((VoxelShape)newShape[0], (VoxelShape)Shapes.m_83048_((double)(1.0 - maxZ), (double)minY, (double)minX, (double)(1.0 - minZ), (double)maxY, (double)maxX));
                });
                shapes[j] = newShape[0];
                newShapes[i] = newShape[0];
                newShape[0] = Shapes.m_83040_();
                ++i;
                ++j;
            }
        }
        VoxelShape[] voxelShapeArray2 = nonRotatedShapes;
        n2 = voxelShapeArray2.length;
        for (n = 0; n < n2; ++n) {
            VoxelShape shape;
            newShapes[i] = shape = voxelShapeArray2[n];
            ++i;
        }
        return newShapes;
    }

    public static VoxelShape[] generateFourSidesShapes(VoxelShape vsSouth) {
        VoxelShape[] horizontalShapes = VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{vsSouth}, new VoxelShape[0]);
        VoxelShape vsWest = horizontalShapes[1];
        VoxelShape vsNorth = horizontalShapes[2];
        VoxelShape vsEast = horizontalShapes[3];
        VoxelShape vsSW = Shapes.m_83110_((VoxelShape)vsSouth, (VoxelShape)vsWest);
        VoxelShape vsWN = Shapes.m_83110_((VoxelShape)vsWest, (VoxelShape)vsNorth);
        VoxelShape vsNE = Shapes.m_83110_((VoxelShape)vsNorth, (VoxelShape)vsEast);
        VoxelShape vsES = Shapes.m_83110_((VoxelShape)vsEast, (VoxelShape)vsSouth);
        VoxelShape all = Shapes.m_83110_((VoxelShape)vsSW, (VoxelShape)vsNE);
        return new VoxelShape[]{all, vsSouth, vsWest, vsSW, vsNorth, Shapes.m_83110_((VoxelShape)vsSouth, (VoxelShape)vsNorth), vsWN, Shapes.m_83110_((VoxelShape)vsSW, (VoxelShape)vsNorth), vsEast, vsES, Shapes.m_83110_((VoxelShape)vsWest, (VoxelShape)vsEast), Shapes.m_83110_((VoxelShape)vsSW, (VoxelShape)vsEast), vsNE, Shapes.m_83110_((VoxelShape)vsSouth, (VoxelShape)vsNE), Shapes.m_83110_((VoxelShape)vsWN, (VoxelShape)vsEast)};
    }

    protected static VoxelShape[] makePlateShapes() {
        VoxelShape vsNorthFlat = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        VoxelShape vsEastFlat = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsSouthFlat = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsWestFlat = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
        VoxelShape vsNorthWestCorner = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0);
        VoxelShape vsNorthEastCorner = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        VoxelShape vsSouthEastCorner = Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsSouthWestCorner = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0, (double)16.0);
        return new VoxelShape[]{vsNorthWestCorner, vsNorthFlat, Shapes.m_83110_((VoxelShape)vsNorthFlat, (VoxelShape)vsSouthWestCorner), vsNorthEastCorner, vsEastFlat, Shapes.m_83110_((VoxelShape)vsEastFlat, (VoxelShape)vsNorthWestCorner), vsSouthEastCorner, vsSouthFlat, Shapes.m_83110_((VoxelShape)vsSouthFlat, (VoxelShape)vsNorthEastCorner), vsSouthWestCorner, vsWestFlat, Shapes.m_83110_((VoxelShape)vsWestFlat, (VoxelShape)vsSouthEastCorner)};
    }

    protected static VoxelShape[] makeThinPlateShapes() {
        VoxelShape vsNorthFlat = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
        VoxelShape vsEastFlat = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsSouthFlat = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsWestFlat = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
        VoxelShape vsNorthWestCorner = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0);
        VoxelShape vsNorthEastCorner = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
        VoxelShape vsSouthEastCorner = Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsSouthWestCorner = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0);
        return new VoxelShape[]{vsNorthWestCorner, vsNorthFlat, Shapes.m_83110_((VoxelShape)vsNorthFlat, (VoxelShape)vsWestFlat), vsNorthEastCorner, vsEastFlat, Shapes.m_83110_((VoxelShape)vsEastFlat, (VoxelShape)vsNorthFlat), vsSouthEastCorner, vsSouthFlat, Shapes.m_83110_((VoxelShape)vsSouthFlat, (VoxelShape)vsEastFlat), vsSouthWestCorner, vsWestFlat, Shapes.m_83110_((VoxelShape)vsWestFlat, (VoxelShape)vsSouthFlat)};
    }

    protected static VoxelShape[] makePoolShapes() {
        VoxelShape vsFloor = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
        VoxelShape vsNorth = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
        VoxelShape vsEast = Block.m_49796_((double)14.0, (double)2.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsSouth = Block.m_49796_((double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsWest = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
        VoxelShape vsPillar = Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape[] shapes = new VoxelShape[32];
        for (int i = 0; i < 32; ++i) {
            VoxelShape temp = vsFloor;
            if ((i & 1) == 0) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)vsNorth);
            }
            if ((i >> 1 & 1) == 0) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)vsEast);
            }
            if ((i >> 2 & 1) == 0) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)vsSouth);
            }
            if ((i >> 3 & 1) == 0) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)vsWest);
            }
            if ((i >> 4 & 1) == 1) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)vsPillar);
            }
            shapes[i] = temp;
        }
        return shapes;
    }

    protected static VoxelShape[] makeSmallPoolShapes() {
        VoxelShape vsFloor = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
        VoxelShape vsNorth = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
        VoxelShape vsEast = Block.m_49796_((double)14.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsSouth = Block.m_49796_((double)0.0, (double)8.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsWest = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
        VoxelShape vsPillar = Block.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape vsBottom = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0);
        VoxelShape[] shapes = new VoxelShape[64];
        for (int i = 0; i < 64; ++i) {
            VoxelShape temp = vsFloor;
            if ((i & 1) == 0) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)vsNorth);
            }
            if ((i >> 1 & 1) == 0) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)vsEast);
            }
            if ((i >> 2 & 1) == 0) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)vsSouth);
            }
            if ((i >> 3 & 1) == 0) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)vsWest);
            }
            if ((i >> 4 & 1) == 1) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)vsPillar);
            }
            if ((i >> 5 & 1) == 1) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)vsBottom);
            }
            shapes[i] = temp;
        }
        return shapes;
    }

    protected static VoxelShape[] makeSmallPoolCollisionShapes() {
        VoxelShape vsFloor = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0);
        VoxelShape vsNorth = Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
        VoxelShape vsEast = Block.m_49796_((double)14.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsSouth = Block.m_49796_((double)0.0, (double)10.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsWest = Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
        VoxelShape vsPillar = Block.m_49796_((double)4.0, (double)10.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape[] shapes = new VoxelShape[32];
        for (int i = 0; i < 32; ++i) {
            VoxelShape temp = vsFloor;
            if ((i & 1) == 0) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)vsNorth);
            }
            if ((i >> 1 & 1) == 0) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)vsEast);
            }
            if ((i >> 2 & 1) == 0) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)vsSouth);
            }
            if ((i >> 3 & 1) == 0) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)vsWest);
            }
            if ((i >> 4 & 1) == 1) {
                temp = Shapes.m_83110_((VoxelShape)temp, (VoxelShape)vsPillar);
            }
            shapes[i] = temp;
        }
        return shapes;
    }

    protected static VoxelShape[] makeBeamShapes() {
        VoxelShape vsAxisX = Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
        VoxelShape vsAxisZ = Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
        VoxelShape vsAxisXZ = Shapes.m_83110_((VoxelShape)vsAxisX, (VoxelShape)vsAxisZ);
        VoxelShape vsAxisY = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        VoxelShape vsAxisY_bottom = Shapes.m_83110_((VoxelShape)vsAxisY, (VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0));
        return new VoxelShape[]{vsAxisX, vsAxisZ, vsAxisXZ, vsAxisY, Shapes.m_83110_((VoxelShape)vsAxisY, (VoxelShape)vsAxisX), Shapes.m_83110_((VoxelShape)vsAxisY, (VoxelShape)vsAxisZ), Shapes.m_83110_((VoxelShape)vsAxisY, (VoxelShape)vsAxisXZ), vsAxisY_bottom, Shapes.m_83110_((VoxelShape)vsAxisY_bottom, (VoxelShape)vsAxisX), Shapes.m_83110_((VoxelShape)vsAxisY_bottom, (VoxelShape)vsAxisZ), Shapes.m_83110_((VoxelShape)vsAxisY_bottom, (VoxelShape)vsAxisXZ)};
    }

    protected static VoxelShape[] makePergolaShapes() {
        VoxelShape vsAxisX = Block.m_49796_((double)0.0, (double)5.0, (double)6.0, (double)16.0, (double)11.0, (double)10.0);
        VoxelShape vsAxisZ = Block.m_49796_((double)6.0, (double)5.0, (double)0.0, (double)10.0, (double)11.0, (double)16.0);
        VoxelShape vsAxisXZ = Shapes.m_83110_((VoxelShape)vsAxisX, (VoxelShape)vsAxisZ);
        VoxelShape vsAxisY = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
        return new VoxelShape[]{vsAxisX, vsAxisZ, vsAxisXZ, vsAxisY, Shapes.m_83110_((VoxelShape)vsAxisY, (VoxelShape)vsAxisX), Shapes.m_83110_((VoxelShape)vsAxisY, (VoxelShape)vsAxisZ), Shapes.m_83110_((VoxelShape)vsAxisY, (VoxelShape)vsAxisXZ)};
    }

    protected static VoxelShape[] makeEdgeShapes() {
        VoxelShape vsNorthFlat = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
        VoxelShape vsEastFlat = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        VoxelShape vsSouthFlat = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
        VoxelShape vsWestFlat = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0);
        VoxelShape vsNorthWestCorner = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0);
        VoxelShape vsNorthEastCorner = Block.m_49796_((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
        VoxelShape vsSouthEastCorner = Block.m_49796_((double)8.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0);
        VoxelShape vsSouthWestCorner = Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0, (double)16.0);
        VoxelShape[] voxelShapes = new VoxelShape[24];
        VoxelShape[] voxelShapesBottom = new VoxelShape[]{vsNorthWestCorner, vsNorthFlat, Shapes.m_83110_((VoxelShape)vsNorthFlat, (VoxelShape)vsSouthWestCorner), vsNorthEastCorner, vsEastFlat, Shapes.m_83110_((VoxelShape)vsEastFlat, (VoxelShape)vsNorthWestCorner), vsSouthEastCorner, vsSouthFlat, Shapes.m_83110_((VoxelShape)vsSouthFlat, (VoxelShape)vsNorthEastCorner), vsSouthWestCorner, vsWestFlat, Shapes.m_83110_((VoxelShape)vsWestFlat, (VoxelShape)vsSouthEastCorner)};
        System.arraycopy(voxelShapesBottom, 0, voxelShapes, 0, voxelShapesBottom.length);
        for (int i = 0; i < voxelShapesBottom.length; ++i) {
            voxelShapes[i + voxelShapesBottom.length] = voxelShapesBottom[i].m_83216_(0.0, 0.5, 0.0);
        }
        return voxelShapes;
    }

    protected static VoxelShape[] makeLatticeShapes() {
        VoxelShape vsSouth = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsWest = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
        VoxelShape vsNorth = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
        VoxelShape vsEast = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsSouthWest = Shapes.m_83110_((VoxelShape)vsSouth, (VoxelShape)vsWest);
        VoxelShape vsNorthWest = Shapes.m_83110_((VoxelShape)vsWest, (VoxelShape)vsNorth);
        VoxelShape vsNorthEast = Shapes.m_83110_((VoxelShape)vsNorth, (VoxelShape)vsEast);
        VoxelShape vsSouthEast = Shapes.m_83110_((VoxelShape)vsEast, (VoxelShape)vsSouth);
        return new VoxelShape[]{Shapes.m_83110_((VoxelShape)vsSouthWest, (VoxelShape)vsNorthEast), vsSouth, vsWest, vsSouthWest, vsNorth, Shapes.m_83110_((VoxelShape)vsSouth, (VoxelShape)vsNorth), vsNorthWest, Shapes.m_83110_((VoxelShape)vsSouthWest, (VoxelShape)vsNorth), vsEast, vsSouthEast, Shapes.m_83110_((VoxelShape)vsWest, (VoxelShape)vsEast), Shapes.m_83110_((VoxelShape)vsSouthWest, (VoxelShape)vsEast), vsNorthEast, Shapes.m_83110_((VoxelShape)vsSouth, (VoxelShape)vsNorthEast), Shapes.m_83110_((VoxelShape)vsNorthWest, (VoxelShape)vsEast)};
    }

    protected static VoxelShape[] makeWaxedOakTableShapes() {
        VoxelShape[] vsSide = VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)13.5, (double)15.0, (double)3.0, (double)14.5), (VoxelShape)Block.m_49796_((double)1.0, (double)12.0, (double)13.5, (double)15.0, (double)16.0, (double)14.5))}, new VoxelShape[0]);
        VoxelShape[] vsPillar = VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Block.m_49796_((double)0.5, (double)0.0, (double)12.5, (double)3.5, (double)16.0, (double)15.5)}, new VoxelShape[0]);
        VoxelShape[] vsPillarLeft = VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0, (double)15.0)}, new VoxelShape[0]);
        VoxelShape[] vsPillarRight = VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)15.0, (double)3.0, (double)16.0, (double)16.0)}, new VoxelShape[0]);
        return new VoxelShape[]{Shapes.m_83040_(), Shapes.m_83124_((VoxelShape)vsSide[0], (VoxelShape[])new VoxelShape[]{vsPillarLeft[0], vsPillarRight[3]}), Shapes.m_83124_((VoxelShape)vsSide[1], (VoxelShape[])new VoxelShape[]{vsPillarLeft[1], vsPillarRight[0]}), Shapes.m_83124_((VoxelShape)vsSide[0], (VoxelShape[])new VoxelShape[]{vsSide[1], vsPillar[0], vsPillarLeft[1], vsPillarRight[3]}), Shapes.m_83124_((VoxelShape)vsSide[2], (VoxelShape[])new VoxelShape[]{vsPillarLeft[2], vsPillarRight[1]}), Shapes.m_83124_((VoxelShape)vsSide[0], (VoxelShape[])new VoxelShape[]{vsSide[2], vsPillarLeft[0], vsPillarRight[3], vsPillarLeft[2], vsPillarRight[1]}), Shapes.m_83124_((VoxelShape)vsSide[1], (VoxelShape[])new VoxelShape[]{vsSide[2], vsPillar[1], vsPillarLeft[2], vsPillarRight[0]}), Shapes.m_83124_((VoxelShape)vsSide[0], (VoxelShape[])new VoxelShape[]{vsSide[1], vsSide[2], vsPillar[0], vsPillar[1], vsPillarLeft[2], vsPillarRight[3]}), Shapes.m_83124_((VoxelShape)vsSide[3], (VoxelShape[])new VoxelShape[]{vsPillarLeft[3], vsPillarRight[2]}), Shapes.m_83124_((VoxelShape)vsSide[0], (VoxelShape[])new VoxelShape[]{vsSide[3], vsPillar[3], vsPillarLeft[0], vsPillarRight[2]}), Shapes.m_83124_((VoxelShape)vsSide[1], (VoxelShape[])new VoxelShape[]{vsSide[3], vsPillarLeft[1], vsPillarRight[0], vsPillarLeft[3], vsPillarRight[2]}), Shapes.m_83124_((VoxelShape)vsSide[0], (VoxelShape[])new VoxelShape[]{vsSide[1], vsSide[3], vsPillar[0], vsPillar[3], vsPillarLeft[1], vsPillarRight[2]}), Shapes.m_83124_((VoxelShape)vsSide[2], (VoxelShape[])new VoxelShape[]{vsSide[3], vsPillar[2], vsPillarRight[1], vsPillarLeft[3]}), Shapes.m_83124_((VoxelShape)vsSide[0], (VoxelShape[])new VoxelShape[]{vsSide[2], vsSide[3], vsPillar[2], vsPillar[3], vsPillarLeft[0], vsPillarRight[1]}), Shapes.m_83124_((VoxelShape)vsSide[1], (VoxelShape[])new VoxelShape[]{vsSide[2], vsSide[3], vsPillar[1], vsPillar[2], vsPillarLeft[3], vsPillarRight[0]}), Shapes.m_83124_((VoxelShape)vsSide[0], (VoxelShape[])new VoxelShape[]{vsSide[1], vsSide[2], vsSide[3], vsPillar[0], vsPillar[1], vsPillar[2], vsPillar[3]}), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0)};
    }

    protected static VoxelShape[] makeSupportSlabShapes() {
        VoxelShape vs = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsFourPx = Shapes.m_83110_((VoxelShape)vs, (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
        VoxelShape vsEightPx = Shapes.m_83110_((VoxelShape)vs, (VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0));
        VoxelShape vsTenPx = Shapes.m_83110_((VoxelShape)vs, (VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
        return new VoxelShape[]{vs, vsFourPx, vsEightPx, vsTenPx};
    }

    protected static VoxelShape[] makeMultiblockFireplaceShapes() {
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)12.0)}, new VoxelShape[0]);
    }

    protected static VoxelShape[] makeReliefShapes() {
        VoxelShape vsCenter = Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0);
        VoxelShape vsUnder = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)4.0);
        VoxelShape vsAbove = Block.m_49796_((double)4.0, (double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0);
        VoxelShape vsLeft = Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0);
        VoxelShape vsRight = Block.m_49796_((double)12.0, (double)4.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0);
        VoxelShape vsVertical = Shapes.m_83124_((VoxelShape)vsCenter, (VoxelShape[])new VoxelShape[]{vsUnder, vsAbove});
        VoxelShape vsHorizontal = Shapes.m_83124_((VoxelShape)vsCenter, (VoxelShape[])new VoxelShape[]{vsLeft, vsRight});
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{vsCenter, vsHorizontal, vsHorizontal, vsHorizontal, vsVertical, Shapes.m_83124_((VoxelShape)vsCenter, (VoxelShape[])new VoxelShape[]{vsUnder, vsRight}), Shapes.m_83124_((VoxelShape)vsCenter, (VoxelShape[])new VoxelShape[]{vsUnder, vsLeft}), Shapes.m_83110_((VoxelShape)vsHorizontal, (VoxelShape)vsUnder), vsVertical, Shapes.m_83124_((VoxelShape)vsCenter, (VoxelShape[])new VoxelShape[]{vsAbove, vsRight}), Shapes.m_83124_((VoxelShape)vsCenter, (VoxelShape[])new VoxelShape[]{vsAbove, vsLeft}), Shapes.m_83110_((VoxelShape)vsHorizontal, (VoxelShape)vsAbove), vsVertical, Shapes.m_83110_((VoxelShape)vsVertical, (VoxelShape)vsRight), Shapes.m_83110_((VoxelShape)vsVertical, (VoxelShape)vsLeft), Shapes.m_83110_((VoxelShape)vsVertical, (VoxelShape)vsHorizontal)}, new VoxelShape[0]);
    }

    protected static VoxelShape[] makeSmallShutterShapes() {
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)-13.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)29.0, (double)16.0, (double)16.0)}, new VoxelShape[0]);
    }

    protected static VoxelShape[] makeSupportBeamShapes() {
        VoxelShape vs = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsAxisX = Shapes.m_83110_((VoxelShape)vs, (VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0));
        VoxelShape vsAxisZ = Shapes.m_83110_((VoxelShape)vs, (VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0));
        VoxelShape vsAxisXZ = Shapes.m_83110_((VoxelShape)vsAxisX, (VoxelShape)Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0));
        VoxelShape vsAxis4px = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape vsAxis8px = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
        VoxelShape vsAxis10px = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
        return new VoxelShape[]{vsAxisX, vsAxisZ, vsAxisXZ, Shapes.m_83110_((VoxelShape)vsAxisX, (VoxelShape)vsAxis4px), Shapes.m_83110_((VoxelShape)vsAxisZ, (VoxelShape)vsAxis4px), Shapes.m_83110_((VoxelShape)vsAxisXZ, (VoxelShape)vsAxis4px), Shapes.m_83110_((VoxelShape)vsAxisX, (VoxelShape)vsAxis8px), Shapes.m_83110_((VoxelShape)vsAxisZ, (VoxelShape)vsAxis8px), Shapes.m_83110_((VoxelShape)vsAxisXZ, (VoxelShape)vsAxis8px), Shapes.m_83110_((VoxelShape)vsAxisX, (VoxelShape)vsAxis10px), Shapes.m_83110_((VoxelShape)vsAxisZ, (VoxelShape)vsAxis10px), Shapes.m_83110_((VoxelShape)vsAxisXZ, (VoxelShape)vsAxis10px)};
    }

    protected static VoxelShape[] makeLimestoneSidedColumnShapes() {
        VoxelShape vsColumn = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.5, (double)0.0, (double)0.0, (double)14.5, (double)16.0, (double)3.0), (VoxelShape)Block.m_49796_((double)5.5, (double)0.0, (double)3.0, (double)10.5, (double)16.0, (double)6.0));
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{vsColumn, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.5, (double)0.0, (double)0.0, (double)14.5, (double)9.0, (double)3.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)5.5, (double)0.0, (double)3.0, (double)10.5, (double)9.0, (double)6.0), Block.m_49796_((double)0.5, (double)9.0, (double)0.0, (double)15.5, (double)14.0, (double)4.0), Block.m_49796_((double)4.5, (double)9.0, (double)4.0, (double)11.5, (double)14.0, (double)7.0), Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0), Block.m_49796_((double)3.5, (double)14.0, (double)5.0, (double)12.5, (double)16.0, (double)8.0)}), Shapes.m_83124_((VoxelShape)Block.m_49796_((double)1.5, (double)4.0, (double)0.0, (double)14.5, (double)16.0, (double)3.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)5.5, (double)4.0, (double)3.0, (double)10.5, (double)16.0, (double)6.0), Block.m_49796_((double)1.0, (double)5.0, (double)0.0, (double)15.0, (double)6.0, (double)3.5), Block.m_49796_((double)5.0, (double)5.0, (double)3.5, (double)11.0, (double)6.0, (double)6.5), Block.m_49796_((double)0.5, (double)0.0, (double)0.0, (double)15.5, (double)4.0, (double)4.0), Block.m_49796_((double)4.5, (double)0.0, (double)4.0, (double)11.5, (double)4.0, (double)7.0)}), vsColumn}, new VoxelShape[0]);
    }

    protected static VoxelShape[] makeReinforcedIronFenceShapes() {
        VoxelShape vsNorthFlat = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)4.0, (double)16.0, (double)16.0, (double)6.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)8.0, (double)9.0));
        VoxelShape vsEastFlat = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)10.0, (double)8.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)15.0, (double)8.0, (double)16.0));
        VoxelShape vsSouthFlat = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)10.0, (double)16.0, (double)16.0, (double)12.0), (VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)8.0, (double)15.0));
        VoxelShape vsWestFlat = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)8.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)0.0, (double)9.0, (double)8.0, (double)16.0));
        VoxelShape vsNorthWestCorner = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape vsNorthEastCorner = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)10.0);
        VoxelShape vsSouthEastCorner = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsSouthWestCorner = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)16.0);
        VoxelShape vsNorthFlatTop = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)6.0);
        VoxelShape vsEastFlatTop = Block.m_49796_((double)10.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
        VoxelShape vsSouthFlatTop = Block.m_49796_((double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0, (double)12.0);
        VoxelShape vsWestFlatTop = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0);
        VoxelShape vsNorthWestCornerTop = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape vsNorthEastCornerTop = Block.m_49796_((double)6.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)10.0);
        VoxelShape vsSouthEastCornerTop = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsSouthWestCornerTop = Block.m_49796_((double)0.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)16.0);
        return new VoxelShape[]{vsNorthWestCorner, vsNorthFlat, Shapes.m_83124_((VoxelShape)vsNorthFlat, (VoxelShape[])new VoxelShape[]{vsWestFlat, vsNorthWestCorner}), vsNorthEastCorner, vsEastFlat, Shapes.m_83124_((VoxelShape)vsEastFlat, (VoxelShape[])new VoxelShape[]{vsNorthFlat, vsNorthEastCorner}), vsSouthEastCorner, vsSouthFlat, Shapes.m_83124_((VoxelShape)vsSouthFlat, (VoxelShape[])new VoxelShape[]{vsEastFlat, vsSouthEastCorner}), vsSouthWestCorner, vsWestFlat, Shapes.m_83124_((VoxelShape)vsWestFlat, (VoxelShape[])new VoxelShape[]{vsSouthFlat, vsSouthWestCorner}), vsNorthWestCornerTop, vsNorthFlatTop, Shapes.m_83124_((VoxelShape)vsNorthFlatTop, (VoxelShape[])new VoxelShape[]{vsWestFlatTop, vsNorthWestCornerTop}), vsNorthEastCornerTop, vsEastFlatTop, Shapes.m_83124_((VoxelShape)vsEastFlatTop, (VoxelShape[])new VoxelShape[]{vsNorthFlatTop, vsNorthEastCornerTop}), vsSouthEastCornerTop, vsSouthFlatTop, Shapes.m_83124_((VoxelShape)vsSouthFlatTop, (VoxelShape[])new VoxelShape[]{vsEastFlatTop, vsSouthEastCornerTop}), vsSouthWestCornerTop, vsWestFlatTop, Shapes.m_83124_((VoxelShape)vsWestFlatTop, (VoxelShape[])new VoxelShape[]{vsSouthFlatTop, vsSouthWestCornerTop})};
    }

    protected static VoxelShape[] makeIronFenceShapes() {
        VoxelShape vsNorthFlat = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.5);
        VoxelShape vsEastFlat = Block.m_49796_((double)13.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsSouthFlat = Block.m_49796_((double)0.0, (double)0.0, (double)13.5, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsWestFlat = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.5, (double)16.0, (double)16.0);
        VoxelShape vsNorthWestCorner = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0);
        VoxelShape vsNorthEastCorner = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
        VoxelShape vsSouthEastCorner = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsSouthWestCorner = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)16.0, (double)16.0);
        VoxelShape vsNorthFlatUp = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)2.5);
        VoxelShape vsEastFlatUp = Block.m_49796_((double)13.5, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
        VoxelShape vsSouthFlatUp = Block.m_49796_((double)0.0, (double)0.0, (double)13.5, (double)16.0, (double)8.0, (double)16.0);
        VoxelShape vsWestFlatUp = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.5, (double)8.0, (double)16.0);
        VoxelShape vsNorthWestCornerUp = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)10.0, (double)3.0);
        VoxelShape vsNorthEastCornerUp = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)3.0);
        VoxelShape vsSouthEastCornerUp = Block.m_49796_((double)13.0, (double)0.0, (double)13.0, (double)16.0, (double)10.0, (double)16.0);
        VoxelShape vsSouthWestCornerUp = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)3.0, (double)10.0, (double)16.0);
        return new VoxelShape[]{vsNorthWestCorner, vsNorthFlat, Shapes.m_83124_((VoxelShape)vsNorthFlat, (VoxelShape[])new VoxelShape[]{vsWestFlat, vsNorthWestCorner}), vsNorthEastCorner, vsEastFlat, Shapes.m_83124_((VoxelShape)vsEastFlat, (VoxelShape[])new VoxelShape[]{vsNorthFlat, vsNorthEastCorner}), vsSouthEastCorner, vsSouthFlat, Shapes.m_83124_((VoxelShape)vsSouthFlat, (VoxelShape[])new VoxelShape[]{vsEastFlat, vsSouthEastCorner}), vsSouthWestCorner, vsWestFlat, Shapes.m_83124_((VoxelShape)vsWestFlat, (VoxelShape[])new VoxelShape[]{vsSouthFlat, vsSouthWestCorner}), vsNorthWestCornerUp, vsNorthFlatUp, Shapes.m_83124_((VoxelShape)vsNorthFlatUp, (VoxelShape[])new VoxelShape[]{vsWestFlatUp, vsNorthWestCornerUp}), vsNorthEastCornerUp, vsEastFlatUp, Shapes.m_83124_((VoxelShape)vsEastFlatUp, (VoxelShape[])new VoxelShape[]{vsNorthFlatUp, vsNorthEastCornerUp}), vsSouthEastCornerUp, vsSouthFlatUp, Shapes.m_83124_((VoxelShape)vsSouthFlatUp, (VoxelShape[])new VoxelShape[]{vsEastFlatUp, vsSouthEastCornerUp}), vsSouthWestCornerUp, vsWestFlatUp, Shapes.m_83124_((VoxelShape)vsWestFlatUp, (VoxelShape[])new VoxelShape[]{vsSouthFlatUp, vsSouthWestCornerUp})};
    }

    protected static VoxelShape[] makeStoneBricksArrowslitShapes() {
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)7.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)9.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)2.0, (double)16.0, (double)14.0), Block.m_49796_((double)14.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)14.0), Block.m_49796_((double)2.0, (double)0.0, (double)13.0, (double)4.5, (double)16.0, (double)14.0), Block.m_49796_((double)11.5, (double)0.0, (double)13.0, (double)14.0, (double)16.0, (double)14.0)})}, new VoxelShape[0]);
    }

    protected static VoxelShape[] makeLimestoneChimneyShapes() {
        return new VoxelShape[]{Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (VoxelShape)Block.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (VoxelShape)Block.m_49796_((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)};
    }

    protected static VoxelShape[] makeStoneBricksChimneyShapes() {
        return new VoxelShape[]{Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (VoxelShape)Block.m_49796_((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), (VoxelShape)Block.m_49796_((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)), Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)};
    }

    protected static VoxelShape[] makeStoneBricksMachicolationShapes() {
        VoxelShape floorVS = Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Shapes.m_83124_((VoxelShape)floorVS, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0), Block.m_49796_((double)10.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)4.0, (double)5.0, (double)6.0, (double)8.0, (double)16.0), Block.m_49796_((double)10.0, (double)4.0, (double)5.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)6.0, (double)4.0, (double)16.0), Block.m_49796_((double)10.0, (double)0.0, (double)11.0, (double)16.0, (double)4.0, (double)16.0)}), Shapes.m_83124_((VoxelShape)floorVS, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)4.0, (double)5.0, (double)6.0, (double)8.0, (double)16.0), Block.m_49796_((double)13.0, (double)4.0, (double)5.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)6.0, (double)4.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)11.0, (double)16.0, (double)4.0, (double)16.0)}), Shapes.m_83124_((VoxelShape)floorVS, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0), Block.m_49796_((double)10.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)4.0, (double)5.0, (double)3.0, (double)8.0, (double)16.0), Block.m_49796_((double)10.0, (double)4.0, (double)5.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)3.0, (double)4.0, (double)16.0), Block.m_49796_((double)10.0, (double)0.0, (double)11.0, (double)16.0, (double)4.0, (double)16.0)}), Shapes.m_83124_((VoxelShape)floorVS, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0), Block.m_49796_((double)13.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)4.0, (double)5.0, (double)3.0, (double)8.0, (double)16.0), Block.m_49796_((double)13.0, (double)4.0, (double)5.0, (double)16.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)11.0, (double)3.0, (double)4.0, (double)16.0), Block.m_49796_((double)13.0, (double)0.0, (double)11.0, (double)16.0, (double)4.0, (double)16.0)})}, new VoxelShape[0]);
    }

    protected static VoxelShape[] makeWaxedOakBalusterShapes() {
        VoxelShape vsNorthFlat = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
        VoxelShape vsEastFlat = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsSouthFlat = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsWestFlat = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0);
        VoxelShape vsNorthWestCorner = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)4.0);
        VoxelShape vsNorthEastCorner = Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)4.0);
        VoxelShape vsSouthEastCorner = Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0);
        VoxelShape vsSouthWestCorner = Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)16.0);
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{vsNorthWestCorner, vsNorthFlat, Shapes.m_83110_((VoxelShape)vsNorthFlat, (VoxelShape)vsWestFlat), vsNorthEastCorner, vsEastFlat, Shapes.m_83110_((VoxelShape)vsEastFlat, (VoxelShape)vsNorthFlat), vsSouthEastCorner, vsSouthFlat, Shapes.m_83110_((VoxelShape)vsSouthFlat, (VoxelShape)vsEastFlat), vsSouthWestCorner, vsWestFlat, Shapes.m_83110_((VoxelShape)vsWestFlat, (VoxelShape)vsSouthFlat)}, new VoxelShape[0]);
    }

    protected static VoxelShape[] makeWaxedOakChairShapes() {
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0), (VoxelShape)Block.m_49796_((double)2.5, (double)11.0, (double)3.0, (double)13.5, (double)16.0, (double)5.0)), Block.m_49796_((double)2.5, (double)0.0, (double)3.0, (double)13.5, (double)10.0, (double)5.0)}, new VoxelShape[0]);
    }

    protected static VoxelShape[] makeCharredSpruceFancyRailingShapes() {
        VoxelShape voxelShape = Block.m_49796_((double)7.0, (double)6.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
        VoxelShape voxelShape1 = Block.m_49796_((double)7.0, (double)6.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
        VoxelShape voxelShape2 = Block.m_49796_((double)7.0, (double)6.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
        VoxelShape voxelShape3 = Block.m_49796_((double)0.0, (double)6.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
        VoxelShape voxelShape4 = Block.m_49796_((double)7.0, (double)6.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
        VoxelShape voxelShape5 = Shapes.m_83110_((VoxelShape)voxelShape1, (VoxelShape)voxelShape4);
        VoxelShape voxelShape6 = Shapes.m_83110_((VoxelShape)voxelShape2, (VoxelShape)voxelShape3);
        VoxelShape[] allVoxelShape = new VoxelShape[]{Shapes.m_83040_(), voxelShape2, voxelShape3, voxelShape6, voxelShape1, Shapes.m_83110_((VoxelShape)voxelShape2, (VoxelShape)voxelShape1), Shapes.m_83110_((VoxelShape)voxelShape3, (VoxelShape)voxelShape1), Shapes.m_83110_((VoxelShape)voxelShape6, (VoxelShape)voxelShape1), voxelShape4, Shapes.m_83110_((VoxelShape)voxelShape2, (VoxelShape)voxelShape4), Shapes.m_83110_((VoxelShape)voxelShape3, (VoxelShape)voxelShape4), Shapes.m_83110_((VoxelShape)voxelShape6, (VoxelShape)voxelShape4), voxelShape5, Shapes.m_83110_((VoxelShape)voxelShape2, (VoxelShape)voxelShape5), Shapes.m_83110_((VoxelShape)voxelShape3, (VoxelShape)voxelShape5), Shapes.m_83110_((VoxelShape)voxelShape6, (VoxelShape)voxelShape5)};
        for (int i = 0; i < 16; ++i) {
            allVoxelShape[i] = Shapes.m_83110_((VoxelShape)voxelShape, (VoxelShape)allVoxelShape[i]);
        }
        return allVoxelShape;
    }

    protected static VoxelShape[] makeCharredSpruceShuttersShapes() {
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)12.0, (double)12.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)9.0, (double)9.0, (double)16.0, (double)13.0, (double)13.0), Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0), Block.m_49796_((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)7.0, (double)7.0)})}, new VoxelShape[0]);
    }

    protected static VoxelShape[] makeCharredSpruceTallShuttersShapes() {
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)10.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)5.0, (double)9.0, (double)16.0, (double)10.0, (double)14.0), Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)5.0, (double)12.0)}), Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)11.0, (double)5.0, (double)16.0, (double)16.0, (double)10.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)6.0, (double)3.0, (double)16.0, (double)11.0, (double)8.0), Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)16.0, (double)6.0, (double)6.0)})}, new VoxelShape[0]);
    }

    protected static VoxelShape[] makeSmallTatamiMatShapes() {
        return new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.m_49796_((double)5.5, (double)0.0, (double)0.0, (double)10.5, (double)5.0, (double)16.0), Block.m_49796_((double)1.5, (double)0.0, (double)0.0, (double)14.5, (double)5.0, (double)16.0), Block.m_49796_((double)1.5, (double)0.0, (double)0.0, (double)14.5, (double)10.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)5.5, (double)16.0, (double)5.0, (double)10.5), Block.m_49796_((double)0.0, (double)0.0, (double)1.5, (double)16.0, (double)5.0, (double)14.5), Block.m_49796_((double)0.0, (double)0.0, (double)1.5, (double)16.0, (double)10.0, (double)14.5), Block.m_49796_((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)16.0, (double)10.5)};
    }

    protected static VoxelShape[] makeMoraqMosaicColumnShapes() {
        return new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), (VoxelShape)Block.m_49796_((double)2.5, (double)6.0, (double)2.5, (double)13.5, (double)16.0, (double)13.5)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)Block.m_49796_((double)2.5, (double)0.0, (double)2.5, (double)13.5, (double)14.0, (double)13.5)), Block.m_49796_((double)2.5, (double)0.0, (double)2.5, (double)13.5, (double)16.0, (double)13.5)};
    }

    protected static VoxelShape[] makeSandstoneCrenelationShapes() {
        VoxelShape vsCrenelation = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)8.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)2.0, (double)0.0, (double)12.0, (double)13.0, (double)8.0), Block.m_49796_((double)6.0, (double)13.0, (double)0.0, (double)10.0, (double)16.0, (double)8.0)});
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)2.0, (double)8.0), vsCrenelation, Shapes.m_83124_((VoxelShape)vsCrenelation, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)2.0, (double)16.0), Block.m_49796_((double)0.0, (double)2.0, (double)4.0, (double)8.0, (double)13.0, (double)12.0), Block.m_49796_((double)0.0, (double)13.0, (double)6.0, (double)8.0, (double)16.0, (double)10.0)})}, new VoxelShape[0]);
    }

    protected static VoxelShape[] makeGreenSculptedPlasteredStoneFriezeShapes() {
        VoxelShape vsQtrN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)8.0);
        VoxelShape vsSpikeN = Block.m_49796_((double)4.5, (double)4.0, (double)2.0, (double)11.5, (double)16.0, (double)4.0);
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)4.0, (double)8.0), (VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)0.0, (double)6.0, (double)16.0, (double)6.0)), Shapes.m_83110_((VoxelShape)vsQtrN, (VoxelShape)vsSpikeN), Shapes.m_83124_((VoxelShape)vsQtrN, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)4.0, (double)16.0), vsSpikeN, Block.m_49796_((double)2.0, (double)4.0, (double)4.5, (double)4.0, (double)16.0, (double)11.5)})}, new VoxelShape[0]);
    }

    protected static VoxelShape[] makePlasteredStoneColumnShapes() {
        return new VoxelShape[]{Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0), (VoxelShape)Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)8.0, (double)13.0)), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), (VoxelShape)Block.m_49796_((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)};
    }

    protected static VoxelShape[] makeRedSculptedPlasteredStoneFriezeShapes() {
        VoxelShape vsQtrN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)8.0);
        VoxelShape vsSpikeN = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)13.0, (double)7.0);
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)4.0, (double)8.0), (VoxelShape)Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)13.0, (double)12.0)), Shapes.m_83110_((VoxelShape)vsQtrN, (VoxelShape)vsSpikeN), Shapes.m_83124_((VoxelShape)vsQtrN, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)4.0, (double)16.0), vsSpikeN, Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)7.0, (double)13.0, (double)12.0)})}, new VoxelShape[0]);
    }

    protected static VoxelShape[] makeSerpentSculptedColumnShapes() {
        VoxelShape vsHead = Block.m_49796_((double)4.0, (double)0.0, (double)6.0, (double)12.0, (double)9.0, (double)16.0);
        VoxelShape vsTail = Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)6.0);
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Shapes.m_83110_((VoxelShape)vsHead, (VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)0.0, (double)11.0, (double)6.0, (double)6.0)), Shapes.m_83110_((VoxelShape)vsTail, (VoxelShape)Block.m_49796_((double)5.0, (double)10.0, (double)6.0, (double)11.0, (double)16.0, (double)15.0)), Shapes.m_83110_((VoxelShape)vsHead, (VoxelShape)vsTail), vsTail}, new VoxelShape[0]);
    }

    protected static VoxelShape[] makeMarbleColumnShapes() {
        return new VoxelShape[]{Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0), Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0), Block.m_49796_((double)4.0, (double)6.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)}), Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)10.0, (double)1.0, (double)14.0, (double)14.0, (double)15.0), Block.m_49796_((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)}), Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)10.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0), Block.m_49796_((double)2.0, (double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)})};
    }

    protected static VoxelShape[] makeMarbleSidedColumnShapes() {
        VoxelShape vsColumn = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0);
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{vsColumn, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)10.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)10.0, (double)0.0, (double)15.0, (double)14.0, (double)6.0), Block.m_49796_((double)2.0, (double)14.0, (double)0.0, (double)14.0, (double)16.0, (double)6.0)}), Shapes.m_83124_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)4.0, (double)6.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)3.0, (double)4.0, (double)0.0, (double)13.0, (double)6.0, (double)5.0), Block.m_49796_((double)4.0, (double)6.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0)}), vsColumn}, new VoxelShape[0]);
    }

    protected static VoxelShape[] makeSandstoneSidedColumnShapes() {
        VoxelShape vsColumn = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0);
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{vsColumn, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)4.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)2.0, (double)8.0, (double)0.0, (double)14.0, (double)12.0, (double)6.0), Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0)}), Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)0.0, (double)14.0, (double)8.0, (double)6.0), (VoxelShape)Block.m_49796_((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)16.0, (double)4.0)), vsColumn}, new VoxelShape[0]);
    }

    protected static VoxelShape[] makeIronColumnShapes() {
        VoxelShape axisY = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
        VoxelShape axisX = Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
        VoxelShape axisZ = Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)16.0);
        VoxelShape axisXZ = Shapes.m_83110_((VoxelShape)axisX, (VoxelShape)axisZ);
        VoxelShape smallNone = Shapes.m_83124_((VoxelShape)axisY, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.m_49796_((double)6.5, (double)15.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5)});
        VoxelShape largeNone = Shapes.m_83124_((VoxelShape)axisY, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0), Block.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0), Block.m_49796_((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)});
        VoxelShape smallUnder = Shapes.m_83110_((VoxelShape)axisY, (VoxelShape)Block.m_49796_((double)6.5, (double)15.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5));
        VoxelShape largeUnder = Shapes.m_83124_((VoxelShape)axisY, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0), Block.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)15.0, (double)10.0), Block.m_49796_((double)4.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0)});
        VoxelShape above = Shapes.m_83124_((VoxelShape)axisY, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)8.0, (double)10.0), Block.m_49796_((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0)});
        VoxelShape both = Shapes.m_83110_((VoxelShape)axisY, (VoxelShape)Block.m_49796_((double)6.5, (double)15.0, (double)6.5, (double)9.5, (double)16.0, (double)9.5));
        return new VoxelShape[]{axisX, axisZ, Shapes.m_83110_((VoxelShape)axisX, (VoxelShape)axisZ), smallNone, largeNone, smallUnder, largeUnder, above, both, Shapes.m_83110_((VoxelShape)axisX, (VoxelShape)smallNone), Shapes.m_83110_((VoxelShape)axisX, (VoxelShape)largeNone), Shapes.m_83110_((VoxelShape)axisX, (VoxelShape)smallUnder), Shapes.m_83110_((VoxelShape)axisX, (VoxelShape)largeUnder), Shapes.m_83110_((VoxelShape)axisX, (VoxelShape)above), Shapes.m_83110_((VoxelShape)axisX, (VoxelShape)both), Shapes.m_83110_((VoxelShape)axisZ, (VoxelShape)smallNone), Shapes.m_83110_((VoxelShape)axisZ, (VoxelShape)largeNone), Shapes.m_83110_((VoxelShape)axisZ, (VoxelShape)smallUnder), Shapes.m_83110_((VoxelShape)axisZ, (VoxelShape)largeUnder), Shapes.m_83110_((VoxelShape)axisZ, (VoxelShape)above), Shapes.m_83110_((VoxelShape)axisZ, (VoxelShape)both), Shapes.m_83110_((VoxelShape)axisXZ, (VoxelShape)smallNone), Shapes.m_83110_((VoxelShape)axisXZ, (VoxelShape)largeNone), Shapes.m_83110_((VoxelShape)axisXZ, (VoxelShape)smallUnder), Shapes.m_83110_((VoxelShape)axisXZ, (VoxelShape)largeUnder), Shapes.m_83110_((VoxelShape)axisXZ, (VoxelShape)above), Shapes.m_83110_((VoxelShape)axisXZ, (VoxelShape)both)};
    }

    protected static VoxelShape[] makeStoneLanternShapes() {
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Shapes.m_83124_((VoxelShape)Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)10.5, (double)11.0), Block.m_49796_((double)7.0, (double)6.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0), Block.m_49796_((double)2.0, (double)7.5, (double)2.0, (double)14.0, (double)9.0, (double)14.0)})}, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)13.5, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0), Block.m_49796_((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)11.5, (double)11.0), Block.m_49796_((double)2.0, (double)8.5, (double)2.0, (double)14.0, (double)10.0, (double)14.0)}), Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)13.5, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)2.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0), Block.m_49796_((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)11.5, (double)11.0), Block.m_49796_((double)2.0, (double)8.5, (double)2.0, (double)14.0, (double)10.0, (double)14.0)}));
    }

    protected static VoxelShape[] makeIronFancyLanternShapes() {
        return VoxelShapesBuilder.generateHorizontalShapes(new VoxelShape[]{Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.0, (double)18.0, (double)7.0, (double)9.0, (double)20.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)17.0, (double)6.0, (double)10.0, (double)18.0, (double)10.0), Block.m_49796_((double)5.0, (double)8.0, (double)5.0, (double)11.0, (double)17.0, (double)11.0), Block.m_49796_((double)6.0, (double)1.0, (double)0.0, (double)10.0, (double)9.0, (double)1.0), Block.m_49796_((double)7.0, (double)7.0, (double)1.0, (double)9.0, (double)8.0, (double)10.0)})}, Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0), Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Block.m_49796_((double)6.5, (double)1.0, (double)6.5, (double)9.5, (double)2.0, (double)9.5)}), Shapes.m_83124_((VoxelShape)Block.m_49796_((double)7.0, (double)12.0, (double)7.0, (double)9.0, (double)14.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0), Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Block.m_49796_((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)2.0, (double)9.5)}));
    }

    public static VoxelShape[] generateWaterJetShapes(VoxelShape centerUp, VoxelShape centerDown, VoxelShape southTop, VoxelShape southBottom, VoxelShape westTop, VoxelShape westBottom, VoxelShape northTop, VoxelShape northBottom, VoxelShape eastTop, VoxelShape eastBottom) {
        int TOTAL = 324;
        VoxelShape[] arr = new VoxelShape[324];
        for (int up = 0; up <= 1; ++up) {
            for (int down = 0; down <= 1; ++down) {
                for (int s = 0; s < 3; ++s) {
                    for (int w = 0; w < 3; ++w) {
                        for (int n = 0; n < 3; ++n) {
                            for (int e = 0; e < 3; ++e) {
                                int ternary = s + 3 * w + 9 * n + 27 * e;
                                int idx = up + (down << 1) + 4 * ternary;
                                VoxelShape shape = Shapes.m_83040_();
                                if (up == 1) {
                                    shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)centerUp);
                                }
                                if (down == 1) {
                                    shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)centerDown);
                                }
                                if (s == 1) {
                                    shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)southTop);
                                } else if (s == 2) {
                                    shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)southBottom);
                                }
                                if (w == 1) {
                                    shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)westTop);
                                } else if (w == 2) {
                                    shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)westBottom);
                                }
                                if (n == 1) {
                                    shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)northTop);
                                } else if (n == 2) {
                                    shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)northBottom);
                                }
                                if (e == 1) {
                                    shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)eastTop);
                                } else if (e == 2) {
                                    shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)eastBottom);
                                }
                                if (shape.m_83281_()) {
                                    shape = Shapes.m_83144_();
                                }
                                arr[idx] = shape;
                            }
                        }
                    }
                }
            }
        }
        return arr;
    }

    public static int encodeWaterJetIndex(boolean up, boolean down, BlockStatePropertiesAA.VerticalLimitedConnection south, BlockStatePropertiesAA.VerticalLimitedConnection west, BlockStatePropertiesAA.VerticalLimitedConnection north, BlockStatePropertiesAA.VerticalLimitedConnection east) {
        int upDown = (up ? 1 : 0) + (down ? 2 : 0);
        int s = VoxelShapesBuilder.toTrit(south);
        int w = VoxelShapesBuilder.toTrit(west);
        int n = VoxelShapesBuilder.toTrit(north);
        int e = VoxelShapesBuilder.toTrit(east);
        int ternary = s + 3 * w + 9 * n + 27 * e;
        return upDown + 4 * ternary;
    }

    private static int toTrit(BlockStatePropertiesAA.VerticalLimitedConnection v) {
        return switch (v) {
            default -> throw new IncompatibleClassChangeError();
            case BlockStatePropertiesAA.VerticalLimitedConnection.NONE -> 0;
            case BlockStatePropertiesAA.VerticalLimitedConnection.TOP -> 1;
            case BlockStatePropertiesAA.VerticalLimitedConnection.BOTTOM -> 2;
        };
    }
}

