/*
 * Decompiled with CFR 0.152.
 */
package com.slaaard.countermod.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.slaaard.countermod.client.GuiCounterSettings;
import com.slaaard.countermod.config.CounterCapability;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="countermod", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientEvents {
    public static final KeyMapping OPEN_MENU_KEY = new KeyMapping("key.countermod.openmenu", 71, "key.categories.countermod");
    private static final int ICON_SIZE = 16;
    private static final int PADDING_ICON_TEXT = 0;
    private static final int PADDING_ELEMENTS = 4;
    private static final int PADDING_BORDER = 5;
    private static final int PADDING_BACKGROUND = 3;
    private static final int PADDING_BACKGROUND_RIGHT_EXTRA = 4;
    private static final ResourceLocation ICON_SUN = ResourceLocation.fromNamespaceAndPath((String)"countermod", (String)"textures/gui/icon_sun.png");
    private static final ResourceLocation ICON_SUNSET = ResourceLocation.fromNamespaceAndPath((String)"countermod", (String)"textures/gui/icon_sunset.png");
    private static final ResourceLocation ICON_MOON = ResourceLocation.fromNamespaceAndPath((String)"countermod", (String)"textures/gui/icon_moon.png");
    private static final IGuiOverlay COUNTER_HUD = (gui, guiGraphics, partialTick, screenWidth, screenHeight) -> {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        CounterCapability.get((Player)mc.f_91074_).ifPresent(data -> {
            int x;
            int width;
            if (!data.isShowOverlay()) {
                return;
            }
            CounterCapability.OverlayPosition position = data.getOverlayPosition();
            boolean horizontalLayout = position.name().contains("HORIZONTAL");
            boolean alignRight = position.name().contains("RIGHT");
            boolean alignBottom = position.name().contains("BOTTOM");
            int currentX = 5;
            int currentY = 5;
            if (horizontalLayout || alignBottom) {
                int totalWidth = 0;
                int totalHeight = 0;
                int elementCount = 0;
                if (data.isShowDays()) {
                    totalWidth += ClientEvents.getElementWidth(mc.f_91062_, String.valueOf(ClientEvents.getDayNumber(mc))) + (elementCount > 0 ? 4 : 0);
                    totalHeight += ClientEvents.getElementHeight() + (elementCount > 0 ? 4 : 0);
                    ++elementCount;
                }
                if (data.isShowDeaths()) {
                    String deathText = String.valueOf(ClientEvents.getDeathCountFromStats(mc));
                    totalWidth += ClientEvents.getElementWidth(mc.f_91062_, deathText) + (elementCount > 0 ? 4 : 0);
                    totalHeight += ClientEvents.getElementHeight() + (elementCount > 0 ? 4 : 0);
                    ++elementCount;
                }
                if (data.isShowTime()) {
                    totalWidth += ClientEvents.getElementWidth(mc.f_91062_, ClientEvents.getGameTime(mc)) + (elementCount > 0 ? 4 : 0);
                    totalHeight += ClientEvents.getElementHeight() + (elementCount > 0 ? 4 : 0);
                }
                if (alignRight && horizontalLayout) {
                    currentX = screenWidth - 5 - totalWidth;
                }
                if (alignBottom) {
                    currentY = horizontalLayout ? screenHeight - 5 - ClientEvents.getElementHeight() : screenHeight - 5 - totalHeight;
                }
            }
            if (data.isShowDays()) {
                String text = String.valueOf(ClientEvents.getDayNumber(mc));
                width = ClientEvents.getElementWidth(mc.f_91062_, text);
                x = alignRight && !horizontalLayout ? screenWidth - 5 - width : currentX;
                ClientEvents.drawElement(guiGraphics, ClientEvents.getDynamicDayIcon(mc), text, x, currentY, ClientEvents.getOverlayBackgroundTexture(data.getOverlayStyle()));
                if (horizontalLayout) {
                    currentX += width + 4;
                } else {
                    currentY += ClientEvents.getElementHeight() + 4;
                }
            }
            if (data.isShowDeaths()) {
                String deathText = String.valueOf(data.getDeathCount());
                width = ClientEvents.getElementWidth(mc.f_91062_, deathText);
                x = alignRight && !horizontalLayout ? screenWidth - 5 - width : currentX;
                ClientEvents.drawElement(guiGraphics, ClientEvents.getDeathIcon(data.getDeathIconStyle()), deathText, x, currentY, ClientEvents.getOverlayBackgroundTexture(data.getOverlayStyle()));
                if (horizontalLayout) {
                    currentX += width + 4;
                } else {
                    currentY += ClientEvents.getElementHeight() + 4;
                }
            }
            if (data.isShowTime()) {
                String text = ClientEvents.getGameTime(mc);
                width = ClientEvents.getElementWidth(mc.f_91062_, text);
                x = alignRight && !horizontalLayout ? screenWidth - 5 - width : currentX;
                ClientEvents.drawElement(guiGraphics, ClientEvents.getTimeIcon(data.getTimeIconStyle()), text, x, currentY, ClientEvents.getOverlayLargeBackgroundTexture(data.getOverlayStyle()));
            }
        });
    };

    @SubscribeEvent
    public static void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(OPEN_MENU_KEY);
    }

    @SubscribeEvent
    public static void onRegisterGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("counter_overlay", COUNTER_HUD);
    }

    private static ResourceLocation getDynamicDayIcon(Minecraft mc) {
        if (mc.f_91073_ == null) {
            return ICON_SUN;
        }
        long timeOfDay = mc.f_91073_.m_46468_() % 24000L;
        if (timeOfDay >= 10000L && timeOfDay < 12500L) {
            return ICON_SUNSET;
        }
        if (timeOfDay >= 12500L && timeOfDay < 23500L) {
            return ICON_MOON;
        }
        return ICON_SUN;
    }

    public static ResourceLocation getOverlayBackgroundTexture(int style) {
        return ResourceLocation.fromNamespaceAndPath((String)"countermod", (String)("textures/gui/overlay_style_" + style + ".png"));
    }

    public static ResourceLocation getOverlayLargeBackgroundTexture(int style) {
        return ResourceLocation.fromNamespaceAndPath((String)"countermod", (String)("textures/gui/overlay_large_style_" + style + ".png"));
    }

    public static ResourceLocation getDeathIcon(int style) {
        return ResourceLocation.fromNamespaceAndPath((String)"countermod", (String)("textures/gui/icon_death_style_" + style + ".png"));
    }

    public static ResourceLocation getTimeIcon(int style) {
        return ResourceLocation.fromNamespaceAndPath((String)"countermod", (String)("textures/gui/icon_time_style_" + style + ".png"));
    }

    private static int getElementWidth(Font font, String text) {
        return 16 + font.m_92895_(text) + 6 + 4;
    }

    private static int getElementHeight() {
        return 22;
    }

    private static int getDeathCountFromStats(Minecraft mc) {
        if (mc.f_91074_ == null) {
            return 0;
        }
        return mc.f_91074_.m_108630_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12935_));
    }

    private static void drawElement(GuiGraphics guiGraphics, ResourceLocation icon, String text, int x, int y, ResourceLocation background) {
        Font font = Minecraft.m_91087_().f_91062_;
        int elementWidth = ClientEvents.getElementWidth(font, text);
        int elementHeight = ClientEvents.getElementHeight();
        RenderSystem.enableBlend();
        guiGraphics.m_280163_(background, x - 3, y - 3, 0.0f, 0.0f, elementWidth, elementHeight, elementWidth, elementHeight);
        guiGraphics.m_280163_(icon, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        Objects.requireNonNull(font);
        guiGraphics.m_280056_(font, text, x + 16 + 0, y + (16 - 9) / 2 + 2, 0xFFFFFF, false);
        RenderSystem.disableBlend();
    }

    public static long getDayNumber(Minecraft mc) {
        return mc.f_91073_ != null ? mc.f_91073_.m_46468_() / 24000L + 1L : 0L;
    }

    public static String getGameTime(Minecraft mc) {
        if (mc.f_91073_ != null) {
            long timeOfDay = mc.f_91073_.m_46468_() % 24000L;
            int hour = (int)((timeOfDay / 1000L + 6L) % 24L);
            int minute = (int)(timeOfDay % 1000L * 60L / 1000L);
            return String.format("%02d:%02d", hour, minute);
        }
        return "00:00";
    }

    @Mod.EventBusSubscriber(modid="countermod", value={Dist.CLIENT})
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            if (OPEN_MENU_KEY.m_90859_()) {
                Minecraft.m_91087_().m_91152_((Screen)new GuiCounterSettings());
            }
        }
    }
}

