/*
 * Decompiled with CFR 0.152.
 */
package com.slaaard.countermod.client;

import com.slaaard.countermod.config.CounterCapability;
import com.slaaard.countermod.core.SoundHandler;
import com.slaaard.countermod.network.C2SUpdateSettingsPacket;
import com.slaaard.countermod.network.PacketHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class GuiCounterSettings
extends Screen {
    public GuiCounterSettings() {
        super((Component)Component.m_237115_((String)"gui.countermod.title"));
    }

    private void handleChange(CounterCapability.CounterData data) {
        this.refreshWidgets();
        PacketHandler.sendToServer(new C2SUpdateSettingsPacket(data));
    }

    protected void m_7856_() {
        super.m_7856_();
        int buttonWidth = 200;
        int buttonHeight = 20;
        int centerX = this.f_96543_ / 2;
        int startY = this.f_96544_ / 4 - 12;
        int spacingY = 24;
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        CounterCapability.get((Player)this.f_96541_.f_91074_).ifPresent(data -> {
            int currentY = startY;
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getLabel("overlay", this.getBooleanText(data.isShowOverlay())), b -> {
                data.setShowOverlay(!data.isShowOverlay());
                this.handleChange((CounterCapability.CounterData)data);
            }).m_252987_(centerX - buttonWidth / 2, currentY, buttonWidth, buttonHeight).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getLabel("days", this.getBooleanText(data.isShowDays())), b -> {
                data.setShowDays(!data.isShowDays());
                this.handleChange((CounterCapability.CounterData)data);
            }).m_252987_(centerX - buttonWidth / 2, currentY += spacingY, buttonWidth, buttonHeight).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getLabel("deaths", this.getBooleanText(data.isShowDeaths())), b -> {
                data.setShowDeaths(!data.isShowDeaths());
                this.handleChange((CounterCapability.CounterData)data);
            }).m_252987_(centerX - buttonWidth / 2, currentY += spacingY, buttonWidth, buttonHeight).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getLabel("time", this.getBooleanText(data.isShowTime())), b -> {
                data.setShowTime(!data.isShowTime());
                this.handleChange((CounterCapability.CounterData)data);
            }).m_252987_(centerX - buttonWidth / 2, currentY += spacingY, buttonWidth, buttonHeight).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getPositionLabel((CounterCapability.CounterData)data), b -> {
                data.cyclePosition();
                this.handleChange((CounterCapability.CounterData)data);
            }).m_252987_(centerX - buttonWidth / 2, currentY += spacingY, buttonWidth, buttonHeight).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getDeathSoundLabel((CounterCapability.CounterData)data), b -> {
                this.cycleDeathSound((CounterCapability.CounterData)data);
                this.handleChange((CounterCapability.CounterData)data);
            }).m_252987_(centerX - buttonWidth / 2, currentY += spacingY, buttonWidth, buttonHeight).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)this.getDeathSoundVolumeLabel((CounterCapability.CounterData)data), b -> {
                this.cycleVolume((CounterCapability.CounterData)data);
                this.handleChange((CounterCapability.CounterData)data);
            }).m_252987_(centerX - buttonWidth / 2, currentY += spacingY, buttonWidth, buttonHeight).m_253136_());
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.countermod.close"), b -> this.f_96541_.m_91152_(null)).m_252987_(centerX - buttonWidth / 2, currentY += spacingY + spacingY / 2, buttonWidth, buttonHeight).m_253136_());
        });
    }

    private void refreshWidgets() {
        this.m_169413_();
        this.m_7856_();
    }

    private void cycleDeathSound(CounterCapability.CounterData data) {
        int totalOptions = SoundHandler.DEATH_SOUNDS.size() + 2;
        data.setSelectedSoundIndex((data.getSelectedSoundIndex() + 1) % totalOptions);
    }

    private void cycleVolume(CounterCapability.CounterData data) {
        float currentVolume = data.getDeathSoundVolume();
        if ((currentVolume += 0.25f) > 1.01f) {
            currentVolume = 0.0f;
        }
        data.setDeathSoundVolume(Mth.m_14036_((float)currentVolume, (float)0.0f, (float)1.0f));
    }

    private Component getBooleanText(boolean value) {
        return Component.m_237115_((String)(value ? "gui.countermod.on" : "gui.countermod.off"));
    }

    private Component getLabel(String key, Component value) {
        return Component.m_237115_((String)("gui.countermod." + key)).m_130946_(": ").m_7220_(value);
    }

    private Component getPositionLabel(CounterCapability.CounterData data) {
        return this.getLabel("position", (Component)Component.m_237115_((String)("overlay.position." + data.getOverlayPosition().name())));
    }

    private Component getStyleLabel(String key, int value) {
        return Component.m_237115_((String)("gui.countermod." + key)).m_130946_(": " + value);
    }

    private Component getDeathSoundLabel(CounterCapability.CounterData data) {
        MutableComponent baseText = Component.m_237115_((String)"gui.countermod.deathsound");
        int totalSounds = SoundHandler.DEATH_SOUNDS.size();
        int index = data.getSelectedSoundIndex();
        if (index == 0) {
            return baseText.m_6881_().m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"gui.countermod.off"));
        }
        if (index > totalSounds) {
            return baseText.m_6881_().m_130946_(": ").m_7220_((Component)Component.m_237115_((String)"gui.countermod.random"));
        }
        String soundPath = ((SoundEvent)SoundHandler.DEATH_SOUNDS.get(index - 1).get()).m_11660_().m_135815_();
        Object displayName = soundPath.replace("death_sound_", "").replace("_", " ");
        displayName = ((String)displayName).substring(0, 1).toUpperCase() + ((String)displayName).substring(1);
        return baseText.m_6881_().m_130946_(": ").m_130946_((String)displayName);
    }

    private Component getDeathSoundVolumeLabel(CounterCapability.CounterData data) {
        return Component.m_237115_((String)"gui.countermod.deathsound.volume").m_130946_(": " + (int)(data.getDeathSoundVolume() * 100.0f) + "%");
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 20, 0xFFFFFF);
    }

    public boolean m_7043_() {
        return false;
    }
}

