/*
 * Decompiled with CFR 0.152.
 */
package com.slaaard.countermod.config;

import com.slaaard.countermod.core.SoundHandler;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CounterCapability {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"countermod", (String)"player_counter_data");
    public static final Capability<CounterData> PLAYER_COUNTER_DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<CounterData>(){});

    public static LazyOptional<CounterData> get(Player player) {
        return player.getCapability(PLAYER_COUNTER_DATA);
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundTag> {
        private final CounterData data = new CounterData();
        private final LazyOptional<CounterData> optional = LazyOptional.of(() -> this.data);

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return cap == PLAYER_COUNTER_DATA ? this.optional.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            this.data.saveNBT(nbt);
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.data.loadNBT(nbt);
        }
    }

    public static class CounterData {
        private boolean showOverlay = true;
        private boolean showDays = true;
        private boolean showDeaths = true;
        private boolean showTime = true;
        private OverlayPosition overlayPosition = OverlayPosition.TOP_LEFT;
        private int selectedSoundIndex = -1;
        private float deathSoundVolume = 1.0f;
        private int overlayStyle = 1;
        private int deathIconStyle = 1;
        private int timeIconStyle = 1;
        private int deathCount = 0;

        public boolean isShowOverlay() {
            return this.showOverlay;
        }

        public boolean isShowDays() {
            return this.showDays;
        }

        public boolean isShowDeaths() {
            return this.showDeaths;
        }

        public boolean isShowTime() {
            return this.showTime;
        }

        public OverlayPosition getOverlayPosition() {
            return this.overlayPosition;
        }

        public int getSelectedSoundIndex() {
            if (this.selectedSoundIndex == -1) {
                this.selectedSoundIndex = SoundHandler.DEATH_SOUNDS.size() + 1;
            }
            return this.selectedSoundIndex;
        }

        public float getDeathSoundVolume() {
            return this.deathSoundVolume;
        }

        public int getOverlayStyle() {
            return this.overlayStyle;
        }

        public int getDeathIconStyle() {
            return this.deathIconStyle;
        }

        public int getTimeIconStyle() {
            return this.timeIconStyle;
        }

        public int getDeathCount() {
            return this.deathCount;
        }

        public void setDeathCount(int count) {
            this.deathCount = count;
        }

        public void incrementDeaths() {
            ++this.deathCount;
        }

        public void setShowOverlay(boolean showOverlay) {
            this.showOverlay = showOverlay;
        }

        public void setShowDays(boolean showDays) {
            this.showDays = showDays;
        }

        public void setShowDeaths(boolean showDeaths) {
            this.showDeaths = showDeaths;
        }

        public void setShowTime(boolean showTime) {
            this.showTime = showTime;
        }

        public void setOverlayPosition(OverlayPosition overlayPosition) {
            this.overlayPosition = overlayPosition;
        }

        public void setSelectedSoundIndex(int selectedSoundIndex) {
            this.selectedSoundIndex = selectedSoundIndex;
        }

        public void setDeathSoundVolume(float deathSoundVolume) {
            this.deathSoundVolume = deathSoundVolume;
        }

        public void setOverlayStyle(int overlayStyle) {
            this.overlayStyle = overlayStyle;
        }

        public void setDeathIconStyle(int deathIconStyle) {
            this.deathIconStyle = deathIconStyle;
        }

        public void setTimeIconStyle(int timeIconStyle) {
            this.timeIconStyle = timeIconStyle;
        }

        public void cyclePosition() {
            int nextOrdinal = (this.overlayPosition.ordinal() + 1) % OverlayPosition.values().length;
            this.overlayPosition = OverlayPosition.values()[nextOrdinal];
        }

        public void saveNBT(CompoundTag nbt) {
            nbt.m_128405_("deathCount", this.deathCount);
            nbt.m_128379_("showOverlay", this.showOverlay);
            nbt.m_128379_("showDays", this.showDays);
            nbt.m_128379_("showTime", this.showTime);
            nbt.m_128379_("showDeaths", this.showDeaths);
            nbt.m_128405_("overlayPosition", this.overlayPosition.ordinal());
            nbt.m_128405_("selectedSoundIndex", this.getSelectedSoundIndex());
            nbt.m_128350_("deathSoundVolume", this.deathSoundVolume);
            nbt.m_128405_("overlayStyle", this.overlayStyle);
            nbt.m_128405_("deathIconStyle", this.deathIconStyle);
            nbt.m_128405_("timeIconStyle", this.timeIconStyle);
        }

        public void loadNBT(CompoundTag nbt) {
            if (nbt.m_128441_("deathCount")) {
                this.deathCount = nbt.m_128451_("deathCount");
            }
            if (nbt.m_128441_("showOverlay")) {
                this.showOverlay = nbt.m_128471_("showOverlay");
            }
            if (nbt.m_128441_("showDays")) {
                this.showDays = nbt.m_128471_("showDays");
            }
            if (nbt.m_128441_("showTime")) {
                this.showTime = nbt.m_128471_("showTime");
            }
            if (nbt.m_128441_("showDeaths")) {
                this.showDeaths = nbt.m_128471_("showDeaths");
            }
            if (nbt.m_128441_("overlayPosition")) {
                this.overlayPosition = OverlayPosition.values()[nbt.m_128451_("overlayPosition")];
            }
            if (nbt.m_128441_("selectedSoundIndex")) {
                this.selectedSoundIndex = nbt.m_128451_("selectedSoundIndex");
            }
            if (nbt.m_128441_("deathSoundVolume")) {
                this.deathSoundVolume = nbt.m_128457_("deathSoundVolume");
            }
            if (nbt.m_128441_("overlayStyle")) {
                this.overlayStyle = nbt.m_128451_("overlayStyle");
            }
            if (nbt.m_128441_("deathIconStyle")) {
                this.deathIconStyle = nbt.m_128451_("deathIconStyle");
            }
            if (nbt.m_128441_("timeIconStyle")) {
                this.timeIconStyle = nbt.m_128451_("timeIconStyle");
            }
        }
    }

    public static enum OverlayPosition {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP_LEFT_HORIZONTAL,
        TOP_RIGHT_HORIZONTAL,
        BOTTOM_LEFT_HORIZONTAL,
        BOTTOM_RIGHT_HORIZONTAL;

    }
}

