/*
 * Decompiled with CFR 0.152.
 */
package com.slaaard.countermod.core;

import com.slaaard.countermod.config.CounterCapability;
import com.slaaard.countermod.core.SoundHandler;
import com.slaaard.countermod.network.PacketHandler;
import com.slaaard.countermod.network.S2CSyncDataPacket;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    public static final String COUNTER_NBT_KEY = "countermod.data";
    private static final RandomSource random = RandomSource.m_216327_();

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(CounterCapability.ID, (ICapabilityProvider)new CounterCapability.Provider());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        if (!event.isWasDeath() && event.getOriginal().m_9236_().m_46472_() != Level.f_46430_) {
            return;
        }
        CompoundTag originalPersistentData = event.getOriginal().getPersistentData();
        event.getEntity().getPersistentData().m_128391_(originalPersistentData);
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.syncDataToClient(player2);
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.syncDataToClient(player2);
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.syncDataToClient(player2);
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            this.syncDataToClient(player2);
        }
    }

    private void syncDataToClient(ServerPlayer player) {
        player.getCapability(CounterCapability.PLAYER_COUNTER_DATA).ifPresent(cap -> {
            CompoundTag persistentData = player.getPersistentData();
            if (persistentData.m_128441_(COUNTER_NBT_KEY)) {
                cap.loadNBT(persistentData.m_128469_(COUNTER_NBT_KEY));
            }
            CompoundTag nbtToSend = new CompoundTag();
            cap.saveNBT(nbtToSend);
            PacketHandler.sendToPlayer(new S2CSyncDataPacket(nbtToSend), player);
        });
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            player.getCapability(CounterCapability.PLAYER_COUNTER_DATA).ifPresent(data -> {
                data.incrementDeaths();
                CompoundTag updatedNbt = new CompoundTag();
                data.saveNBT(updatedNbt);
                player.getPersistentData().m_128365_(COUNTER_NBT_KEY, (Tag)updatedNbt);
                this.playSoundOnDeath((Player)player, (CounterCapability.CounterData)data);
            });
        }
    }

    private void playSoundOnDeath(Player player, CounterCapability.CounterData data) {
        if (data.getSelectedSoundIndex() == 0 || SoundHandler.DEATH_SOUNDS.isEmpty()) {
            return;
        }
        int soundIndex = data.getSelectedSoundIndex() - 1;
        Level level = player.m_9236_();
        if (soundIndex >= 0 && soundIndex < SoundHandler.DEATH_SOUNDS.size()) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundHandler.DEATH_SOUNDS.get(soundIndex).get(), SoundSource.PLAYERS, data.getDeathSoundVolume(), 1.0f);
        } else {
            int randomIndex = random.m_188503_(SoundHandler.DEATH_SOUNDS.size());
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)SoundHandler.DEATH_SOUNDS.get(randomIndex).get(), SoundSource.PLAYERS, data.getDeathSoundVolume(), 1.0f);
        }
    }
}

