/*
 * Decompiled with CFR 0.152.
 */
package com.slaaard.countermod.network;

import com.slaaard.countermod.config.CounterCapability;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class C2SUpdateSettingsPacket {
    private final CompoundTag nbt;

    public C2SUpdateSettingsPacket(CounterCapability.CounterData data) {
        this.nbt = new CompoundTag();
        data.saveNBT(this.nbt);
    }

    private C2SUpdateSettingsPacket(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public static void encode(C2SUpdateSettingsPacket msg, FriendlyByteBuf buf) {
        buf.m_130079_(msg.nbt);
    }

    public static C2SUpdateSettingsPacket decode(FriendlyByteBuf buf) {
        return new C2SUpdateSettingsPacket(buf.m_130260_());
    }

    public static void handle(C2SUpdateSettingsPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                player.getCapability(CounterCapability.PLAYER_COUNTER_DATA).ifPresent(data -> data.loadNBT(msg.nbt));
                player.getPersistentData().m_128365_("countermod.data", (Tag)msg.nbt);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

