/*
 * Decompiled with CFR 0.152.
 */
package com.slaaard.countermod.network;

import com.slaaard.countermod.config.CounterCapability;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class S2CSyncDataPacket {
    private final CompoundTag nbt;

    public S2CSyncDataPacket(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public static void encode(S2CSyncDataPacket msg, FriendlyByteBuf buf) {
        buf.m_130079_(msg.nbt);
    }

    public static S2CSyncDataPacket decode(FriendlyByteBuf buf) {
        return new S2CSyncDataPacket(buf.m_130260_());
    }

    public static void handle(S2CSyncDataPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ClientProxy.handleDataSync(msg.nbt));
        ctx.get().setPacketHandled(true);
    }

    public static class ClientProxy {
        static void handleDataSync(CompoundTag nbt) {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null) {
                mc.f_91074_.getCapability(CounterCapability.PLAYER_COUNTER_DATA).ifPresent(data -> data.loadNBT(nbt));
            }
        }
    }
}

