/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonskull.rodsawaken.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.thedragonskull.rodsawaken.block.entity.AwakenedEndRodBE;
import org.jetbrains.annotations.Nullable;

public class AwakenedEndRod
extends EndRodBlock
implements EntityBlock {
    public static final BooleanProperty LIT = BooleanProperty.create((String)"lit");

    public AwakenedEndRod(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.TRUE)).setValue((Property)FACING, (Comparable)Direction.UP));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LIT, FACING});
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            return;
        }
        BlockEntity be = pLevel.getBlockEntity(pPos);
        for (int i = 0; i < 3; ++i) {
            AwakenedEndRodBE rodBE;
            if (!(be instanceof AwakenedEndRodBE) || !(rodBE = (AwakenedEndRodBE)be).hasEffectInSlot(i)) continue;
            return;
        }
        super.animateTick(pState, pLevel, pPos, pRandom);
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide) {
            BlockEntity be = level.getBlockEntity(pos);
            if (player.isSecondaryUseActive()) {
                AwakenedEndRodBE rod;
                boolean lit = (Boolean)state.getValue((Property)LIT);
                boolean newLit = !lit;
                level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(newLit)), 3);
                if (lit) {
                    level.playSound(null, pos, SoundEvents.BEACON_DEACTIVATE, SoundSource.BLOCKS, 0.75f, 1.0f);
                } else {
                    level.playSound(null, pos, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 0.75f, 1.0f);
                }
                if (be instanceof AwakenedEndRodBE && (rod = (AwakenedEndRodBE)be).isAutoMode()) {
                    boolean playerNearbyNow = !level.getEntitiesOfClass(Player.class, new AABB(pos).inflate(4.0)).isEmpty();
                    rod.setManualOverride(true);
                    rod.setForcedLitState(newLit);
                    rod.setManualOverrideTriggerPlayerNearby(playerNearbyNow);
                }
            } else if (be instanceof AwakenedEndRodBE) {
                AwakenedEndRodBE rodBE = (AwakenedEndRodBE)be;
                ((ServerPlayer)player).openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)rodBE, (Component)Component.literal((String)"Awakened End Rod")), pos);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.is(newState.getBlock())) {
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof AwakenedEndRodBE) {
                AwakenedEndRodBE awakened = (AwakenedEndRodBE)be;
                Containers.dropContents((Level)level, (BlockPos)pos, (Container)awakened.asContainer());
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new AwakenedEndRodBE(pPos, pState);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        return level.isClientSide ? null : (lvl, pos, st, be) -> {
            if (be instanceof AwakenedEndRodBE) {
                AwakenedEndRodBE rod = (AwakenedEndRodBE)be;
                rod.tick();
            }
        };
    }
}

