/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonskull.rodsawaken.block.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.thedragonskull.rodsawaken.block.custom.AwakenedEndRod;
import net.thedragonskull.rodsawaken.block.entity.ModBlockEntities;
import net.thedragonskull.rodsawaken.particle.ModParticles;
import net.thedragonskull.rodsawaken.screen.AwakenedEndRodMenu;
import org.jetbrains.annotations.NotNull;

public class AwakenedEndRodBE
extends BlockEntity
implements MenuProvider {
    private boolean autoMode = false;
    private boolean manualOverride = false;
    private boolean manualOverrideTriggerPlayerNearby = false;
    private boolean forcedLitState = false;
    private final int[] potionDurations = new int[3];
    private final int[] potionTimers = new int[3];
    private final int[] potionColors = new int[3];
    private final List<MobEffectInstance>[] potionEffects = new List[3];
    private final boolean[] blockedSlots = new boolean[3];
    private final ItemStackHandler items = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            ItemStack stack;
            super.onContentsChanged(slot);
            if (slot >= 0 && slot <= 2 && !(stack = AwakenedEndRodBE.this.items.getStackInSlot(slot)).isEmpty() && stack.getItem() == Items.POTION) {
                AwakenedEndRodBE.this.consumePotionIntoSlot(slot, stack);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (stack.isEmpty()) {
                return false;
            }
            if (slot >= 0 && slot <= 2) {
                if (!AwakenedEndRodBE.this.potionEffects[slot].isEmpty() || AwakenedEndRodBE.this.isSlotBlocked(slot)) {
                    return false;
                }
                if (stack.getItem() == Items.POTION) {
                    PotionContents potioncontents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
                    if (potioncontents != null) {
                        for (MobEffectInstance effect : potioncontents.getAllEffects()) {
                            if (!((MobEffect)effect.getEffect().value()).isInstantenous()) continue;
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
            if (slot == 3) {
                BlockItem blockItem;
                Item item = stack.getItem();
                return item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof SculkSensorBlock;
            }
            return false;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    public final IItemHandler hopperItemHandler = new IItemHandler(){

        public int getSlots() {
            return 3;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return AwakenedEndRodBE.this.items.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return AwakenedEndRodBE.this.items.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return AwakenedEndRodBE.this.items.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return AwakenedEndRodBE.this.items.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return AwakenedEndRodBE.this.items.isItemValid(slot, stack);
        }
    };

    public AwakenedEndRodBE(BlockPos pPos, BlockState pBlockState) {
        super(ModBlockEntities.AWAKENED_END_ROD_BE.get(), pPos, pBlockState);
        for (int i = 0; i < 3; ++i) {
            this.potionEffects[i] = new ArrayList<MobEffectInstance>();
        }
    }

    public void tick() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.handleSculkAutoMode();
        boolean changed = false;
        boolean lit = (Boolean)this.getBlockState().getValue((Property)AwakenedEndRod.LIT);
        if (lit) {
            for (int i = 0; i < 3; ++i) {
                if (this.potionTimers[i] <= 0) continue;
                int n = i;
                this.potionTimers[n] = this.potionTimers[n] - 1;
                if (this.potionTimers[i] == 0) {
                    this.potionDurations[i] = 0;
                    this.potionColors[i] = 0;
                    this.potionEffects[i].clear();
                    this.level.playSound(null, this.worldPosition, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 1.0f);
                }
                changed = true;
                if (this.level == null) continue;
                BlockState state = this.getBlockState();
                this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
            }
        }
        if (changed) {
            this.setChanged();
            BlockState state = this.getBlockState();
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
        if (lit) {
            if (this.level.getGameTime() % 2L == 0L) {
                boolean anyEffect = false;
                for (int i = 0; i < 3; ++i) {
                    if (!this.hasEffectInSlot(i)) continue;
                    anyEffect = true;
                    break;
                }
                if (!anyEffect) {
                    return;
                }
                double x = (double)this.worldPosition.getX() + 0.5;
                double y = (double)this.worldPosition.getY() + 0.5;
                double z = (double)this.worldPosition.getZ() + 0.5;
                ((ServerLevel)this.level).sendParticles((ParticleOptions)ModParticles.AWAKENED_END_ROD_GLITTER.get(), x, y, z, 2, 0.1, 0.25, 0.1, 0.2);
            }
            if (this.level.getGameTime() % 80L == 0L) {
                this.level.playSound(null, this.worldPosition, SoundEvents.BEACON_AMBIENT, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            this.applyEffectsToNearby();
        }
    }

    private void applyEffectsToNearby() {
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        AABB area = new AABB(this.worldPosition).inflate(5.0);
        List targets = serverLevel.getEntitiesOfClass(LivingEntity.class, area, LivingEntity::isAlive);
        int refreshInterval = 40;
        HashMap<Holder, Integer> mergedLevels = new HashMap<Holder, Integer>();
        for (int i = 0; i < 3; ++i) {
            if (this.potionTimers[i] <= 0 || this.potionEffects[i].isEmpty()) continue;
            for (MobEffectInstance effect : this.potionEffects[i]) {
                Holder mob2 = effect.getEffect();
                if (((MobEffect)mob2.value()).isInstantenous()) continue;
                int levelValue = effect.getAmplifier() + 1;
                mergedLevels.merge(mob2, levelValue, Integer::sum);
            }
        }
        mergedLevels.replaceAll((mob, lvl) -> Math.min(lvl, 6));
        for (LivingEntity target : targets) {
            for (Map.Entry entry : mergedLevels.entrySet()) {
                Holder mob3 = (Holder)entry.getKey();
                int levelValue = (Integer)entry.getValue();
                int amplifier = levelValue - 1;
                MobEffectInstance current = target.getEffect(mob3);
                boolean shouldApply = false;
                if (current == null) {
                    shouldApply = true;
                } else if (current.getAmplifier() < amplifier) {
                    shouldApply = true;
                } else if (current.getDuration() <= refreshInterval / 2) {
                    shouldApply = true;
                }
                if (!shouldApply) continue;
                int applyDuration = refreshInterval;
                MobEffectInstance toApply = new MobEffectInstance(mob3, applyDuration, amplifier, false, true, true);
                target.addEffect(toApply);
            }
        }
    }

    private void handleSculkAutoMode() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        boolean hasNormal = this.hasNormalSculk();
        boolean hasCalibrated = this.hasCalibratedSculk();
        if (!hasNormal && !hasCalibrated) {
            this.autoMode = false;
            this.manualOverride = false;
            return;
        }
        this.autoMode = true;
        AABB area = new AABB(this.worldPosition).inflate(4.0);
        boolean entityNearby = hasCalibrated ? !this.level.getEntitiesOfClass(LivingEntity.class, area, LivingEntity::isAlive).isEmpty() : !this.level.getEntitiesOfClass(Player.class, area).isEmpty();
        BlockState state = this.getBlockState();
        boolean lit = (Boolean)state.getValue((Property)AwakenedEndRod.LIT);
        if (this.manualOverride) {
            if ((Boolean)state.getValue((Property)AwakenedEndRod.LIT) != this.forcedLitState) {
                this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)AwakenedEndRod.LIT, (Comparable)Boolean.valueOf(this.forcedLitState)), 3);
            }
            if (entityNearby != this.manualOverrideTriggerPlayerNearby) {
                this.manualOverride = false;
            }
            return;
        }
        if (entityNearby && !lit) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)AwakenedEndRod.LIT, (Comparable)Boolean.valueOf(true)), 3);
            this.level.playSound(null, this.worldPosition, SoundEvents.BEACON_ACTIVATE, SoundSource.BLOCKS, 0.75f, 1.0f);
        } else if (!entityNearby && lit) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)AwakenedEndRod.LIT, (Comparable)Boolean.valueOf(false)), 3);
            this.level.playSound(null, this.worldPosition, SoundEvents.BEACON_DEACTIVATE, SoundSource.BLOCKS, 0.75f, 1.0f);
        }
        if (!lit && !entityNearby) {
            double x = (double)this.worldPosition.getX() + 0.5;
            double y = (double)this.worldPosition.getY() + 0.5;
            double z = (double)this.worldPosition.getZ() + 0.5;
            ((ServerLevel)this.level).sendParticles((ParticleOptions)ParticleTypes.SCULK_CHARGE_POP, x, y, z, 1, 0.1, 0.25, 0.1, 0.0);
        }
    }

    public boolean isAutoMode() {
        return this.autoMode;
    }

    public void setManualOverride(boolean manualOverride) {
        this.manualOverride = manualOverride;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void setManualOverrideTriggerPlayerNearby(boolean trigger) {
        this.manualOverrideTriggerPlayerNearby = trigger;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void setForcedLitState(boolean forced) {
        this.forcedLitState = forced;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void syncToClient() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public boolean isSlotBlocked(int slot) {
        return this.blockedSlots[slot];
    }

    public void toggleBlocked(int slot) {
        this.blockedSlots[slot] = !this.blockedSlots[slot];
        this.setChanged();
    }

    public void setBlocked(int slot, boolean blocked) {
        this.blockedSlots[slot] = blocked;
        this.setChanged();
    }

    private boolean hasNormalSculk() {
        ItemStack stack = this.items.getStackInSlot(3);
        return !stack.isEmpty() && stack.is(Items.SCULK_SENSOR);
    }

    private boolean hasCalibratedSculk() {
        ItemStack stack = this.items.getStackInSlot(3);
        return !stack.isEmpty() && stack.is(Items.CALIBRATED_SCULK_SENSOR);
    }

    public int getPotionColor(int slot) {
        return this.potionColors[slot];
    }

    public float getPotionProgress(int slot) {
        if (this.potionDurations[slot] == 0) {
            return 0.0f;
        }
        return (float)this.potionTimers[slot] / (float)this.potionDurations[slot];
    }

    public int getPotionTimeLeft(int slot) {
        return this.potionTimers[slot];
    }

    public List<MobEffectInstance> getPotionEffects(int slot) {
        return this.potionEffects[slot];
    }

    public boolean hasEffectInSlot(int slot) {
        return this.potionTimers[slot] > 0 && !this.potionEffects[slot].isEmpty();
    }

    public int getCombinedPotionColor() {
        int r = 0;
        int g = 0;
        int b = 0;
        int count = 0;
        for (int i = 0; i < 3; ++i) {
            int color = this.potionColors[i];
            if (color == 0) continue;
            r += color >> 16 & 0xFF;
            g += color >> 8 & 0xFF;
            b += color & 0xFF;
            ++count;
        }
        if (count == 0) {
            return -1;
        }
        return (r /= count) << 16 | (g /= count) << 8 | (b /= count);
    }

    public void clearPotionSlot(int slot) {
        this.potionEffects[slot].clear();
        this.potionDurations[slot] = 0;
        this.potionTimers[slot] = 0;
        this.potionColors[slot] = 0;
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            BlockState state = this.getBlockState();
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    private void consumePotionIntoSlot(int slot, ItemStack stack) {
        if (stack.isEmpty() || stack.getItem() != Items.POTION) {
            return;
        }
        PotionContents potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        if (potionContents == null) {
            return;
        }
        Iterable effectsIterable = potionContents.getAllEffects();
        this.potionEffects[slot].clear();
        for (MobEffectInstance eff : effectsIterable) {
            this.potionEffects[slot].add(eff);
        }
        int maxDuration = 0;
        for (MobEffectInstance eff : effectsIterable) {
            maxDuration = Math.max(maxDuration, eff.getDuration());
        }
        this.potionDurations[slot] = maxDuration;
        this.potionTimers[slot] = maxDuration;
        this.potionColors[slot] = potionContents.getColor();
        stack.shrink(1);
        if (this.level != null) {
            this.level.playSound(null, this.worldPosition, SoundEvents.BOTTLE_EMPTY, SoundSource.BLOCKS);
            this.level.playSound(null, this.worldPosition, SoundEvents.ENDER_EYE_DEATH, SoundSource.BLOCKS);
        }
        if (stack.isEmpty()) {
            this.items.setStackInSlot(slot, new ItemStack((ItemLike)Items.GLASS_BOTTLE));
        } else {
            this.items.setStackInSlot(slot, stack);
        }
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        int i;
        super.saveAdditional(tag, pRegistries);
        tag.put("Inventory", (Tag)this.items.serializeNBT(pRegistries));
        tag.putBoolean("AutoMode", this.autoMode);
        tag.putBoolean("ManualOverride", this.manualOverride);
        tag.putBoolean("ManualOverrideTriggerPlayerNearby", this.manualOverrideTriggerPlayerNearby);
        tag.putBoolean("ForcedLitState", this.forcedLitState);
        tag.putIntArray("PotionDurations", this.potionDurations);
        tag.putIntArray("PotionTimers", this.potionTimers);
        tag.putIntArray("PotionColors", this.potionColors);
        int[] blocked = new int[this.blockedSlots.length];
        for (i = 0; i < this.blockedSlots.length; ++i) {
            blocked[i] = this.blockedSlots[i] ? 1 : 0;
        }
        tag.putIntArray("BlockedSlots", blocked);
        for (i = 0; i < this.potionEffects.length; ++i) {
            ListTag listTag = new ListTag();
            for (MobEffectInstance effect : this.potionEffects[i]) {
                listTag.add((Object)effect.save());
            }
            tag.put("PotionEffects" + i, (Tag)listTag);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        int i;
        super.loadAdditional(tag, pRegistries);
        this.items.deserializeNBT(pRegistries, tag.getCompound("Inventory"));
        this.autoMode = tag.getBoolean("AutoMode");
        this.manualOverride = tag.getBoolean("ManualOverride");
        this.manualOverrideTriggerPlayerNearby = tag.getBoolean("ManualOverrideTriggerPlayerNearby");
        this.forcedLitState = tag.getBoolean("ForcedLitState");
        int[] d = tag.getIntArray("PotionDurations");
        int[] t = tag.getIntArray("PotionTimers");
        int[] c = tag.getIntArray("PotionColors");
        System.arraycopy(d, 0, this.potionDurations, 0, Math.min(d.length, this.potionDurations.length));
        System.arraycopy(t, 0, this.potionTimers, 0, Math.min(t.length, this.potionTimers.length));
        System.arraycopy(c, 0, this.potionColors, 0, Math.min(c.length, this.potionColors.length));
        int[] blocked = tag.getIntArray("BlockedSlots");
        for (i = 0; i < this.blockedSlots.length && i < blocked.length; ++i) {
            this.blockedSlots[i] = blocked[i] == 1;
        }
        for (i = 0; i < this.potionEffects.length; ++i) {
            this.potionEffects[i].clear();
            ListTag listTag = tag.getList("PotionEffects" + i, 10);
            for (int j = 0; j < listTag.size(); ++j) {
                CompoundTag effectTag = listTag.getCompound(j);
                MobEffectInstance effect = MobEffectInstance.load((CompoundTag)effectTag);
                if (effect == null) continue;
                this.potionEffects[i].add(effect);
            }
        }
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        super.onDataPacket(net, pkt, pRegistries);
        if (this.level != null && this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @NotNull
    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, pRegistries);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider holders) {
        this.loadAdditional(tag, holders);
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
            this.level.setBlocksDirty(this.worldPosition, this.getBlockState(), this.getBlockState());
        }
    }

    public ItemStackHandler getItems() {
        return this.items;
    }

    public Container asContainer() {
        SimpleContainer container = new SimpleContainer(this.items.getSlots());
        for (int i = 0; i < this.items.getSlots(); ++i) {
            container.setItem(i, this.items.getStackInSlot(i));
        }
        return container;
    }

    public Component getDisplayName() {
        return Component.literal((String)"Awakened End Rod");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInv, Player player) {
        return new AwakenedEndRodMenu(id, playerInv, this);
    }
}

