/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonskull.rodsawaken.screen;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.thedragonskull.rodsawaken.block.ModBlocks;
import net.thedragonskull.rodsawaken.block.entity.AwakenedEndRodBE;
import net.thedragonskull.rodsawaken.screen.ModMenuTypes;

public class AwakenedEndRodMenu
extends AbstractContainerMenu {
    private final AwakenedEndRodBE blockEntity;
    private final ContainerLevelAccess access;

    public AwakenedEndRodMenu(int id, Inventory playerInv, AwakenedEndRodBE blockEntity) {
        super(ModMenuTypes.AWAKENED_END_ROD_MENU.get(), id);
        this.blockEntity = blockEntity;
        this.access = ContainerLevelAccess.create((Level)Objects.requireNonNull(blockEntity.getLevel()), (BlockPos)blockEntity.getBlockPos());
        ItemStackHandler handler = blockEntity.getItems();
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 0, 31, 42));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 1, 65, 42));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 2, 99, 42));
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)handler, 3, 129, 30));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInv, col, 8 + col * 18, 142));
        }
    }

    public AwakenedEndRodMenu(int id, Inventory playerInv, FriendlyByteBuf buf) {
        this(id, playerInv, (AwakenedEndRodBE)playerInv.player.level().getBlockEntity(buf.readBlockPos()));
    }

    public boolean stillValid(Player player) {
        return AwakenedEndRodMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)ModBlocks.AWAKENED_END_ROD.get()));
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack stackInSlot = slot.getItem();
            itemstack = stackInSlot.copy();
            int containerSlots = 4;
            if (index < containerSlots ? !this.moveItemStackTo(stackInSlot, containerSlots, this.slots.size(), true) : !this.moveItemStackTo(stackInSlot, 0, containerSlots, false)) {
                return ItemStack.EMPTY;
            }
            if (stackInSlot.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public AwakenedEndRodBE getBlockEntity() {
        return this.blockEntity;
    }
}

