/*
 * Decompiled with CFR 0.152.
 */
package net.thedragonskull.rodsawaken.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.items.SlotItemHandler;
import net.neoforged.neoforge.network.PacketDistributor;
import net.thedragonskull.rodsawaken.block.entity.AwakenedEndRodBE;
import net.thedragonskull.rodsawaken.network.C2SClearPotionSlotPacket;
import net.thedragonskull.rodsawaken.network.C2SToggleBlockedSlotPacket;
import net.thedragonskull.rodsawaken.screen.AwakenedEndRodMenu;
import net.thedragonskull.rodsawaken.util.SensorSlotTooltip;

public class AwakenedEndRodScreen
extends AbstractContainerScreen<AwakenedEndRodMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"rodsawaken", (String)"textures/gui/awakened_end_rod_screen.png");

    public AwakenedEndRodScreen(AwakenedEndRodMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void init() {
        super.init();
        this.titleLabelY = 100000;
        this.inventoryLabelY = 100000;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        AwakenedEndRodBE be = ((AwakenedEndRodMenu)this.menu).getBlockEntity();
        int MAX_BAR_WIDTH = 18;
        int BAR_HEIGHT = 4;
        int[] barX = new int[]{30, 64, 98};
        int barY = 10;
        for (int i = 0; i < 3; ++i) {
            int texX;
            float progress = be.getPotionProgress(i);
            int width = (int)(progress * (float)MAX_BAR_WIDTH);
            if (width > 0) {
                int color = be.getPotionColor(i) | 0xFF000000;
                guiGraphics.fill(x + barX[i], y + barY, x + barX[i] + width, y + barY + BAR_HEIGHT, color);
                List<MobEffectInstance> effects = be.getPotionEffects(i);
                if (effects != null && !effects.isEmpty() && this.minecraft != null) {
                    MobEffectInstance effectInstance;
                    if (effects.size() == 1) {
                        effectInstance = effects.get(0);
                    } else {
                        int index = (int)(System.currentTimeMillis() / 1000L % (long)effects.size());
                        effectInstance = effects.get(index);
                    }
                    Holder mobEffect = effectInstance.getEffect();
                    TextureAtlasSprite sprite = this.minecraft.getMobEffectTextures().get(mobEffect);
                    int atlasSize = 128;
                    int u0 = (int)(sprite.getU0() * (float)atlasSize);
                    int v0 = (int)(sprite.getV0() * (float)atlasSize);
                    int u1 = (int)(sprite.getU1() * (float)atlasSize);
                    int v1 = (int)(sprite.getV1() * (float)atlasSize);
                    guiGraphics.blit(sprite.atlasLocation(), x + barX[i], y + 19, 18, 18, (float)u0, (float)v0, u1 - u0, v1 - v0, atlasSize, atlasSize);
                }
            }
            int baseX = x + 34;
            int baseY = y + 62;
            int separation = 34;
            int btnX = baseX + i * separation;
            int btnY = baseY;
            boolean hovered = mouseX >= btnX && mouseX <= btnX + 10 && mouseY >= btnY && mouseY <= btnY + 10;
            boolean hasEffect = be.hasEffectInSlot(i);
            if (hasEffect) {
                texX = 0;
                if (hovered) {
                    texX = 22;
                }
            } else {
                texX = 11;
            }
            int texY = 166;
            guiGraphics.blit(TEXTURE, btnX, btnY, texX, texY, 11, 11);
            if (!hovered) continue;
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)"Clear Effect"), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int baseX = (this.width - this.imageWidth) / 2 + 34;
            int baseY = (this.height - this.imageHeight) / 2 + 62;
            int separation = 34;
            for (int i = 0; i < 3; ++i) {
                int btnX = baseX + i * separation;
                int btnY = baseY;
                if (mouseX >= (double)btnX && mouseX <= (double)(btnX + 11) && mouseY >= (double)btnY && mouseY <= (double)(btnY + 11)) {
                    if (((AwakenedEndRodMenu)this.menu).getBlockEntity().hasEffectInSlot(i)) {
                        this.onPotionButtonClicked(i);
                        ((AwakenedEndRodMenu)this.menu).getBlockEntity().clearPotionSlot(i);
                    }
                    return true;
                }
                int x = (this.width - this.imageWidth) / 2;
                int y = (this.height - this.imageHeight) / 2;
                int[] barX = new int[]{30, 64, 98};
                int iconY = y + 19;
                int iconX = x + barX[i];
                int iconEndX = iconX + 18;
                int iconEndY = iconY + 18;
                if (!(mouseX >= (double)iconX) || !(mouseX <= (double)iconEndX) || !(mouseY >= (double)iconY) || !(mouseY <= (double)iconEndY)) continue;
                if (Screen.hasShiftDown()) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new C2SToggleBlockedSlotPacket(i), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void onPotionButtonClicked(int slot) {
        BlockPos pos = ((AwakenedEndRodMenu)this.menu).getBlockEntity().getBlockPos();
        PacketDistributor.sendToServer((CustomPacketPayload)new C2SClearPotionSlotPacket(slot, pos), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        AwakenedEndRodBE be = ((AwakenedEndRodMenu)this.menu).getBlockEntity();
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        int MAX_BAR_WIDTH = 19;
        int BAR_HEIGHT = 5;
        int[] barX = new int[]{29, 63, 97};
        int barY = 9;
        for (int i = 0; i < 3; ++i) {
            boolean hoverIcon;
            float progress = be.getPotionProgress(i);
            if (progress > 0.0f) {
                int ticksLeft;
                int barStartX = x + barX[i];
                int barStartY = y + barY;
                int barEndX = barStartX + MAX_BAR_WIDTH;
                int barEndY = barStartY + BAR_HEIGHT;
                if (mouseX >= barStartX && mouseX <= barEndX && mouseY >= barStartY && mouseY <= barEndY && (ticksLeft = be.getPotionTimeLeft(i)) > 0) {
                    String formatted = this.formatTime(ticksLeft);
                    MutableComponent tooltip = Component.literal((String)formatted);
                    guiGraphics.renderTooltip(this.font, (Component)tooltip, mouseX, mouseY);
                }
            }
            int iconX = x + barX[i];
            int iconY = y + 18;
            int iconEndX = iconX + 19;
            int iconEndY = iconY + 19;
            boolean bl = hoverIcon = mouseX >= iconX && mouseX <= iconEndX && mouseY >= iconY && mouseY <= iconEndY;
            if (hoverIcon) {
                ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>();
                if (Screen.hasShiftDown()) {
                    if (be.isSlotBlocked(i)) {
                        tooltips.add(Component.literal((String)"\u00a7cLocked"));
                    } else {
                        tooltips.add(Component.literal((String)"\u00a7aUnlocked"));
                    }
                } else {
                    List<MobEffectInstance> effects = be.getPotionEffects(i);
                    if (!effects.isEmpty()) {
                        for (MobEffectInstance effect : effects) {
                            MutableComponent name = Component.translatable((String)effect.getDescriptionId());
                            int amp = effect.getAmplifier();
                            if (amp > 0) {
                                name = name.append(" ").append((Component)Component.translatable((String)("potion.potency." + amp)));
                            }
                            tooltips.add(name);
                        }
                    }
                }
                if (!tooltips.isEmpty()) {
                    guiGraphics.renderComponentTooltip(this.font, tooltips, mouseX, mouseY);
                }
            }
            if (be.isSlotBlocked(i)) {
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                guiGraphics.blit(TEXTURE, iconX + 1, iconY + 1, 0, 177, 18, 18);
                RenderSystem.disableBlend();
            }
            if (!hoverIcon) continue;
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            if (Screen.hasShiftDown() && !be.isSlotBlocked(i)) {
                guiGraphics.blit(TEXTURE, iconX + 1, iconY + 1, 18, 177, 18, 18);
            }
            RenderSystem.disableBlend();
        }
    }

    private String formatTime(int ticks) {
        int totalSeconds = ticks / 20;
        int minutes = totalSeconds / 60;
        int seconds = totalSeconds % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        SlotItemHandler slotHandler;
        Slot slot = this.hoveredSlot;
        if (slot instanceof SlotItemHandler && (slotHandler = (SlotItemHandler)slot).getItemHandler() == ((AwakenedEndRodMenu)this.menu).getBlockEntity().getItems()) {
            ItemStack carried;
            int blockSlotIndex = slotHandler.getSlotIndex();
            if (blockSlotIndex >= 0 && blockSlotIndex <= 2 && !(carried = ((AwakenedEndRodMenu)this.menu).getCarried()).isEmpty() && carried.is(Items.POTION) && !((AwakenedEndRodMenu)this.menu).getBlockEntity().getPotionEffects(blockSlotIndex).isEmpty()) {
                guiGraphics.renderTooltip(this.font, List.of(Component.literal((String)"Clear the current effect first!").withStyle(ChatFormatting.RED)), Optional.empty(), mouseX, mouseY);
                return;
            }
            if (blockSlotIndex == 3) {
                if (Screen.hasShiftDown()) {
                    guiGraphics.renderTooltip(this.font, List.of(Component.literal((String)" ")), Optional.of(new SensorSlotTooltip()), mouseX, mouseY);
                } else {
                    guiGraphics.renderTooltip(this.font, List.of(Component.literal((String)"Sculk Sensor Slot").withStyle(ChatFormatting.GRAY), Component.literal((String)"Press Shift for more info").withStyle(ChatFormatting.YELLOW)), Optional.empty(), mouseX, mouseY);
                }
                return;
            }
        }
        super.renderTooltip(guiGraphics, mouseX, mouseY);
    }
}

