/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.bonsai.ghosts.client.entity.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xylonity.bonsai.ghosts.client.entity.model.GhostModel;
import dev.xylonity.bonsai.ghosts.client.entity.render.core.BaseGhostRenderer;
import dev.xylonity.bonsai.ghosts.common.entity.ghost.GhostEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.AbstractSkullBlock;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import software.bernie.geckolib.renderer.layer.ItemArmorGeoLayer;
import software.bernie.geckolib.util.RenderUtil;

public class GhostRenderer
extends BaseGhostRenderer<GhostEntity> {
    public GhostRenderer(EntityRendererProvider.Context context) {
        super(context, new GhostModel());
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer((GeoRenderer)this));
        this.addRenderLayer((GeoRenderLayer)new HeadAnyItemArmorAwareLayer((GeoRenderer<GhostEntity>)this, "glow_1"));
        this.addRenderLayer((GeoRenderLayer)new ItemArmorGeoLayer<GhostEntity>(this, (GeoRenderer)this){

            protected ItemStack getArmorItemForBone(GeoBone bone, GhostEntity animatable) {
                if ("glow_1".equals(bone.getName())) {
                    return this.helmetStack;
                }
                return null;
            }

            protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, GhostEntity animatable) {
                if ("glow_1".equals(bone.getName())) {
                    return EquipmentSlot.HEAD;
                }
                return super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
            }

            protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, GhostEntity animatable, HumanoidModel<?> baseModel) {
                if ("glow_1".equals(bone.getName())) {
                    return baseModel.head;
                }
                return super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
            }

            protected void prepModelPartForRender(PoseStack poseStack, GeoBone bone, ModelPart sourcePart) {
                super.prepModelPartForRender(poseStack, bone, sourcePart);
                if ("glow_1".equals(bone.getName())) {
                    poseStack.translate(0.0, -0.1, 0.0);
                }
            }
        });
    }

    @Override
    public void renderRecursively(PoseStack poseStack, GhostEntity animatable, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int colour) {
        if ("mushroom_red".equals(bone.getName()) || "mushroom_brown".equals(bone.getName())) {
            ItemStack head = animatable.getItemBySlot(EquipmentSlot.HEAD);
            if ("mushroom_red".equals(bone.getName()) && !GhostRenderer.isRedMush(head)) {
                return;
            }
            if ("mushroom_brown".equals(bone.getName()) && !GhostRenderer.isBrownMush(head)) {
                return;
            }
        }
        super.renderRecursively(poseStack, animatable, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, colour);
    }

    private static boolean isRedMush(ItemStack s) {
        return s.is(Items.RED_MUSHROOM);
    }

    private static boolean isBrownMush(ItemStack s) {
        return s.is(Items.BROWN_MUSHROOM);
    }

    public static class HeadAnyItemArmorAwareLayer
    extends ItemArmorGeoLayer<GhostEntity> {
        private final String headBoneName;

        public HeadAnyItemArmorAwareLayer(GeoRenderer<GhostEntity> renderer, String headBoneName) {
            super(renderer);
            this.headBoneName = headBoneName;
        }

        protected ItemStack getArmorItemForBone(GeoBone bone, GhostEntity animatable) {
            if (this.headBoneName.equals(bone.getName())) {
                return this.helmetStack;
            }
            return null;
        }

        protected EquipmentSlot getEquipmentSlotForBone(GeoBone bone, ItemStack stack, GhostEntity animatable) {
            if (this.headBoneName.equals(bone.getName())) {
                return EquipmentSlot.HEAD;
            }
            return super.getEquipmentSlotForBone(bone, stack, (LivingEntity)animatable);
        }

        protected ModelPart getModelPartForBone(GeoBone bone, EquipmentSlot slot, ItemStack stack, GhostEntity animatable, HumanoidModel<?> baseModel) {
            if (this.headBoneName.equals(bone.getName())) {
                return baseModel.head;
            }
            return super.getModelPartForBone(bone, slot, stack, (LivingEntity)animatable, baseModel);
        }

        public void renderForBone(PoseStack poseStack, GhostEntity anim, GeoBone bone, RenderType renderType, MultiBufferSource buffers, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
            BlockItem block;
            ItemStack stack = this.getArmorItemForBone(bone, anim);
            if (stack == null || stack.isEmpty()) {
                return;
            }
            if (GhostRenderer.isRedMush(stack) || GhostRenderer.isBrownMush(stack)) {
                return;
            }
            if (stack.getItem() instanceof ArmorItem) {
                return;
            }
            Item item = stack.getItem();
            if (item instanceof BlockItem && (block = (BlockItem)item).getBlock() instanceof AbstractSkullBlock) {
                super.renderForBone(poseStack, (LivingEntity)anim, bone, renderType, buffers, buffer, partialTick, packedLight, packedOverlay);
                return;
            }
            HumanoidModel model = this.getModelForItem(bone, EquipmentSlot.HEAD, stack, (LivingEntity)anim);
            try {
                this.getReferenceCubeForModel(bone, this.getModelPartForBone(bone, EquipmentSlot.HEAD, stack, anim, model));
            }
            catch (IndexOutOfBoundsException ex) {
                return;
            }
            poseStack.pushPose();
            RenderUtil.translateMatrixToBone((PoseStack)poseStack, (GeoBone)bone);
            RenderUtil.translateToPivotPoint((PoseStack)poseStack, (GeoBone)bone);
            RenderUtil.rotateMatrixAroundBone((PoseStack)poseStack, (GeoBone)bone);
            RenderUtil.scaleMatrixForBone((PoseStack)poseStack, (GeoBone)bone);
            RenderUtil.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoBone)bone);
            poseStack.scale(0.5125f, 0.5125f, 0.5125f);
            poseStack.translate(0.0f, 0.5f, 0.0f);
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.NONE, packedLight, OverlayTexture.NO_OVERLAY, poseStack, buffers, anim.level(), 0);
            poseStack.popPose();
            buffers.getBuffer(renderType);
        }
    }
}

